use druid::*;
use crate::object::CanvasObject;
use std::rc::Rc;
use std::cell::RefCell;

#[derive(Clone, Lens, Data)]
pub struct AppData {
    pub objects: Rc<RefCell<Vec<Box<dyn CanvasObject>>>>,
}

impl AppData {
    pub fn new() -> AppData {
        AppData {
            objects: Default::default()
        }
    }
}