use druid::piet::kurbo::Rect;
use druid::piet::*;
use druid::*;
use druid::RenderContext;
use druid::kurbo::Line as KurboLine;

// an object drawable on canvas, usually very simple
// has to have a few properties we use throughout the whole project
pub trait CanvasObject {
    fn render(&self, ctx: &mut PaintCtx, env: &Env);
    fn bounding_box(&self) -> Rect;
}

pub struct Line {
    from: Point,
    to: Point,
}

impl Line {
    pub fn new(from: Point, to: Point) -> Line {
        Line {
            from,
            to
        }
    }
}

impl Into<KurboLine> for Line {
    fn into(self) -> KurboLine {
        KurboLine::new(self.from, self.to)
    }
}

impl CanvasObject for Line {
    fn render(&self, ctx: &mut PaintCtx, _env: &Env){
        ctx.stroke(KurboLine::new(self.from, self.to), &Color::grey8(0), 1.0);
    }
    fn bounding_box(&self) -> Rect {
        todo!()
    }
}