mod canvas;
mod state;
mod object;

use druid::{AppLauncher, WindowDesc, Widget, PlatformError};
use druid::widget::*;
use simple_logger::SimpleLogger;

use state::AppData;
use canvas::get_canvas_widget;


fn main() -> Result<(), PlatformError> {
    SimpleLogger::new().env().init().expect("Unable to start logger.");
    AppLauncher::with_window(
        WindowDesc::new(build_ui).title("chalkboard")
    ).launch(AppData::new())?;
    Ok(())
}

fn build_ui() -> impl Widget<AppData> {
    Flex::column()
        .with_flex_child(get_canvas_widget(), 1.0)
}
