#![doc = "Peripheral access API for CH32V307XX microcontrollers (generated using svd2rust v0.23.1 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.23.1/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[allow(unused_imports)]
use generic::*;
#[doc = "Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn WWDG();
    fn PVD();
    fn TAMPER();
    fn RTC();
    fn FLASH();
    fn RCC();
    fn EXTI0();
    fn EXTI1();
    fn EXTI2();
    fn EXTI3();
    fn EXTI4();
    fn DMA1_CHANNEL1();
    fn DMA1_CHANNEL2();
    fn DMA1_CHANNEL3();
    fn DMA1_CHANNEL4();
    fn DMA1_CHANNEL5();
    fn DMA1_CHANNEL6();
    fn DMA1_CHANNEL7();
    fn ADC();
    fn USB_HP_CAN1_TX_IRQN();
    fn USB_LP_CAN1_RX0_IRQN();
    fn CAN1_RX1();
    fn CAN1_SCE();
    fn EXTI9_5();
    fn TIM1_BRK();
    fn TIM1_UP();
    fn TIM1_TRG_COM();
    fn TIM1_CC();
    fn TIM2();
    fn TIM3();
    fn TIM4();
    fn I2C1_EV();
    fn I2C1_ER();
    fn I2C2_EV();
    fn I2C2_ER();
    fn SPI1();
    fn SPI2();
    fn USART1();
    fn USART2();
    fn USART3();
    fn EXTI15_10();
    fn RTCALARM();
    fn USBWAKEUP_IRQN();
    fn TIM8_BRK();
    fn TIM8_UP();
    fn TIM8_TRG_COM();
    fn TIM8_CC();
    fn RNG();
    fn FSMC();
    fn SDIO();
    fn TIM5();
    fn SPI3();
    fn UART4();
    fn UART5();
    fn DMA2_CHANNEL1();
    fn DMA2_CHANNEL2();
    fn DMA2_CHANNEL3();
    fn DMA2_CHANNEL4();
    fn DMA2_CHANNEL5();
    fn ETH();
    fn ETH_WKUP();
    fn CAN2_TX();
    fn CAN2_RX0();
    fn CAN2_RX1();
    fn CAN2_SCE();
    fn OTG_FS_IRQN();
    fn USBHSWAKEUP_IRQN();
    fn USBHS_IRQN();
    fn DVP();
    fn UART6();
    fn UART7();
    fn UART8();
    fn TIM9_BRK();
    fn TIM9_UP();
    fn TIM9_TRG_COM();
    fn TIM9_CC();
    fn TIM10_BRK();
    fn TIM10_UP();
    fn TIM10_TRG_COM();
    fn TIM10_CC();
    fn DMA2_CHANNEL6();
    fn DMA2_CHANNEL7();
    fn DMA2_CHANNEL8();
    fn DMA2_CHANNEL9();
    fn DMA2_CHANNEL10();
    fn DMA2_CHANNEL11();
}
#[doc(hidden)]
pub union Vector {
    pub _handler: unsafe extern "C" fn(),
    pub _reserved: usize,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[no_mangle]
pub static __EXTERNAL_INTERRUPTS: [Vector; 104] = [
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: WWDG },
    Vector { _handler: PVD },
    Vector { _handler: TAMPER },
    Vector { _handler: RTC },
    Vector { _handler: FLASH },
    Vector { _handler: RCC },
    Vector { _handler: EXTI0 },
    Vector { _handler: EXTI1 },
    Vector { _handler: EXTI2 },
    Vector { _handler: EXTI3 },
    Vector { _handler: EXTI4 },
    Vector {
        _handler: DMA1_CHANNEL1,
    },
    Vector {
        _handler: DMA1_CHANNEL2,
    },
    Vector {
        _handler: DMA1_CHANNEL3,
    },
    Vector {
        _handler: DMA1_CHANNEL4,
    },
    Vector {
        _handler: DMA1_CHANNEL5,
    },
    Vector {
        _handler: DMA1_CHANNEL6,
    },
    Vector {
        _handler: DMA1_CHANNEL7,
    },
    Vector { _handler: ADC },
    Vector {
        _handler: USB_HP_CAN1_TX_IRQN,
    },
    Vector {
        _handler: USB_LP_CAN1_RX0_IRQN,
    },
    Vector { _handler: CAN1_RX1 },
    Vector { _handler: CAN1_SCE },
    Vector { _handler: EXTI9_5 },
    Vector { _handler: TIM1_BRK },
    Vector { _handler: TIM1_UP },
    Vector {
        _handler: TIM1_TRG_COM,
    },
    Vector { _handler: TIM1_CC },
    Vector { _handler: TIM2 },
    Vector { _handler: TIM3 },
    Vector { _handler: TIM4 },
    Vector { _handler: I2C1_EV },
    Vector { _handler: I2C1_ER },
    Vector { _handler: I2C2_EV },
    Vector { _handler: I2C2_ER },
    Vector { _handler: SPI1 },
    Vector { _handler: SPI2 },
    Vector { _handler: USART1 },
    Vector { _handler: USART2 },
    Vector { _handler: USART3 },
    Vector {
        _handler: EXTI15_10,
    },
    Vector { _handler: RTCALARM },
    Vector {
        _handler: USBWAKEUP_IRQN,
    },
    Vector { _handler: TIM8_BRK },
    Vector { _handler: TIM8_UP },
    Vector {
        _handler: TIM8_TRG_COM,
    },
    Vector { _handler: TIM8_CC },
    Vector { _handler: RNG },
    Vector { _handler: FSMC },
    Vector { _handler: SDIO },
    Vector { _handler: TIM5 },
    Vector { _handler: SPI3 },
    Vector { _handler: UART4 },
    Vector { _handler: UART5 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: DMA2_CHANNEL1,
    },
    Vector {
        _handler: DMA2_CHANNEL2,
    },
    Vector {
        _handler: DMA2_CHANNEL3,
    },
    Vector {
        _handler: DMA2_CHANNEL4,
    },
    Vector {
        _handler: DMA2_CHANNEL5,
    },
    Vector { _handler: ETH },
    Vector { _handler: ETH_WKUP },
    Vector { _handler: CAN2_TX },
    Vector { _handler: CAN2_RX0 },
    Vector { _handler: CAN2_RX1 },
    Vector { _handler: CAN2_SCE },
    Vector {
        _handler: OTG_FS_IRQN,
    },
    Vector {
        _handler: USBHSWAKEUP_IRQN,
    },
    Vector {
        _handler: USBHS_IRQN,
    },
    Vector { _handler: DVP },
    Vector { _handler: UART6 },
    Vector { _handler: UART7 },
    Vector { _handler: UART8 },
    Vector { _handler: TIM9_BRK },
    Vector { _handler: TIM9_UP },
    Vector {
        _handler: TIM9_TRG_COM,
    },
    Vector { _handler: TIM9_CC },
    Vector {
        _handler: TIM10_BRK,
    },
    Vector { _handler: TIM10_UP },
    Vector {
        _handler: TIM10_TRG_COM,
    },
    Vector { _handler: TIM10_CC },
    Vector {
        _handler: DMA2_CHANNEL6,
    },
    Vector {
        _handler: DMA2_CHANNEL7,
    },
    Vector {
        _handler: DMA2_CHANNEL8,
    },
    Vector {
        _handler: DMA2_CHANNEL9,
    },
    Vector {
        _handler: DMA2_CHANNEL10,
    },
    Vector {
        _handler: DMA2_CHANNEL11,
    },
];
#[doc(hidden)]
pub mod interrupt {
    #[doc = r"Enumeration of all the interrupts."]
    #[derive(Copy, Clone, Debug, PartialEq, Eq)]
    #[repr(u16)]
    pub enum Interrupt {
        #[doc = "16 - Window Watchdog interrupt"]
        WWDG = 16,
        #[doc = "17 - PVD through EXTI line detection interrupt"]
        PVD = 17,
        #[doc = "18 - Tamper interrupt"]
        TAMPER = 18,
        #[doc = "19 - RTC global interrupt"]
        RTC = 19,
        #[doc = "20 - Flash global interrupt"]
        FLASH = 20,
        #[doc = "21 - RCC global interrupt"]
        RCC = 21,
        #[doc = "22 - EXTI Line0 interrupt"]
        EXTI0 = 22,
        #[doc = "23 - EXTI Line1 interrupt"]
        EXTI1 = 23,
        #[doc = "24 - EXTI Line2 interrupt"]
        EXTI2 = 24,
        #[doc = "25 - EXTI Line3 interrupt"]
        EXTI3 = 25,
        #[doc = "26 - EXTI Line4 interrupt"]
        EXTI4 = 26,
        #[doc = "27 - DMA1 Channel1 global interrupt"]
        DMA1_CHANNEL1 = 27,
        #[doc = "28 - DMA1 Channel2 global interrupt"]
        DMA1_CHANNEL2 = 28,
        #[doc = "29 - DMA1 Channel3 global interrupt"]
        DMA1_CHANNEL3 = 29,
        #[doc = "30 - DMA1 Channel4 global interrupt"]
        DMA1_CHANNEL4 = 30,
        #[doc = "31 - DMA1 Channel5 global interrupt"]
        DMA1_CHANNEL5 = 31,
        #[doc = "32 - DMA1 Channel6 global interrupt"]
        DMA1_CHANNEL6 = 32,
        #[doc = "33 - DMA1 Channel7 global interrupt"]
        DMA1_CHANNEL7 = 33,
        #[doc = "34 - ADC global interrupt"]
        ADC = 34,
        #[doc = "35 - CAN1 TX interrupts"]
        USB_HP_CAN1_TX_IRQN = 35,
        #[doc = "36 - CAN1 RX0 interrupts"]
        USB_LP_CAN1_RX0_IRQN = 36,
        #[doc = "37 - CAN1 RX1 interrupt"]
        CAN1_RX1 = 37,
        #[doc = "38 - CAN1 SCE interrupt"]
        CAN1_SCE = 38,
        #[doc = "39 - EXTI Line\\[9:5\\]
interrupts"]
        EXTI9_5 = 39,
        #[doc = "40 - TIM1 Break interrupt"]
        TIM1_BRK = 40,
        #[doc = "41 - TIM1 Update interrupt"]
        TIM1_UP = 41,
        #[doc = "42 - TIM1 Trigger and Commutation interrupts"]
        TIM1_TRG_COM = 42,
        #[doc = "43 - TIM1 Capture Compare interrupt"]
        TIM1_CC = 43,
        #[doc = "44 - TIM2 global interrupt"]
        TIM2 = 44,
        #[doc = "45 - TIM3 global interrupt"]
        TIM3 = 45,
        #[doc = "46 - TIM4 global interrupt"]
        TIM4 = 46,
        #[doc = "47 - I2C1 event interrupt"]
        I2C1_EV = 47,
        #[doc = "48 - I2C1 error interrupt"]
        I2C1_ER = 48,
        #[doc = "49 - I2C2 event interrupt"]
        I2C2_EV = 49,
        #[doc = "50 - I2C2 error interrupt"]
        I2C2_ER = 50,
        #[doc = "51 - SPI1 global interrupt"]
        SPI1 = 51,
        #[doc = "52 - SPI2 global interrupt"]
        SPI2 = 52,
        #[doc = "53 - USART1 global interrupt"]
        USART1 = 53,
        #[doc = "54 - USART2 global interrupt"]
        USART2 = 54,
        #[doc = "55 - USART3 global interrupt"]
        USART3 = 55,
        #[doc = "56 - EXTI Line\\[15:10\\]
interrupts"]
        EXTI15_10 = 56,
        #[doc = "57 - RTC Alarms through EXTI line interrupt"]
        RTCALARM = 57,
        #[doc = "58 - USB Device WakeUp from suspend through EXTI Line Interrupt"]
        USBWAKEUP_IRQN = 58,
        #[doc = "59 - TIM8 Break interrupt"]
        TIM8_BRK = 59,
        #[doc = "60 - TIM8 Update interrupt"]
        TIM8_UP = 60,
        #[doc = "61 - TIM8 Trigger and Commutation interrupts"]
        TIM8_TRG_COM = 61,
        #[doc = "62 - TIM8 Capture Compare interrupt"]
        TIM8_CC = 62,
        #[doc = "63 - RNG interrupt"]
        RNG = 63,
        #[doc = "64 - FSMC global interrupt"]
        FSMC = 64,
        #[doc = "65 - SDIO global interrupt"]
        SDIO = 65,
        #[doc = "66 - TIM5 global interrupt"]
        TIM5 = 66,
        #[doc = "67 - SPI3 global interrupt"]
        SPI3 = 67,
        #[doc = "68 - UART4 global interrupt"]
        UART4 = 68,
        #[doc = "69 - UART5 global interrupt"]
        UART5 = 69,
        #[doc = "72 - DMA2 Channel1 global interrupt"]
        DMA2_CHANNEL1 = 72,
        #[doc = "73 - DMA2 Channel2 global interrupt"]
        DMA2_CHANNEL2 = 73,
        #[doc = "74 - DMA2 Channel3 global interrupt"]
        DMA2_CHANNEL3 = 74,
        #[doc = "75 - DMA2 Channel4 global interrupt"]
        DMA2_CHANNEL4 = 75,
        #[doc = "76 - DMA2 Channel5 global interrupt"]
        DMA2_CHANNEL5 = 76,
        #[doc = "77 - Ethernet global interrupt"]
        ETH = 77,
        #[doc = "78 - Ethernet Wakeup through EXTI line interrupt"]
        ETH_WKUP = 78,
        #[doc = "79 - CAN2 TX interrupts"]
        CAN2_TX = 79,
        #[doc = "80 - CAN2 RX0 interrupts"]
        CAN2_RX0 = 80,
        #[doc = "81 - CAN2 RX1 interrupt"]
        CAN2_RX1 = 81,
        #[doc = "82 - CAN2 SCE interrupt"]
        CAN2_SCE = 82,
        #[doc = "83 - OTG_FS_IRQn"]
        OTG_FS_IRQN = 83,
        #[doc = "84 - USBHSWakeup_IRQn"]
        USBHSWAKEUP_IRQN = 84,
        #[doc = "85 - USBHS_IRQn"]
        USBHS_IRQN = 85,
        #[doc = "86 - DVP global Interrupt interrupt"]
        DVP = 86,
        #[doc = "87 - UART6 global interrupt"]
        UART6 = 87,
        #[doc = "88 - UART7 global interrupt"]
        UART7 = 88,
        #[doc = "89 - UART8 global interrupt"]
        UART8 = 89,
        #[doc = "90 - TIM9 Break interrupt"]
        TIM9_BRK = 90,
        #[doc = "91 - TIM9 Update interrupt"]
        TIM9_UP = 91,
        #[doc = "92 - TIM9 Trigger and Commutation interrupts"]
        TIM9_TRG_COM = 92,
        #[doc = "93 - TIM9 Capture Compare interrupt"]
        TIM9_CC = 93,
        #[doc = "94 - TIM10 Break interrupt"]
        TIM10_BRK = 94,
        #[doc = "95 - TIM10 Update interrupt"]
        TIM10_UP = 95,
        #[doc = "96 - TIM10 Trigger and Commutation interrupts"]
        TIM10_TRG_COM = 96,
        #[doc = "97 - TIM10 Capture Compare interrupt"]
        TIM10_CC = 97,
        #[doc = "98 - DMA2 Channel6 global interrupt"]
        DMA2_CHANNEL6 = 98,
        #[doc = "99 - DMA2 Channel7 global interrupt"]
        DMA2_CHANNEL7 = 99,
        #[doc = "100 - DMA2 Channel8 global interrupt"]
        DMA2_CHANNEL8 = 100,
        #[doc = "101 - DMA2 Channel9 global interrupt"]
        DMA2_CHANNEL9 = 101,
        #[doc = "102 - DMA2 Channel10 global interrupt"]
        DMA2_CHANNEL10 = 102,
        #[doc = "103 - DMA2 Channel11 global interrupt"]
        DMA2_CHANNEL11 = 103,
    }
    #[doc = r" TryFromInterruptError"]
    #[derive(Debug, Copy, Clone)]
    pub struct TryFromInterruptError(());
    impl Interrupt {
        #[doc = r" Attempt to convert a given value into an `Interrupt`"]
        #[inline]
        pub fn try_from(value: u8) -> Result<Self, TryFromInterruptError> {
            match value {
                16 => Ok(Interrupt::WWDG),
                17 => Ok(Interrupt::PVD),
                18 => Ok(Interrupt::TAMPER),
                19 => Ok(Interrupt::RTC),
                20 => Ok(Interrupt::FLASH),
                21 => Ok(Interrupt::RCC),
                22 => Ok(Interrupt::EXTI0),
                23 => Ok(Interrupt::EXTI1),
                24 => Ok(Interrupt::EXTI2),
                25 => Ok(Interrupt::EXTI3),
                26 => Ok(Interrupt::EXTI4),
                27 => Ok(Interrupt::DMA1_CHANNEL1),
                28 => Ok(Interrupt::DMA1_CHANNEL2),
                29 => Ok(Interrupt::DMA1_CHANNEL3),
                30 => Ok(Interrupt::DMA1_CHANNEL4),
                31 => Ok(Interrupt::DMA1_CHANNEL5),
                32 => Ok(Interrupt::DMA1_CHANNEL6),
                33 => Ok(Interrupt::DMA1_CHANNEL7),
                34 => Ok(Interrupt::ADC),
                35 => Ok(Interrupt::USB_HP_CAN1_TX_IRQN),
                36 => Ok(Interrupt::USB_LP_CAN1_RX0_IRQN),
                37 => Ok(Interrupt::CAN1_RX1),
                38 => Ok(Interrupt::CAN1_SCE),
                39 => Ok(Interrupt::EXTI9_5),
                40 => Ok(Interrupt::TIM1_BRK),
                41 => Ok(Interrupt::TIM1_UP),
                42 => Ok(Interrupt::TIM1_TRG_COM),
                43 => Ok(Interrupt::TIM1_CC),
                44 => Ok(Interrupt::TIM2),
                45 => Ok(Interrupt::TIM3),
                46 => Ok(Interrupt::TIM4),
                47 => Ok(Interrupt::I2C1_EV),
                48 => Ok(Interrupt::I2C1_ER),
                49 => Ok(Interrupt::I2C2_EV),
                50 => Ok(Interrupt::I2C2_ER),
                51 => Ok(Interrupt::SPI1),
                52 => Ok(Interrupt::SPI2),
                53 => Ok(Interrupt::USART1),
                54 => Ok(Interrupt::USART2),
                55 => Ok(Interrupt::USART3),
                56 => Ok(Interrupt::EXTI15_10),
                57 => Ok(Interrupt::RTCALARM),
                58 => Ok(Interrupt::USBWAKEUP_IRQN),
                59 => Ok(Interrupt::TIM8_BRK),
                60 => Ok(Interrupt::TIM8_UP),
                61 => Ok(Interrupt::TIM8_TRG_COM),
                62 => Ok(Interrupt::TIM8_CC),
                63 => Ok(Interrupt::RNG),
                64 => Ok(Interrupt::FSMC),
                65 => Ok(Interrupt::SDIO),
                66 => Ok(Interrupt::TIM5),
                67 => Ok(Interrupt::SPI3),
                68 => Ok(Interrupt::UART4),
                69 => Ok(Interrupt::UART5),
                72 => Ok(Interrupt::DMA2_CHANNEL1),
                73 => Ok(Interrupt::DMA2_CHANNEL2),
                74 => Ok(Interrupt::DMA2_CHANNEL3),
                75 => Ok(Interrupt::DMA2_CHANNEL4),
                76 => Ok(Interrupt::DMA2_CHANNEL5),
                77 => Ok(Interrupt::ETH),
                78 => Ok(Interrupt::ETH_WKUP),
                79 => Ok(Interrupt::CAN2_TX),
                80 => Ok(Interrupt::CAN2_RX0),
                81 => Ok(Interrupt::CAN2_RX1),
                82 => Ok(Interrupt::CAN2_SCE),
                83 => Ok(Interrupt::OTG_FS_IRQN),
                84 => Ok(Interrupt::USBHSWAKEUP_IRQN),
                85 => Ok(Interrupt::USBHS_IRQN),
                86 => Ok(Interrupt::DVP),
                87 => Ok(Interrupt::UART6),
                88 => Ok(Interrupt::UART7),
                89 => Ok(Interrupt::UART8),
                90 => Ok(Interrupt::TIM9_BRK),
                91 => Ok(Interrupt::TIM9_UP),
                92 => Ok(Interrupt::TIM9_TRG_COM),
                93 => Ok(Interrupt::TIM9_CC),
                94 => Ok(Interrupt::TIM10_BRK),
                95 => Ok(Interrupt::TIM10_UP),
                96 => Ok(Interrupt::TIM10_TRG_COM),
                97 => Ok(Interrupt::TIM10_CC),
                98 => Ok(Interrupt::DMA2_CHANNEL6),
                99 => Ok(Interrupt::DMA2_CHANNEL7),
                100 => Ok(Interrupt::DMA2_CHANNEL8),
                101 => Ok(Interrupt::DMA2_CHANNEL9),
                102 => Ok(Interrupt::DMA2_CHANNEL10),
                103 => Ok(Interrupt::DMA2_CHANNEL11),
                _ => Err(TryFromInterruptError(())),
            }
        }
    }
    #[cfg(feature = "rt")]
    #[macro_export]
    #[doc = r" Assigns a handler to an interrupt"]
    #[doc = r""]
    #[doc = r" This macro takes two arguments: the name of an interrupt and the path to the"]
    #[doc = r" function that will be used as the handler of that interrupt. That function"]
    #[doc = r" must have signature `fn()`."]
    #[doc = r""]
    #[doc = r" Optionally, a third argument may be used to declare interrupt local data."]
    #[doc = r" The handler will have exclusive access to these *local* variables on each"]
    #[doc = r" invocation. If the third argument is used then the signature of the handler"]
    #[doc = r" function must be `fn(&mut $NAME::Locals)` where `$NAME` is the first argument"]
    #[doc = r" passed to the macro."]
    #[doc = r""]
    #[doc = r" # Example"]
    #[doc = r""]
    #[doc = r" ``` ignore"]
    #[doc = r" interrupt!(TIM2, periodic);"]
    #[doc = r""]
    #[doc = r" fn periodic() {"]
    #[doc = r#"     print!(".");"#]
    #[doc = r" }"]
    #[doc = r""]
    #[doc = r" interrupt!(TIM3, tick, locals: {"]
    #[doc = r"     tick: bool = false;"]
    #[doc = r" });"]
    #[doc = r""]
    #[doc = r" fn tick(locals: &mut TIM3::Locals) {"]
    #[doc = r"     locals.tick = !locals.tick;"]
    #[doc = r""]
    #[doc = r"     if locals.tick {"]
    #[doc = r#"         println!("Tick");"#]
    #[doc = r"     } else {"]
    #[doc = r#"         println!("Tock");"#]
    #[doc = r"     }"]
    #[doc = r" }"]
    #[doc = r" ```"]
    macro_rules ! interrupt { ($ NAME : ident , $ path : path , locals : { $ ($ lvar : ident : $ lty : ty = $ lval : expr ;) * }) => { # [allow (non_snake_case)]
mod $ NAME { pub struct Locals { $ (pub $ lvar : $ lty ,) * } } # [allow (non_snake_case)]
# [no_mangle]
pub extern "C" fn $ NAME () { let _ = $ crate :: interrupt :: Interrupt :: $ NAME ; static mut LOCALS : self :: $ NAME :: Locals = self :: $ NAME :: Locals { $ ($ lvar : $ lval ,) * } ; let f : fn (& mut self :: $ NAME :: Locals) = $ path ; f (unsafe { & mut LOCALS }) ; } } ; ($ NAME : ident , $ path : path) => { # [allow (non_snake_case)]
# [no_mangle]
pub extern "C" fn $ NAME () { let _ = $ crate :: interrupt :: Interrupt :: $ NAME ; let f : fn () = $ path ; f () ; } } }
}
pub use self::interrupt::Interrupt;
#[doc = "Random number generator"]
pub struct TRNG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TRNG {}
impl TRNG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const trng::RegisterBlock = 0x4002_3c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const trng::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TRNG {
    type Target = trng::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TRNG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TRNG").finish()
    }
}
#[doc = "Random number generator"]
pub mod trng {
    #[doc = r"Register block"]
    #[repr(C)]
    pub struct RegisterBlock {
        #[doc = "0x00 - control register"]
        pub cr: crate::Reg<cr::CR_SPEC>,
        #[doc = "0x04 - status register"]
        pub sr: crate::Reg<sr::SR_SPEC>,
        #[doc = "0x08 - data register"]
        pub dr: crate::Reg<dr::DR_SPEC>,
    }
    #[doc = "CR register accessor: an alias for `Reg<CR_SPEC>`"]
    pub type CR = crate::Reg<cr::CR_SPEC>;
    #[doc = "control register"]
    pub mod cr {
        #[doc = "Register `CR` reader"]
        pub struct R(crate::R<CR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<CR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<CR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<CR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `CR` writer"]
        pub struct W(crate::W<CR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<CR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<CR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<CR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `IE` reader - Interrupt enable"]
        pub struct IE_R(crate::FieldReader<bool>);
        impl IE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                IE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for IE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `IE` writer - Interrupt enable"]
        pub struct IE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `RNGEN` reader - Random number generator enable"]
        pub struct RNGEN_R(crate::FieldReader<bool>);
        impl RNGEN_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RNGEN_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RNGEN_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RNGEN` writer - Random number generator enable"]
        pub struct RNGEN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RNGEN_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 3 - Interrupt enable"]
            #[inline(always)]
            pub fn ie(&self) -> IE_R {
                IE_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 2 - Random number generator enable"]
            #[inline(always)]
            pub fn rngen(&self) -> RNGEN_R {
                RNGEN_R::new(((self.bits >> 2) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 3 - Interrupt enable"]
            #[inline(always)]
            pub fn ie(&mut self) -> IE_W {
                IE_W { w: self }
            }
            #[doc = "Bit 2 - Random number generator enable"]
            #[inline(always)]
            pub fn rngen(&mut self) -> RNGEN_W {
                RNGEN_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cr](index.html) module"]
        pub struct CR_SPEC;
        impl crate::RegisterSpec for CR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [cr::R](R) reader structure"]
        impl crate::Readable for CR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [cr::W](W) writer structure"]
        impl crate::Writable for CR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets CR to value 0"]
        impl crate::Resettable for CR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "SR register accessor: an alias for `Reg<SR_SPEC>`"]
    pub type SR = crate::Reg<sr::SR_SPEC>;
    #[doc = "status register"]
    pub mod sr {
        #[doc = "Register `SR` reader"]
        pub struct R(crate::R<SR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<SR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<SR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<SR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `SR` writer"]
        pub struct W(crate::W<SR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<SR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<SR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<SR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `SEIS` reader - Seed error interrupt status"]
        pub struct SEIS_R(crate::FieldReader<bool>);
        impl SEIS_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SEIS_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SEIS_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SEIS` writer - Seed error interrupt status"]
        pub struct SEIS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SEIS_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CEIS` reader - Clock error interrupt status"]
        pub struct CEIS_R(crate::FieldReader<bool>);
        impl CEIS_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CEIS_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CEIS_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CEIS` writer - Clock error interrupt status"]
        pub struct CEIS_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CEIS_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `SECS` reader - Seed error current status"]
        pub struct SECS_R(crate::FieldReader<bool>);
        impl SECS_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SECS_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SECS_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CECS` reader - Clock error current status"]
        pub struct CECS_R(crate::FieldReader<bool>);
        impl CECS_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CECS_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CECS_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DRDY` reader - Data ready"]
        pub struct DRDY_R(crate::FieldReader<bool>);
        impl DRDY_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DRDY_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DRDY_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bit 6 - Seed error interrupt status"]
            #[inline(always)]
            pub fn seis(&self) -> SEIS_R {
                SEIS_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 5 - Clock error interrupt status"]
            #[inline(always)]
            pub fn ceis(&self) -> CEIS_R {
                CEIS_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 2 - Seed error current status"]
            #[inline(always)]
            pub fn secs(&self) -> SECS_R {
                SECS_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - Clock error current status"]
            #[inline(always)]
            pub fn cecs(&self) -> CECS_R {
                CECS_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - Data ready"]
            #[inline(always)]
            pub fn drdy(&self) -> DRDY_R {
                DRDY_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 6 - Seed error interrupt status"]
            #[inline(always)]
            pub fn seis(&mut self) -> SEIS_W {
                SEIS_W { w: self }
            }
            #[doc = "Bit 5 - Clock error interrupt status"]
            #[inline(always)]
            pub fn ceis(&mut self) -> CEIS_W {
                CEIS_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sr](index.html) module"]
        pub struct SR_SPEC;
        impl crate::RegisterSpec for SR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [sr::R](R) reader structure"]
        impl crate::Readable for SR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [sr::W](W) writer structure"]
        impl crate::Writable for SR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets SR to value 0"]
        impl crate::Resettable for SR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "DR register accessor: an alias for `Reg<DR_SPEC>`"]
    pub type DR = crate::Reg<dr::DR_SPEC>;
    #[doc = "data register"]
    pub mod dr {
        #[doc = "Register `DR` reader"]
        pub struct R(crate::R<DR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<DR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<DR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<DR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `RNDATA` reader - Random data"]
        pub struct RNDATA_R(crate::FieldReader<u32>);
        impl RNDATA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u32) -> Self {
                RNDATA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RNDATA_R {
            type Target = crate::FieldReader<u32>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 0:31 - Random data"]
            #[inline(always)]
            pub fn rndata(&self) -> RNDATA_R {
                RNDATA_R::new(self.bits)
            }
        }
        #[doc = "data register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dr](index.html) module"]
        pub struct DR_SPEC;
        impl crate::RegisterSpec for DR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [dr::R](R) reader structure"]
        impl crate::Readable for DR_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets DR to value 0"]
        impl crate::Resettable for DR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
}
#[doc = "Universal serial bus full-speed device interface"]
pub struct USB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB {}
impl USB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb::RegisterBlock = 0x4000_5c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB {
    type Target = usb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB").finish()
    }
}
#[doc = "Universal serial bus full-speed device interface"]
pub mod usb {
    #[doc = r"Register block"]
    #[repr(C)]
    pub struct RegisterBlock {
        #[doc = "0x00 - endpoint 0 register"]
        pub ep0r: crate::Reg<ep0r::EP0R_SPEC>,
        #[doc = "0x04 - endpoint 1 register"]
        pub ep1r: crate::Reg<ep1r::EP1R_SPEC>,
        #[doc = "0x08 - endpoint 2 register"]
        pub ep2r: crate::Reg<ep2r::EP2R_SPEC>,
        #[doc = "0x0c - endpoint 3 register"]
        pub ep3r: crate::Reg<ep3r::EP3R_SPEC>,
        #[doc = "0x10 - endpoint 4 register"]
        pub ep4r: crate::Reg<ep4r::EP4R_SPEC>,
        #[doc = "0x14 - endpoint 5 register"]
        pub ep5r: crate::Reg<ep5r::EP5R_SPEC>,
        #[doc = "0x18 - endpoint 6 register"]
        pub ep6r: crate::Reg<ep6r::EP6R_SPEC>,
        #[doc = "0x1c - endpoint 7 register"]
        pub ep7r: crate::Reg<ep7r::EP7R_SPEC>,
        _reserved8: [u8; 0x20],
        #[doc = "0x40 - control register"]
        pub cntr: crate::Reg<cntr::CNTR_SPEC>,
        #[doc = "0x44 - interrupt status register"]
        pub istr: crate::Reg<istr::ISTR_SPEC>,
        #[doc = "0x48 - frame number register"]
        pub fnr: crate::Reg<fnr::FNR_SPEC>,
        #[doc = "0x4c - device address"]
        pub daddr: crate::Reg<daddr::DADDR_SPEC>,
        #[doc = "0x50 - Buffer table address"]
        pub btable: crate::Reg<btable::BTABLE_SPEC>,
    }
    #[doc = "EP0R register accessor: an alias for `Reg<EP0R_SPEC>`"]
    pub type EP0R = crate::Reg<ep0r::EP0R_SPEC>;
    #[doc = "endpoint 0 register"]
    pub mod ep0r {
        #[doc = "Register `EP0R` reader"]
        pub struct R(crate::R<EP0R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP0R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP0R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP0R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP0R` writer"]
        pub struct W(crate::W<EP0R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP0R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP0R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP0R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 0 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep0r](index.html) module"]
        pub struct EP0R_SPEC;
        impl crate::RegisterSpec for EP0R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep0r::R](R) reader structure"]
        impl crate::Readable for EP0R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep0r::W](W) writer structure"]
        impl crate::Writable for EP0R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP0R to value 0"]
        impl crate::Resettable for EP0R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP1R register accessor: an alias for `Reg<EP1R_SPEC>`"]
    pub type EP1R = crate::Reg<ep1r::EP1R_SPEC>;
    #[doc = "endpoint 1 register"]
    pub mod ep1r {
        #[doc = "Register `EP1R` reader"]
        pub struct R(crate::R<EP1R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP1R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP1R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP1R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP1R` writer"]
        pub struct W(crate::W<EP1R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP1R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP1R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP1R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 1 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep1r](index.html) module"]
        pub struct EP1R_SPEC;
        impl crate::RegisterSpec for EP1R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep1r::R](R) reader structure"]
        impl crate::Readable for EP1R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep1r::W](W) writer structure"]
        impl crate::Writable for EP1R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP1R to value 0"]
        impl crate::Resettable for EP1R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP2R register accessor: an alias for `Reg<EP2R_SPEC>`"]
    pub type EP2R = crate::Reg<ep2r::EP2R_SPEC>;
    #[doc = "endpoint 2 register"]
    pub mod ep2r {
        #[doc = "Register `EP2R` reader"]
        pub struct R(crate::R<EP2R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP2R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP2R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP2R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP2R` writer"]
        pub struct W(crate::W<EP2R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP2R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP2R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP2R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 2 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep2r](index.html) module"]
        pub struct EP2R_SPEC;
        impl crate::RegisterSpec for EP2R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep2r::R](R) reader structure"]
        impl crate::Readable for EP2R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep2r::W](W) writer structure"]
        impl crate::Writable for EP2R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP2R to value 0"]
        impl crate::Resettable for EP2R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP3R register accessor: an alias for `Reg<EP3R_SPEC>`"]
    pub type EP3R = crate::Reg<ep3r::EP3R_SPEC>;
    #[doc = "endpoint 3 register"]
    pub mod ep3r {
        #[doc = "Register `EP3R` reader"]
        pub struct R(crate::R<EP3R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP3R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP3R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP3R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP3R` writer"]
        pub struct W(crate::W<EP3R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP3R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP3R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP3R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 3 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep3r](index.html) module"]
        pub struct EP3R_SPEC;
        impl crate::RegisterSpec for EP3R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep3r::R](R) reader structure"]
        impl crate::Readable for EP3R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep3r::W](W) writer structure"]
        impl crate::Writable for EP3R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP3R to value 0"]
        impl crate::Resettable for EP3R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP4R register accessor: an alias for `Reg<EP4R_SPEC>`"]
    pub type EP4R = crate::Reg<ep4r::EP4R_SPEC>;
    #[doc = "endpoint 4 register"]
    pub mod ep4r {
        #[doc = "Register `EP4R` reader"]
        pub struct R(crate::R<EP4R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP4R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP4R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP4R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP4R` writer"]
        pub struct W(crate::W<EP4R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP4R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP4R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP4R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 4 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep4r](index.html) module"]
        pub struct EP4R_SPEC;
        impl crate::RegisterSpec for EP4R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep4r::R](R) reader structure"]
        impl crate::Readable for EP4R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep4r::W](W) writer structure"]
        impl crate::Writable for EP4R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP4R to value 0"]
        impl crate::Resettable for EP4R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP5R register accessor: an alias for `Reg<EP5R_SPEC>`"]
    pub type EP5R = crate::Reg<ep5r::EP5R_SPEC>;
    #[doc = "endpoint 5 register"]
    pub mod ep5r {
        #[doc = "Register `EP5R` reader"]
        pub struct R(crate::R<EP5R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP5R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP5R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP5R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP5R` writer"]
        pub struct W(crate::W<EP5R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP5R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP5R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP5R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 5 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep5r](index.html) module"]
        pub struct EP5R_SPEC;
        impl crate::RegisterSpec for EP5R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep5r::R](R) reader structure"]
        impl crate::Readable for EP5R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep5r::W](W) writer structure"]
        impl crate::Writable for EP5R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP5R to value 0"]
        impl crate::Resettable for EP5R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP6R register accessor: an alias for `Reg<EP6R_SPEC>`"]
    pub type EP6R = crate::Reg<ep6r::EP6R_SPEC>;
    #[doc = "endpoint 6 register"]
    pub mod ep6r {
        #[doc = "Register `EP6R` reader"]
        pub struct R(crate::R<EP6R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP6R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP6R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP6R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP6R` writer"]
        pub struct W(crate::W<EP6R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP6R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP6R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP6R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 6 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep6r](index.html) module"]
        pub struct EP6R_SPEC;
        impl crate::RegisterSpec for EP6R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep6r::R](R) reader structure"]
        impl crate::Readable for EP6R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep6r::W](W) writer structure"]
        impl crate::Writable for EP6R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP6R to value 0"]
        impl crate::Resettable for EP6R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "EP7R register accessor: an alias for `Reg<EP7R_SPEC>`"]
    pub type EP7R = crate::Reg<ep7r::EP7R_SPEC>;
    #[doc = "endpoint 7 register"]
    pub mod ep7r {
        #[doc = "Register `EP7R` reader"]
        pub struct R(crate::R<EP7R_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<EP7R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<EP7R_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<EP7R_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `EP7R` writer"]
        pub struct W(crate::W<EP7R_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<EP7R_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<EP7R_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<EP7R_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EA` reader - Endpoint address"]
        pub struct EA_R(crate::FieldReader<u8>);
        impl EA_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EA_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EA_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EA` writer - Endpoint address"]
        pub struct EA_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EA_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `STAT_TX` reader - Status bits, for transmission transfers"]
        pub struct STAT_TX_R(crate::FieldReader<u8>);
        impl STAT_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_TX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_TX` writer - Status bits, for transmission transfers"]
        pub struct STAT_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_TX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
                self.w
            }
        }
        #[doc = "Field `DTOG_TX` reader - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_R(crate::FieldReader<bool>);
        impl DTOG_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_TX` writer - Data Toggle, for transmission transfers"]
        pub struct DTOG_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `CTR_TX` reader - Correct Transfer for transmission"]
        pub struct CTR_TX_R(crate::FieldReader<bool>);
        impl CTR_TX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_TX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_TX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_TX` writer - Correct Transfer for transmission"]
        pub struct CTR_TX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_TX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `EP_KIND` reader - Endpoint kind"]
        pub struct EP_KIND_R(crate::FieldReader<bool>);
        impl EP_KIND_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EP_KIND_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_KIND_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_KIND` writer - Endpoint kind"]
        pub struct EP_KIND_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_KIND_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `EP_TYPE` reader - Endpoint type"]
        pub struct EP_TYPE_R(crate::FieldReader<u8>);
        impl EP_TYPE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_TYPE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_TYPE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_TYPE` writer - Endpoint type"]
        pub struct EP_TYPE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_TYPE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 9)) | ((value as u32 & 3) << 9);
                self.w
            }
        }
        #[doc = "Field `SETUP` reader - Setup transaction completed"]
        pub struct SETUP_R(crate::FieldReader<bool>);
        impl SETUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SETUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SETUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SETUP` writer - Setup transaction completed"]
        pub struct SETUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SETUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `STAT_RX` reader - Status bits, for reception transfers"]
        pub struct STAT_RX_R(crate::FieldReader<u8>);
        impl STAT_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                STAT_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STAT_RX_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STAT_RX` writer - Status bits, for reception transfers"]
        pub struct STAT_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STAT_RX_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 12)) | ((value as u32 & 3) << 12);
                self.w
            }
        }
        #[doc = "Field `DTOG_RX` reader - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_R(crate::FieldReader<bool>);
        impl DTOG_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DTOG_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DTOG_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DTOG_RX` writer - Data Toggle, for reception transfers"]
        pub struct DTOG_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DTOG_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR_RX` reader - Correct transfer for reception"]
        pub struct CTR_RX_R(crate::FieldReader<bool>);
        impl CTR_RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR_RX` writer - Correct transfer for reception"]
        pub struct CTR_RX_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_RX_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&self) -> EA_R {
                EA_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&self) -> STAT_TX_R {
                STAT_TX_R::new(((self.bits >> 4) & 3) as u8)
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&self) -> DTOG_TX_R {
                DTOG_TX_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&self) -> CTR_TX_R {
                CTR_TX_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&self) -> EP_KIND_R {
                EP_KIND_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&self) -> EP_TYPE_R {
                EP_TYPE_R::new(((self.bits >> 9) & 3) as u8)
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&self) -> SETUP_R {
                SETUP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&self) -> STAT_RX_R {
                STAT_RX_R::new(((self.bits >> 12) & 3) as u8)
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&self) -> DTOG_RX_R {
                DTOG_RX_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&self) -> CTR_RX_R {
                CTR_RX_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint address"]
            #[inline(always)]
            pub fn ea(&mut self) -> EA_W {
                EA_W { w: self }
            }
            #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
            #[inline(always)]
            pub fn stat_tx(&mut self) -> STAT_TX_W {
                STAT_TX_W { w: self }
            }
            #[doc = "Bit 6 - Data Toggle, for transmission transfers"]
            #[inline(always)]
            pub fn dtog_tx(&mut self) -> DTOG_TX_W {
                DTOG_TX_W { w: self }
            }
            #[doc = "Bit 7 - Correct Transfer for transmission"]
            #[inline(always)]
            pub fn ctr_tx(&mut self) -> CTR_TX_W {
                CTR_TX_W { w: self }
            }
            #[doc = "Bit 8 - Endpoint kind"]
            #[inline(always)]
            pub fn ep_kind(&mut self) -> EP_KIND_W {
                EP_KIND_W { w: self }
            }
            #[doc = "Bits 9:10 - Endpoint type"]
            #[inline(always)]
            pub fn ep_type(&mut self) -> EP_TYPE_W {
                EP_TYPE_W { w: self }
            }
            #[doc = "Bit 11 - Setup transaction completed"]
            #[inline(always)]
            pub fn setup(&mut self) -> SETUP_W {
                SETUP_W { w: self }
            }
            #[doc = "Bits 12:13 - Status bits, for reception transfers"]
            #[inline(always)]
            pub fn stat_rx(&mut self) -> STAT_RX_W {
                STAT_RX_W { w: self }
            }
            #[doc = "Bit 14 - Data Toggle, for reception transfers"]
            #[inline(always)]
            pub fn dtog_rx(&mut self) -> DTOG_RX_W {
                DTOG_RX_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer for reception"]
            #[inline(always)]
            pub fn ctr_rx(&mut self) -> CTR_RX_W {
                CTR_RX_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "endpoint 7 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep7r](index.html) module"]
        pub struct EP7R_SPEC;
        impl crate::RegisterSpec for EP7R_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ep7r::R](R) reader structure"]
        impl crate::Readable for EP7R_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ep7r::W](W) writer structure"]
        impl crate::Writable for EP7R_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets EP7R to value 0"]
        impl crate::Resettable for EP7R_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "CNTR register accessor: an alias for `Reg<CNTR_SPEC>`"]
    pub type CNTR = crate::Reg<cntr::CNTR_SPEC>;
    #[doc = "control register"]
    pub mod cntr {
        #[doc = "Register `CNTR` reader"]
        pub struct R(crate::R<CNTR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<CNTR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<CNTR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<CNTR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `CNTR` writer"]
        pub struct W(crate::W<CNTR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<CNTR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<CNTR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<CNTR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FRES` reader - Force USB Reset"]
        pub struct FRES_R(crate::FieldReader<bool>);
        impl FRES_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FRES_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FRES_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FRES` writer - Force USB Reset"]
        pub struct FRES_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FRES_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `PDWN` reader - Power down"]
        pub struct PDWN_R(crate::FieldReader<bool>);
        impl PDWN_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                PDWN_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for PDWN_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `PDWN` writer - Power down"]
        pub struct PDWN_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PDWN_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `LPMODE` reader - Low-power mode"]
        pub struct LPMODE_R(crate::FieldReader<bool>);
        impl LPMODE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LPMODE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LPMODE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LPMODE` writer - Low-power mode"]
        pub struct LPMODE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LPMODE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FSUSP` reader - Force suspend"]
        pub struct FSUSP_R(crate::FieldReader<bool>);
        impl FSUSP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSUSP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSUSP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSUSP` writer - Force suspend"]
        pub struct FSUSP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSUSP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `RESUME` reader - Resume request"]
        pub struct RESUME_R(crate::FieldReader<bool>);
        impl RESUME_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RESUME_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RESUME_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RESUME` writer - Resume request"]
        pub struct RESUME_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESUME_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `ESOFM` reader - Expected start of frame interrupt mask"]
        pub struct ESOFM_R(crate::FieldReader<bool>);
        impl ESOFM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ESOFM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ESOFM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ESOFM` writer - Expected start of frame interrupt mask"]
        pub struct ESOFM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ESOFM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `SOFM` reader - Start of frame interrupt mask"]
        pub struct SOFM_R(crate::FieldReader<bool>);
        impl SOFM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SOFM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SOFM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SOFM` writer - Start of frame interrupt mask"]
        pub struct SOFM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOFM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `RESETM` reader - USB reset interrupt mask"]
        pub struct RESETM_R(crate::FieldReader<bool>);
        impl RESETM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RESETM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RESETM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RESETM` writer - USB reset interrupt mask"]
        pub struct RESETM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESETM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `SUSPM` reader - Suspend mode interrupt mask"]
        pub struct SUSPM_R(crate::FieldReader<bool>);
        impl SUSPM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SUSPM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SUSPM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SUSPM` writer - Suspend mode interrupt mask"]
        pub struct SUSPM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SUSPM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `WKUPM` reader - Wakeup interrupt mask"]
        pub struct WKUPM_R(crate::FieldReader<bool>);
        impl WKUPM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                WKUPM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for WKUPM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `WKUPM` writer - Wakeup interrupt mask"]
        pub struct WKUPM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WKUPM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `ERRM` reader - Error interrupt mask"]
        pub struct ERRM_R(crate::FieldReader<bool>);
        impl ERRM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ERRM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ERRM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ERRM` writer - Error interrupt mask"]
        pub struct ERRM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ERRM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `PMAOVRM` reader - Packet memory area over / underrun interrupt mask"]
        pub struct PMAOVRM_R(crate::FieldReader<bool>);
        impl PMAOVRM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                PMAOVRM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for PMAOVRM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `PMAOVRM` writer - Packet memory area over / underrun interrupt mask"]
        pub struct PMAOVRM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PMAOVRM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTRM` reader - Correct transfer interrupt mask"]
        pub struct CTRM_R(crate::FieldReader<bool>);
        impl CTRM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTRM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTRM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTRM` writer - Correct transfer interrupt mask"]
        pub struct CTRM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTRM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Force USB Reset"]
            #[inline(always)]
            pub fn fres(&self) -> FRES_R {
                FRES_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Power down"]
            #[inline(always)]
            pub fn pdwn(&self) -> PDWN_R {
                PDWN_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Low-power mode"]
            #[inline(always)]
            pub fn lpmode(&self) -> LPMODE_R {
                LPMODE_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Force suspend"]
            #[inline(always)]
            pub fn fsusp(&self) -> FSUSP_R {
                FSUSP_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Resume request"]
            #[inline(always)]
            pub fn resume(&self) -> RESUME_R {
                RESUME_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 8 - Expected start of frame interrupt mask"]
            #[inline(always)]
            pub fn esofm(&self) -> ESOFM_R {
                ESOFM_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Start of frame interrupt mask"]
            #[inline(always)]
            pub fn sofm(&self) -> SOFM_R {
                SOFM_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - USB reset interrupt mask"]
            #[inline(always)]
            pub fn resetm(&self) -> RESETM_R {
                RESETM_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Suspend mode interrupt mask"]
            #[inline(always)]
            pub fn suspm(&self) -> SUSPM_R {
                SUSPM_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Wakeup interrupt mask"]
            #[inline(always)]
            pub fn wkupm(&self) -> WKUPM_R {
                WKUPM_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Error interrupt mask"]
            #[inline(always)]
            pub fn errm(&self) -> ERRM_R {
                ERRM_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Packet memory area over / underrun interrupt mask"]
            #[inline(always)]
            pub fn pmaovrm(&self) -> PMAOVRM_R {
                PMAOVRM_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer interrupt mask"]
            #[inline(always)]
            pub fn ctrm(&self) -> CTRM_R {
                CTRM_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Force USB Reset"]
            #[inline(always)]
            pub fn fres(&mut self) -> FRES_W {
                FRES_W { w: self }
            }
            #[doc = "Bit 1 - Power down"]
            #[inline(always)]
            pub fn pdwn(&mut self) -> PDWN_W {
                PDWN_W { w: self }
            }
            #[doc = "Bit 2 - Low-power mode"]
            #[inline(always)]
            pub fn lpmode(&mut self) -> LPMODE_W {
                LPMODE_W { w: self }
            }
            #[doc = "Bit 3 - Force suspend"]
            #[inline(always)]
            pub fn fsusp(&mut self) -> FSUSP_W {
                FSUSP_W { w: self }
            }
            #[doc = "Bit 4 - Resume request"]
            #[inline(always)]
            pub fn resume(&mut self) -> RESUME_W {
                RESUME_W { w: self }
            }
            #[doc = "Bit 8 - Expected start of frame interrupt mask"]
            #[inline(always)]
            pub fn esofm(&mut self) -> ESOFM_W {
                ESOFM_W { w: self }
            }
            #[doc = "Bit 9 - Start of frame interrupt mask"]
            #[inline(always)]
            pub fn sofm(&mut self) -> SOFM_W {
                SOFM_W { w: self }
            }
            #[doc = "Bit 10 - USB reset interrupt mask"]
            #[inline(always)]
            pub fn resetm(&mut self) -> RESETM_W {
                RESETM_W { w: self }
            }
            #[doc = "Bit 11 - Suspend mode interrupt mask"]
            #[inline(always)]
            pub fn suspm(&mut self) -> SUSPM_W {
                SUSPM_W { w: self }
            }
            #[doc = "Bit 12 - Wakeup interrupt mask"]
            #[inline(always)]
            pub fn wkupm(&mut self) -> WKUPM_W {
                WKUPM_W { w: self }
            }
            #[doc = "Bit 13 - Error interrupt mask"]
            #[inline(always)]
            pub fn errm(&mut self) -> ERRM_W {
                ERRM_W { w: self }
            }
            #[doc = "Bit 14 - Packet memory area over / underrun interrupt mask"]
            #[inline(always)]
            pub fn pmaovrm(&mut self) -> PMAOVRM_W {
                PMAOVRM_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer interrupt mask"]
            #[inline(always)]
            pub fn ctrm(&mut self) -> CTRM_W {
                CTRM_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cntr](index.html) module"]
        pub struct CNTR_SPEC;
        impl crate::RegisterSpec for CNTR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [cntr::R](R) reader structure"]
        impl crate::Readable for CNTR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [cntr::W](W) writer structure"]
        impl crate::Writable for CNTR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets CNTR to value 0x03"]
        impl crate::Resettable for CNTR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0x03
            }
        }
    }
    #[doc = "ISTR register accessor: an alias for `Reg<ISTR_SPEC>`"]
    pub type ISTR = crate::Reg<istr::ISTR_SPEC>;
    #[doc = "interrupt status register"]
    pub mod istr {
        #[doc = "Register `ISTR` reader"]
        pub struct R(crate::R<ISTR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<ISTR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<ISTR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<ISTR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `ISTR` writer"]
        pub struct W(crate::W<ISTR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<ISTR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<ISTR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<ISTR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `EP_ID` reader - Endpoint Identifier"]
        pub struct EP_ID_R(crate::FieldReader<u8>);
        impl EP_ID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                EP_ID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EP_ID_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EP_ID` writer - Endpoint Identifier"]
        pub struct EP_ID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EP_ID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        #[doc = "Field `DIR` reader - Direction of transaction"]
        pub struct DIR_R(crate::FieldReader<bool>);
        impl DIR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DIR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DIR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DIR` writer - Direction of transaction"]
        pub struct DIR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DIR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `ESOF` reader - Expected start frame"]
        pub struct ESOF_R(crate::FieldReader<bool>);
        impl ESOF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ESOF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ESOF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ESOF` writer - Expected start frame"]
        pub struct ESOF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ESOF_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `SOF` reader - start of frame"]
        pub struct SOF_R(crate::FieldReader<bool>);
        impl SOF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SOF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SOF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SOF` writer - start of frame"]
        pub struct SOF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SOF_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `RESET` reader - reset request"]
        pub struct RESET_R(crate::FieldReader<bool>);
        impl RESET_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RESET_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RESET_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RESET` writer - reset request"]
        pub struct RESET_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESET_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `SUSP` reader - Suspend mode request"]
        pub struct SUSP_R(crate::FieldReader<bool>);
        impl SUSP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SUSP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SUSP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SUSP` writer - Suspend mode request"]
        pub struct SUSP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SUSP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `WKUP` reader - Wakeup"]
        pub struct WKUP_R(crate::FieldReader<bool>);
        impl WKUP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                WKUP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for WKUP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `WKUP` writer - Wakeup"]
        pub struct WKUP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WKUP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `ERR` reader - Error"]
        pub struct ERR_R(crate::FieldReader<bool>);
        impl ERR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ERR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ERR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ERR` writer - Error"]
        pub struct ERR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ERR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `PMAOVR` reader - Packet memory area over / underrun"]
        pub struct PMAOVR_R(crate::FieldReader<bool>);
        impl PMAOVR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                PMAOVR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for PMAOVR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `PMAOVR` writer - Packet memory area over / underrun"]
        pub struct PMAOVR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> PMAOVR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `CTR` reader - Correct transfer"]
        pub struct CTR_R(crate::FieldReader<bool>);
        impl CTR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                CTR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CTR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CTR` writer - Correct transfer"]
        pub struct CTR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> CTR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:3 - Endpoint Identifier"]
            #[inline(always)]
            pub fn ep_id(&self) -> EP_ID_R {
                EP_ID_R::new((self.bits & 0x0f) as u8)
            }
            #[doc = "Bit 4 - Direction of transaction"]
            #[inline(always)]
            pub fn dir(&self) -> DIR_R {
                DIR_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 8 - Expected start frame"]
            #[inline(always)]
            pub fn esof(&self) -> ESOF_R {
                ESOF_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - start of frame"]
            #[inline(always)]
            pub fn sof(&self) -> SOF_R {
                SOF_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - reset request"]
            #[inline(always)]
            pub fn reset(&self) -> RESET_R {
                RESET_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Suspend mode request"]
            #[inline(always)]
            pub fn susp(&self) -> SUSP_R {
                SUSP_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Wakeup"]
            #[inline(always)]
            pub fn wkup(&self) -> WKUP_R {
                WKUP_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Error"]
            #[inline(always)]
            pub fn err(&self) -> ERR_R {
                ERR_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Packet memory area over / underrun"]
            #[inline(always)]
            pub fn pmaovr(&self) -> PMAOVR_R {
                PMAOVR_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Correct transfer"]
            #[inline(always)]
            pub fn ctr(&self) -> CTR_R {
                CTR_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:3 - Endpoint Identifier"]
            #[inline(always)]
            pub fn ep_id(&mut self) -> EP_ID_W {
                EP_ID_W { w: self }
            }
            #[doc = "Bit 4 - Direction of transaction"]
            #[inline(always)]
            pub fn dir(&mut self) -> DIR_W {
                DIR_W { w: self }
            }
            #[doc = "Bit 8 - Expected start frame"]
            #[inline(always)]
            pub fn esof(&mut self) -> ESOF_W {
                ESOF_W { w: self }
            }
            #[doc = "Bit 9 - start of frame"]
            #[inline(always)]
            pub fn sof(&mut self) -> SOF_W {
                SOF_W { w: self }
            }
            #[doc = "Bit 10 - reset request"]
            #[inline(always)]
            pub fn reset(&mut self) -> RESET_W {
                RESET_W { w: self }
            }
            #[doc = "Bit 11 - Suspend mode request"]
            #[inline(always)]
            pub fn susp(&mut self) -> SUSP_W {
                SUSP_W { w: self }
            }
            #[doc = "Bit 12 - Wakeup"]
            #[inline(always)]
            pub fn wkup(&mut self) -> WKUP_W {
                WKUP_W { w: self }
            }
            #[doc = "Bit 13 - Error"]
            #[inline(always)]
            pub fn err(&mut self) -> ERR_W {
                ERR_W { w: self }
            }
            #[doc = "Bit 14 - Packet memory area over / underrun"]
            #[inline(always)]
            pub fn pmaovr(&mut self) -> PMAOVR_W {
                PMAOVR_W { w: self }
            }
            #[doc = "Bit 15 - Correct transfer"]
            #[inline(always)]
            pub fn ctr(&mut self) -> CTR_W {
                CTR_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "interrupt status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [istr](index.html) module"]
        pub struct ISTR_SPEC;
        impl crate::RegisterSpec for ISTR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [istr::R](R) reader structure"]
        impl crate::Readable for ISTR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [istr::W](W) writer structure"]
        impl crate::Writable for ISTR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets ISTR to value 0"]
        impl crate::Resettable for ISTR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "FNR register accessor: an alias for `Reg<FNR_SPEC>`"]
    pub type FNR = crate::Reg<fnr::FNR_SPEC>;
    #[doc = "frame number register"]
    pub mod fnr {
        #[doc = "Register `FNR` reader"]
        pub struct R(crate::R<FNR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<FNR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<FNR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<FNR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `FN` reader - Frame number"]
        pub struct FN_R(crate::FieldReader<u16>);
        impl FN_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                FN_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FN_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LSOF` reader - Lost SOF"]
        pub struct LSOF_R(crate::FieldReader<u8>);
        impl LSOF_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                LSOF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LSOF_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LCK` reader - Locked"]
        pub struct LCK_R(crate::FieldReader<bool>);
        impl LCK_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LCK_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LCK_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RXDM` reader - Receive data - line status"]
        pub struct RXDM_R(crate::FieldReader<bool>);
        impl RXDM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RXDM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RXDM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RXDP` reader - Receive data + line status"]
        pub struct RXDP_R(crate::FieldReader<bool>);
        impl RXDP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RXDP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RXDP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 0:10 - Frame number"]
            #[inline(always)]
            pub fn fn_(&self) -> FN_R {
                FN_R::new((self.bits & 0x07ff) as u16)
            }
            #[doc = "Bits 11:12 - Lost SOF"]
            #[inline(always)]
            pub fn lsof(&self) -> LSOF_R {
                LSOF_R::new(((self.bits >> 11) & 3) as u8)
            }
            #[doc = "Bit 13 - Locked"]
            #[inline(always)]
            pub fn lck(&self) -> LCK_R {
                LCK_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Receive data - line status"]
            #[inline(always)]
            pub fn rxdm(&self) -> RXDM_R {
                RXDM_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Receive data + line status"]
            #[inline(always)]
            pub fn rxdp(&self) -> RXDP_R {
                RXDP_R::new(((self.bits >> 15) & 1) != 0)
            }
        }
        #[doc = "frame number register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fnr](index.html) module"]
        pub struct FNR_SPEC;
        impl crate::RegisterSpec for FNR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [fnr::R](R) reader structure"]
        impl crate::Readable for FNR_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets FNR to value 0"]
        impl crate::Resettable for FNR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "DADDR register accessor: an alias for `Reg<DADDR_SPEC>`"]
    pub type DADDR = crate::Reg<daddr::DADDR_SPEC>;
    #[doc = "device address"]
    pub mod daddr {
        #[doc = "Register `DADDR` reader"]
        pub struct R(crate::R<DADDR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<DADDR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<DADDR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<DADDR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `DADDR` writer"]
        pub struct W(crate::W<DADDR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<DADDR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<DADDR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<DADDR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `ADD` reader - Device address"]
        pub struct ADD_R(crate::FieldReader<u8>);
        impl ADD_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                ADD_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ADD_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ADD` writer - Device address"]
        pub struct ADD_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ADD_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x7f) | (value as u32 & 0x7f);
                self.w
            }
        }
        #[doc = "Field `EF` reader - Enable function"]
        pub struct EF_R(crate::FieldReader<bool>);
        impl EF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EF` writer - Enable function"]
        pub struct EF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EF_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 0:6 - Device address"]
            #[inline(always)]
            pub fn add(&self) -> ADD_R {
                ADD_R::new((self.bits & 0x7f) as u8)
            }
            #[doc = "Bit 7 - Enable function"]
            #[inline(always)]
            pub fn ef(&self) -> EF_R {
                EF_R::new(((self.bits >> 7) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 0:6 - Device address"]
            #[inline(always)]
            pub fn add(&mut self) -> ADD_W {
                ADD_W { w: self }
            }
            #[doc = "Bit 7 - Enable function"]
            #[inline(always)]
            pub fn ef(&mut self) -> EF_W {
                EF_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "device address\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [daddr](index.html) module"]
        pub struct DADDR_SPEC;
        impl crate::RegisterSpec for DADDR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [daddr::R](R) reader structure"]
        impl crate::Readable for DADDR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [daddr::W](W) writer structure"]
        impl crate::Writable for DADDR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets DADDR to value 0"]
        impl crate::Resettable for DADDR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "BTABLE register accessor: an alias for `Reg<BTABLE_SPEC>`"]
    pub type BTABLE = crate::Reg<btable::BTABLE_SPEC>;
    #[doc = "Buffer table address"]
    pub mod btable {
        #[doc = "Register `BTABLE` reader"]
        pub struct R(crate::R<BTABLE_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<BTABLE_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<BTABLE_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<BTABLE_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `BTABLE` writer"]
        pub struct W(crate::W<BTABLE_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<BTABLE_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<BTABLE_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<BTABLE_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `BTABLE` reader - Buffer table"]
        pub struct BTABLE_R(crate::FieldReader<u16>);
        impl BTABLE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                BTABLE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for BTABLE_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `BTABLE` writer - Buffer table"]
        pub struct BTABLE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BTABLE_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x1fff << 3)) | ((value as u32 & 0x1fff) << 3);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 3:15 - Buffer table"]
            #[inline(always)]
            pub fn btable(&self) -> BTABLE_R {
                BTABLE_R::new(((self.bits >> 3) & 0x1fff) as u16)
            }
        }
        impl W {
            #[doc = "Bits 3:15 - Buffer table"]
            #[inline(always)]
            pub fn btable(&mut self) -> BTABLE_W {
                BTABLE_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Buffer table address\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [btable](index.html) module"]
        pub struct BTABLE_SPEC;
        impl crate::RegisterSpec for BTABLE_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [btable::R](R) reader structure"]
        impl crate::Readable for BTABLE_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [btable::W](W) writer structure"]
        impl crate::Writable for BTABLE_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets BTABLE to value 0"]
        impl crate::Resettable for BTABLE_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
}
#[doc = "Controller area network"]
pub struct CAN1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CAN1 {}
impl CAN1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const can1::RegisterBlock = 0x4000_6400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const can1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CAN1 {
    type Target = can1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CAN1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CAN1").finish()
    }
}
#[doc = "Controller area network"]
pub mod can1 {
    #[doc = r"Register block"]
    #[repr(C)]
    pub struct RegisterBlock {
        #[doc = "0x00 - CTLR"]
        pub ctlr: crate::Reg<ctlr::CTLR_SPEC>,
        #[doc = "0x04 - STATR"]
        pub statr: crate::Reg<statr::STATR_SPEC>,
        #[doc = "0x08 - TSTATR"]
        pub tstatr: crate::Reg<tstatr::TSTATR_SPEC>,
        #[doc = "0x0c - RFIFO0"]
        pub rfifo0: crate::Reg<rfifo0::RFIFO0_SPEC>,
        #[doc = "0x10 - RFIFO1"]
        pub rfifo1: crate::Reg<rfifo1::RFIFO1_SPEC>,
        #[doc = "0x14 - INTENR"]
        pub intenr: crate::Reg<intenr::INTENR_SPEC>,
        #[doc = "0x18 - ERRSR"]
        pub errsr: crate::Reg<errsr::ERRSR_SPEC>,
        #[doc = "0x1c - BTIMR"]
        pub btimr: crate::Reg<btimr::BTIMR_SPEC>,
        _reserved8: [u8; 0x0160],
        #[doc = "0x180 - TXMIR0"]
        pub txmir0: crate::Reg<txmir0::TXMIR0_SPEC>,
        #[doc = "0x184 - TXMDTR0"]
        pub txmdtr0: crate::Reg<txmdtr0::TXMDTR0_SPEC>,
        #[doc = "0x188 - TXMDLR0"]
        pub txmdlr0: crate::Reg<txmdlr0::TXMDLR0_SPEC>,
        #[doc = "0x18c - TXMDHR0"]
        pub txmdhr0: crate::Reg<txmdhr0::TXMDHR0_SPEC>,
        #[doc = "0x190 - TXMIR1"]
        pub txmir1: crate::Reg<txmir1::TXMIR1_SPEC>,
        #[doc = "0x194 - TXMDTR1"]
        pub txmdtr1: crate::Reg<txmdtr1::TXMDTR1_SPEC>,
        #[doc = "0x198 - TXMDLR1"]
        pub txmdlr1: crate::Reg<txmdlr1::TXMDLR1_SPEC>,
        #[doc = "0x19c - TXMDHR1"]
        pub txmdhr1: crate::Reg<txmdhr1::TXMDHR1_SPEC>,
        #[doc = "0x1a0 - TXMIR2"]
        pub txmir2: crate::Reg<txmir2::TXMIR2_SPEC>,
        #[doc = "0x1a4 - TXMDTR2"]
        pub txmdtr2: crate::Reg<txmdtr2::TXMDTR2_SPEC>,
        #[doc = "0x1a8 - TXMDLR2"]
        pub txmdlr2: crate::Reg<txmdlr2::TXMDLR2_SPEC>,
        #[doc = "0x1ac - TXMDHR2"]
        pub txmdhr2: crate::Reg<txmdhr2::TXMDHR2_SPEC>,
        #[doc = "0x1b0 - RXMIR0"]
        pub rxmir0: crate::Reg<rxmir0::RXMIR0_SPEC>,
        #[doc = "0x1b4 - RXMDTR0"]
        pub rxmdtr0: crate::Reg<rxmdtr0::RXMDTR0_SPEC>,
        #[doc = "0x1b8 - RXMDLR0"]
        pub rxmdlr0: crate::Reg<rxmdlr0::RXMDLR0_SPEC>,
        #[doc = "0x1bc - RXMDHR0"]
        pub rxmdhr0: crate::Reg<rxmdhr0::RXMDHR0_SPEC>,
        #[doc = "0x1c0 - RXMIR1"]
        pub rxmir1: crate::Reg<rxmir1::RXMIR1_SPEC>,
        #[doc = "0x1c4 - RXMDTR1"]
        pub rxmdtr1: crate::Reg<rxmdtr1::RXMDTR1_SPEC>,
        #[doc = "0x1c8 - RXMDLR1"]
        pub rxmdlr1: crate::Reg<rxmdlr1::RXMDLR1_SPEC>,
        #[doc = "0x1cc - RXMDHR1"]
        pub rxmdhr1: crate::Reg<rxmdhr1::RXMDHR1_SPEC>,
        _reserved28: [u8; 0x30],
        #[doc = "0x200 - FCTLR"]
        pub fctlr: crate::Reg<fctlr::FCTLR_SPEC>,
        #[doc = "0x204 - FMCFGR"]
        pub fmcfgr: crate::Reg<fmcfgr::FMCFGR_SPEC>,
        _reserved30: [u8; 0x04],
        #[doc = "0x20c - FSCFGR"]
        pub fscfgr: crate::Reg<fscfgr::FSCFGR_SPEC>,
        _reserved31: [u8; 0x04],
        #[doc = "0x214 - FAFIFOR"]
        pub fafifor: crate::Reg<fafifor::FAFIFOR_SPEC>,
        _reserved32: [u8; 0x04],
        #[doc = "0x21c - FWR"]
        pub fwr: crate::Reg<fwr::FWR_SPEC>,
        _reserved33: [u8; 0x20],
        #[doc = "0x240 - Filter bank 0 register 1"]
        pub f0r1: crate::Reg<f0r1::F0R1_SPEC>,
        #[doc = "0x244 - Filter bank 0 register 2"]
        pub f0r2: crate::Reg<f0r2::F0R2_SPEC>,
        #[doc = "0x248 - Filter bank 1 register 1"]
        pub f1r1: crate::Reg<f1r1::F1R1_SPEC>,
        #[doc = "0x24c - Filter bank 1 register 2"]
        pub f1r2: crate::Reg<f1r2::F1R2_SPEC>,
        #[doc = "0x250 - Filter bank 2 register 1"]
        pub f2r1: crate::Reg<f2r1::F2R1_SPEC>,
        #[doc = "0x254 - Filter bank 2 register 2"]
        pub f2r2: crate::Reg<f2r2::F2R2_SPEC>,
        #[doc = "0x258 - Filter bank 3 register 1"]
        pub f3r1: crate::Reg<f3r1::F3R1_SPEC>,
        #[doc = "0x25c - Filter bank 3 register 2"]
        pub f3r2: crate::Reg<f3r2::F3R2_SPEC>,
        #[doc = "0x260 - Filter bank 4 register 1"]
        pub f4r1: crate::Reg<f4r1::F4R1_SPEC>,
        #[doc = "0x264 - Filter bank 4 register 2"]
        pub f4r2: crate::Reg<f4r2::F4R2_SPEC>,
        #[doc = "0x268 - Filter bank 5 register 1"]
        pub f5r1: crate::Reg<f5r1::F5R1_SPEC>,
        #[doc = "0x26c - Filter bank 5 register 2"]
        pub f5r2: crate::Reg<f5r2::F5R2_SPEC>,
        #[doc = "0x270 - Filter bank 6 register 1"]
        pub f6r1: crate::Reg<f6r1::F6R1_SPEC>,
        #[doc = "0x274 - Filter bank 6 register 2"]
        pub f6r2: crate::Reg<f6r2::F6R2_SPEC>,
        #[doc = "0x278 - Filter bank 7 register 1"]
        pub f7r1: crate::Reg<f7r1::F7R1_SPEC>,
        #[doc = "0x27c - Filter bank 7 register 2"]
        pub f7r2: crate::Reg<f7r2::F7R2_SPEC>,
        #[doc = "0x280 - Filter bank 8 register 1"]
        pub f8r1: crate::Reg<f8r1::F8R1_SPEC>,
        #[doc = "0x284 - Filter bank 8 register 2"]
        pub f8r2: crate::Reg<f8r2::F8R2_SPEC>,
        #[doc = "0x288 - Filter bank 9 register 1"]
        pub f9r1: crate::Reg<f9r1::F9R1_SPEC>,
        #[doc = "0x28c - Filter bank 9 register 2"]
        pub f9r2: crate::Reg<f9r2::F9R2_SPEC>,
        #[doc = "0x290 - Filter bank 10 register 1"]
        pub f10r1: crate::Reg<f10r1::F10R1_SPEC>,
        #[doc = "0x294 - Filter bank 10 register 2"]
        pub f10r2: crate::Reg<f10r2::F10R2_SPEC>,
        #[doc = "0x298 - Filter bank 11 register 1"]
        pub f11r1: crate::Reg<f11r1::F11R1_SPEC>,
        #[doc = "0x29c - Filter bank 11 register 2"]
        pub f11r2: crate::Reg<f11r2::F11R2_SPEC>,
        #[doc = "0x2a0 - Filter bank 4 register 1"]
        pub f12r1: crate::Reg<f12r1::F12R1_SPEC>,
        #[doc = "0x2a4 - Filter bank 12 register 2"]
        pub f12r2: crate::Reg<f12r2::F12R2_SPEC>,
        #[doc = "0x2a8 - Filter bank 13 register 1"]
        pub f13r1: crate::Reg<f13r1::F13R1_SPEC>,
        #[doc = "0x2ac - Filter bank 13 register 2"]
        pub f13r2: crate::Reg<f13r2::F13R2_SPEC>,
    }
    #[doc = "CTLR register accessor: an alias for `Reg<CTLR_SPEC>`"]
    pub type CTLR = crate::Reg<ctlr::CTLR_SPEC>;
    #[doc = "CTLR"]
    pub mod ctlr {
        #[doc = "Register `CTLR` reader"]
        pub struct R(crate::R<CTLR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<CTLR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<CTLR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<CTLR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `CTLR` writer"]
        pub struct W(crate::W<CTLR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<CTLR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<CTLR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<CTLR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DBF` reader - DBF"]
        pub struct DBF_R(crate::FieldReader<bool>);
        impl DBF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                DBF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DBF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DBF` writer - DBF"]
        pub struct DBF_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DBF_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `RESET` reader - RESET"]
        pub struct RESET_R(crate::FieldReader<bool>);
        impl RESET_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RESET_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RESET_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RESET` writer - RESET"]
        pub struct RESET_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RESET_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `TTCM` reader - TTCM"]
        pub struct TTCM_R(crate::FieldReader<bool>);
        impl TTCM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TTCM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TTCM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TTCM` writer - TTCM"]
        pub struct TTCM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TTCM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `ABOM` reader - ABOM"]
        pub struct ABOM_R(crate::FieldReader<bool>);
        impl ABOM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ABOM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ABOM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ABOM` writer - ABOM"]
        pub struct ABOM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ABOM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `AWUM` reader - AWUM"]
        pub struct AWUM_R(crate::FieldReader<bool>);
        impl AWUM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                AWUM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for AWUM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `AWUM` writer - AWUM"]
        pub struct AWUM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> AWUM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `NART` reader - NART"]
        pub struct NART_R(crate::FieldReader<bool>);
        impl NART_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                NART_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for NART_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `NART` writer - NART"]
        pub struct NART_W<'a> {
            w: &'a mut W,
        }
        impl<'a> NART_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `RFLM` reader - RFLM"]
        pub struct RFLM_R(crate::FieldReader<bool>);
        impl RFLM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RFLM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RFLM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RFLM` writer - RFLM"]
        pub struct RFLM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RFLM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `TXFP` reader - TXFP"]
        pub struct TXFP_R(crate::FieldReader<bool>);
        impl TXFP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXFP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXFP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXFP` writer - TXFP"]
        pub struct TXFP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXFP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `SLEEP` reader - SLEEP"]
        pub struct SLEEP_R(crate::FieldReader<bool>);
        impl SLEEP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SLEEP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SLEEP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SLEEP` writer - SLEEP"]
        pub struct SLEEP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SLEEP_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `INRQ` reader - INRQ"]
        pub struct INRQ_R(crate::FieldReader<bool>);
        impl INRQ_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                INRQ_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for INRQ_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `INRQ` writer - INRQ"]
        pub struct INRQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> INRQ_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 16 - DBF"]
            #[inline(always)]
            pub fn dbf(&self) -> DBF_R {
                DBF_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 15 - RESET"]
            #[inline(always)]
            pub fn reset(&self) -> RESET_R {
                RESET_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 7 - TTCM"]
            #[inline(always)]
            pub fn ttcm(&self) -> TTCM_R {
                TTCM_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 6 - ABOM"]
            #[inline(always)]
            pub fn abom(&self) -> ABOM_R {
                ABOM_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 5 - AWUM"]
            #[inline(always)]
            pub fn awum(&self) -> AWUM_R {
                AWUM_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 4 - NART"]
            #[inline(always)]
            pub fn nart(&self) -> NART_R {
                NART_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 3 - RFLM"]
            #[inline(always)]
            pub fn rflm(&self) -> RFLM_R {
                RFLM_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 2 - TXFP"]
            #[inline(always)]
            pub fn txfp(&self) -> TXFP_R {
                TXFP_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - SLEEP"]
            #[inline(always)]
            pub fn sleep(&self) -> SLEEP_R {
                SLEEP_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - INRQ"]
            #[inline(always)]
            pub fn inrq(&self) -> INRQ_R {
                INRQ_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 16 - DBF"]
            #[inline(always)]
            pub fn dbf(&mut self) -> DBF_W {
                DBF_W { w: self }
            }
            #[doc = "Bit 15 - RESET"]
            #[inline(always)]
            pub fn reset(&mut self) -> RESET_W {
                RESET_W { w: self }
            }
            #[doc = "Bit 7 - TTCM"]
            #[inline(always)]
            pub fn ttcm(&mut self) -> TTCM_W {
                TTCM_W { w: self }
            }
            #[doc = "Bit 6 - ABOM"]
            #[inline(always)]
            pub fn abom(&mut self) -> ABOM_W {
                ABOM_W { w: self }
            }
            #[doc = "Bit 5 - AWUM"]
            #[inline(always)]
            pub fn awum(&mut self) -> AWUM_W {
                AWUM_W { w: self }
            }
            #[doc = "Bit 4 - NART"]
            #[inline(always)]
            pub fn nart(&mut self) -> NART_W {
                NART_W { w: self }
            }
            #[doc = "Bit 3 - RFLM"]
            #[inline(always)]
            pub fn rflm(&mut self) -> RFLM_W {
                RFLM_W { w: self }
            }
            #[doc = "Bit 2 - TXFP"]
            #[inline(always)]
            pub fn txfp(&mut self) -> TXFP_W {
                TXFP_W { w: self }
            }
            #[doc = "Bit 1 - SLEEP"]
            #[inline(always)]
            pub fn sleep(&mut self) -> SLEEP_W {
                SLEEP_W { w: self }
            }
            #[doc = "Bit 0 - INRQ"]
            #[inline(always)]
            pub fn inrq(&mut self) -> INRQ_W {
                INRQ_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "CTLR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctlr](index.html) module"]
        pub struct CTLR_SPEC;
        impl crate::RegisterSpec for CTLR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [ctlr::R](R) reader structure"]
        impl crate::Readable for CTLR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [ctlr::W](W) writer structure"]
        impl crate::Writable for CTLR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets CTLR to value 0"]
        impl crate::Resettable for CTLR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "STATR register accessor: an alias for `Reg<STATR_SPEC>`"]
    pub type STATR = crate::Reg<statr::STATR_SPEC>;
    #[doc = "STATR"]
    pub mod statr {
        #[doc = "Register `STATR` reader"]
        pub struct R(crate::R<STATR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<STATR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<STATR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<STATR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `STATR` writer"]
        pub struct W(crate::W<STATR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<STATR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<STATR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<STATR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `RX` reader - RX"]
        pub struct RX_R(crate::FieldReader<bool>);
        impl RX_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RX_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RX_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SAMP` reader - SAMP"]
        pub struct SAMP_R(crate::FieldReader<bool>);
        impl SAMP_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SAMP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SAMP_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RXM` reader - RXM"]
        pub struct RXM_R(crate::FieldReader<bool>);
        impl RXM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RXM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RXM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXM` reader - TXM"]
        pub struct TXM_R(crate::FieldReader<bool>);
        impl TXM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SLAKI` reader - SLAKI"]
        pub struct SLAKI_R(crate::FieldReader<bool>);
        impl SLAKI_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SLAKI_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SLAKI_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SLAKI` writer - SLAKI"]
        pub struct SLAKI_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SLAKI_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `WKUI` reader - WKUI"]
        pub struct WKUI_R(crate::FieldReader<bool>);
        impl WKUI_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                WKUI_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for WKUI_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `WKUI` writer - WKUI"]
        pub struct WKUI_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WKUI_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `ERRI` reader - ERRI"]
        pub struct ERRI_R(crate::FieldReader<bool>);
        impl ERRI_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ERRI_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ERRI_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ERRI` writer - ERRI"]
        pub struct ERRI_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ERRI_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `SLAK` reader - SLAK"]
        pub struct SLAK_R(crate::FieldReader<bool>);
        impl SLAK_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SLAK_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SLAK_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `INAK` reader - INAK"]
        pub struct INAK_R(crate::FieldReader<bool>);
        impl INAK_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                INAK_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for INAK_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bit 11 - RX"]
            #[inline(always)]
            pub fn rx(&self) -> RX_R {
                RX_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 10 - SAMP"]
            #[inline(always)]
            pub fn samp(&self) -> SAMP_R {
                SAMP_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 9 - RXM"]
            #[inline(always)]
            pub fn rxm(&self) -> RXM_R {
                RXM_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 8 - TXM"]
            #[inline(always)]
            pub fn txm(&self) -> TXM_R {
                TXM_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 4 - SLAKI"]
            #[inline(always)]
            pub fn slaki(&self) -> SLAKI_R {
                SLAKI_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 3 - WKUI"]
            #[inline(always)]
            pub fn wkui(&self) -> WKUI_R {
                WKUI_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 2 - ERRI"]
            #[inline(always)]
            pub fn erri(&self) -> ERRI_R {
                ERRI_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - SLAK"]
            #[inline(always)]
            pub fn slak(&self) -> SLAK_R {
                SLAK_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - INAK"]
            #[inline(always)]
            pub fn inak(&self) -> INAK_R {
                INAK_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 4 - SLAKI"]
            #[inline(always)]
            pub fn slaki(&mut self) -> SLAKI_W {
                SLAKI_W { w: self }
            }
            #[doc = "Bit 3 - WKUI"]
            #[inline(always)]
            pub fn wkui(&mut self) -> WKUI_W {
                WKUI_W { w: self }
            }
            #[doc = "Bit 2 - ERRI"]
            #[inline(always)]
            pub fn erri(&mut self) -> ERRI_W {
                ERRI_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "STATR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [statr](index.html) module"]
        pub struct STATR_SPEC;
        impl crate::RegisterSpec for STATR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [statr::R](R) reader structure"]
        impl crate::Readable for STATR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [statr::W](W) writer structure"]
        impl crate::Writable for STATR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets STATR to value 0"]
        impl crate::Resettable for STATR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TSTATR register accessor: an alias for `Reg<TSTATR_SPEC>`"]
    pub type TSTATR = crate::Reg<tstatr::TSTATR_SPEC>;
    #[doc = "TSTATR"]
    pub mod tstatr {
        #[doc = "Register `TSTATR` reader"]
        pub struct R(crate::R<TSTATR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TSTATR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TSTATR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TSTATR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TSTATR` writer"]
        pub struct W(crate::W<TSTATR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TSTATR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TSTATR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TSTATR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `LOW2` reader - Lowest priority flag for mailbox 2"]
        pub struct LOW2_R(crate::FieldReader<bool>);
        impl LOW2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LOW2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LOW2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LOW1` reader - Lowest priority flag for mailbox 1"]
        pub struct LOW1_R(crate::FieldReader<bool>);
        impl LOW1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LOW1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LOW1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LOW0` reader - Lowest priority flag for mailbox 0"]
        pub struct LOW0_R(crate::FieldReader<bool>);
        impl LOW0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LOW0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LOW0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TME2` reader - Lowest priority flag for mailbox 2"]
        pub struct TME2_R(crate::FieldReader<bool>);
        impl TME2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TME2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TME2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TME1` reader - Lowest priority flag for mailbox 1"]
        pub struct TME1_R(crate::FieldReader<bool>);
        impl TME1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TME1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TME1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TME0` reader - Lowest priority flag for mailbox 0"]
        pub struct TME0_R(crate::FieldReader<bool>);
        impl TME0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TME0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TME0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `CODE` reader - CODE"]
        pub struct CODE_R(crate::FieldReader<u8>);
        impl CODE_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                CODE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for CODE_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ABRQ2` reader - ABRQ2"]
        pub struct ABRQ2_R(crate::FieldReader<bool>);
        impl ABRQ2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ABRQ2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ABRQ2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ABRQ2` writer - ABRQ2"]
        pub struct ABRQ2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ABRQ2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `TERR2` reader - TERR2"]
        pub struct TERR2_R(crate::FieldReader<bool>);
        impl TERR2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TERR2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TERR2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TERR2` writer - TERR2"]
        pub struct TERR2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TERR2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `ALST2` reader - ALST2"]
        pub struct ALST2_R(crate::FieldReader<bool>);
        impl ALST2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ALST2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ALST2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ALST2` writer - ALST2"]
        pub struct ALST2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ALST2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `TXOK2` reader - TXOK2"]
        pub struct TXOK2_R(crate::FieldReader<bool>);
        impl TXOK2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXOK2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXOK2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXOK2` writer - TXOK2"]
        pub struct TXOK2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXOK2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `RQCP2` reader - RQCP2"]
        pub struct RQCP2_R(crate::FieldReader<bool>);
        impl RQCP2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RQCP2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RQCP2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RQCP2` writer - RQCP2"]
        pub struct RQCP2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RQCP2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `ABRQ1` reader - ABRQ1"]
        pub struct ABRQ1_R(crate::FieldReader<bool>);
        impl ABRQ1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ABRQ1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ABRQ1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ABRQ1` writer - ABRQ1"]
        pub struct ABRQ1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ABRQ1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `TERR1` reader - TERR1"]
        pub struct TERR1_R(crate::FieldReader<bool>);
        impl TERR1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TERR1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TERR1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TERR1` writer - TERR1"]
        pub struct TERR1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TERR1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `ALST1` reader - ALST1"]
        pub struct ALST1_R(crate::FieldReader<bool>);
        impl ALST1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ALST1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ALST1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ALST1` writer - ALST1"]
        pub struct ALST1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ALST1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `TXOK1` reader - TXOK1"]
        pub struct TXOK1_R(crate::FieldReader<bool>);
        impl TXOK1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXOK1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXOK1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXOK1` writer - TXOK1"]
        pub struct TXOK1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXOK1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `RQCP1` reader - RQCP1"]
        pub struct RQCP1_R(crate::FieldReader<bool>);
        impl RQCP1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RQCP1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RQCP1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RQCP1` writer - RQCP1"]
        pub struct RQCP1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RQCP1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `ABRQ0` reader - ABRQ0"]
        pub struct ABRQ0_R(crate::FieldReader<bool>);
        impl ABRQ0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ABRQ0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ABRQ0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ABRQ0` writer - ABRQ0"]
        pub struct ABRQ0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ABRQ0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `TERR0` reader - TERR0"]
        pub struct TERR0_R(crate::FieldReader<bool>);
        impl TERR0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TERR0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TERR0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TERR0` writer - TERR0"]
        pub struct TERR0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TERR0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `ALST0` reader - ALST0"]
        pub struct ALST0_R(crate::FieldReader<bool>);
        impl ALST0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ALST0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ALST0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ALST0` writer - ALST0"]
        pub struct ALST0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ALST0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `TXOK0` reader - TXOK0"]
        pub struct TXOK0_R(crate::FieldReader<bool>);
        impl TXOK0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXOK0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXOK0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXOK0` writer - TXOK0"]
        pub struct TXOK0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXOK0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `RQCP0` reader - RQCP0"]
        pub struct RQCP0_R(crate::FieldReader<bool>);
        impl RQCP0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RQCP0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RQCP0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RQCP0` writer - RQCP0"]
        pub struct RQCP0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RQCP0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 31 - Lowest priority flag for mailbox 2"]
            #[inline(always)]
            pub fn low2(&self) -> LOW2_R {
                LOW2_R::new(((self.bits >> 31) & 1) != 0)
            }
            #[doc = "Bit 30 - Lowest priority flag for mailbox 1"]
            #[inline(always)]
            pub fn low1(&self) -> LOW1_R {
                LOW1_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 29 - Lowest priority flag for mailbox 0"]
            #[inline(always)]
            pub fn low0(&self) -> LOW0_R {
                LOW0_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 28 - Lowest priority flag for mailbox 2"]
            #[inline(always)]
            pub fn tme2(&self) -> TME2_R {
                TME2_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 27 - Lowest priority flag for mailbox 1"]
            #[inline(always)]
            pub fn tme1(&self) -> TME1_R {
                TME1_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 26 - Lowest priority flag for mailbox 0"]
            #[inline(always)]
            pub fn tme0(&self) -> TME0_R {
                TME0_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bits 24:25 - CODE"]
            #[inline(always)]
            pub fn code(&self) -> CODE_R {
                CODE_R::new(((self.bits >> 24) & 3) as u8)
            }
            #[doc = "Bit 23 - ABRQ2"]
            #[inline(always)]
            pub fn abrq2(&self) -> ABRQ2_R {
                ABRQ2_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 19 - TERR2"]
            #[inline(always)]
            pub fn terr2(&self) -> TERR2_R {
                TERR2_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 18 - ALST2"]
            #[inline(always)]
            pub fn alst2(&self) -> ALST2_R {
                ALST2_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 17 - TXOK2"]
            #[inline(always)]
            pub fn txok2(&self) -> TXOK2_R {
                TXOK2_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 16 - RQCP2"]
            #[inline(always)]
            pub fn rqcp2(&self) -> RQCP2_R {
                RQCP2_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 15 - ABRQ1"]
            #[inline(always)]
            pub fn abrq1(&self) -> ABRQ1_R {
                ABRQ1_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 11 - TERR1"]
            #[inline(always)]
            pub fn terr1(&self) -> TERR1_R {
                TERR1_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 10 - ALST1"]
            #[inline(always)]
            pub fn alst1(&self) -> ALST1_R {
                ALST1_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 9 - TXOK1"]
            #[inline(always)]
            pub fn txok1(&self) -> TXOK1_R {
                TXOK1_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 8 - RQCP1"]
            #[inline(always)]
            pub fn rqcp1(&self) -> RQCP1_R {
                RQCP1_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 7 - ABRQ0"]
            #[inline(always)]
            pub fn abrq0(&self) -> ABRQ0_R {
                ABRQ0_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 3 - TERR0"]
            #[inline(always)]
            pub fn terr0(&self) -> TERR0_R {
                TERR0_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 2 - ALST0"]
            #[inline(always)]
            pub fn alst0(&self) -> ALST0_R {
                ALST0_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - TXOK0"]
            #[inline(always)]
            pub fn txok0(&self) -> TXOK0_R {
                TXOK0_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - RQCP0"]
            #[inline(always)]
            pub fn rqcp0(&self) -> RQCP0_R {
                RQCP0_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 23 - ABRQ2"]
            #[inline(always)]
            pub fn abrq2(&mut self) -> ABRQ2_W {
                ABRQ2_W { w: self }
            }
            #[doc = "Bit 19 - TERR2"]
            #[inline(always)]
            pub fn terr2(&mut self) -> TERR2_W {
                TERR2_W { w: self }
            }
            #[doc = "Bit 18 - ALST2"]
            #[inline(always)]
            pub fn alst2(&mut self) -> ALST2_W {
                ALST2_W { w: self }
            }
            #[doc = "Bit 17 - TXOK2"]
            #[inline(always)]
            pub fn txok2(&mut self) -> TXOK2_W {
                TXOK2_W { w: self }
            }
            #[doc = "Bit 16 - RQCP2"]
            #[inline(always)]
            pub fn rqcp2(&mut self) -> RQCP2_W {
                RQCP2_W { w: self }
            }
            #[doc = "Bit 15 - ABRQ1"]
            #[inline(always)]
            pub fn abrq1(&mut self) -> ABRQ1_W {
                ABRQ1_W { w: self }
            }
            #[doc = "Bit 11 - TERR1"]
            #[inline(always)]
            pub fn terr1(&mut self) -> TERR1_W {
                TERR1_W { w: self }
            }
            #[doc = "Bit 10 - ALST1"]
            #[inline(always)]
            pub fn alst1(&mut self) -> ALST1_W {
                ALST1_W { w: self }
            }
            #[doc = "Bit 9 - TXOK1"]
            #[inline(always)]
            pub fn txok1(&mut self) -> TXOK1_W {
                TXOK1_W { w: self }
            }
            #[doc = "Bit 8 - RQCP1"]
            #[inline(always)]
            pub fn rqcp1(&mut self) -> RQCP1_W {
                RQCP1_W { w: self }
            }
            #[doc = "Bit 7 - ABRQ0"]
            #[inline(always)]
            pub fn abrq0(&mut self) -> ABRQ0_W {
                ABRQ0_W { w: self }
            }
            #[doc = "Bit 3 - TERR0"]
            #[inline(always)]
            pub fn terr0(&mut self) -> TERR0_W {
                TERR0_W { w: self }
            }
            #[doc = "Bit 2 - ALST0"]
            #[inline(always)]
            pub fn alst0(&mut self) -> ALST0_W {
                ALST0_W { w: self }
            }
            #[doc = "Bit 1 - TXOK0"]
            #[inline(always)]
            pub fn txok0(&mut self) -> TXOK0_W {
                TXOK0_W { w: self }
            }
            #[doc = "Bit 0 - RQCP0"]
            #[inline(always)]
            pub fn rqcp0(&mut self) -> RQCP0_W {
                RQCP0_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TSTATR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tstatr](index.html) module"]
        pub struct TSTATR_SPEC;
        impl crate::RegisterSpec for TSTATR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [tstatr::R](R) reader structure"]
        impl crate::Readable for TSTATR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [tstatr::W](W) writer structure"]
        impl crate::Writable for TSTATR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TSTATR to value 0"]
        impl crate::Resettable for TSTATR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RFIFO0 register accessor: an alias for `Reg<RFIFO0_SPEC>`"]
    pub type RFIFO0 = crate::Reg<rfifo0::RFIFO0_SPEC>;
    #[doc = "RFIFO0"]
    pub mod rfifo0 {
        #[doc = "Register `RFIFO0` reader"]
        pub struct R(crate::R<RFIFO0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RFIFO0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RFIFO0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RFIFO0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `RFIFO0` writer"]
        pub struct W(crate::W<RFIFO0_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<RFIFO0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<RFIFO0_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<RFIFO0_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `RFOM0` reader - RFOM0"]
        pub struct RFOM0_R(crate::FieldReader<bool>);
        impl RFOM0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RFOM0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RFOM0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RFOM0` writer - RFOM0"]
        pub struct RFOM0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RFOM0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FOVR0` reader - FOVR0"]
        pub struct FOVR0_R(crate::FieldReader<bool>);
        impl FOVR0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FOVR0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FOVR0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FOVR0` writer - FOVR0"]
        pub struct FOVR0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FOVR0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FULL0` reader - FULL0"]
        pub struct FULL0_R(crate::FieldReader<bool>);
        impl FULL0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FULL0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FULL0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FULL0` writer - FULL0"]
        pub struct FULL0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FULL0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FMP0` reader - FMP0"]
        pub struct FMP0_R(crate::FieldReader<u8>);
        impl FMP0_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                FMP0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FMP0_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bit 5 - RFOM0"]
            #[inline(always)]
            pub fn rfom0(&self) -> RFOM0_R {
                RFOM0_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 4 - FOVR0"]
            #[inline(always)]
            pub fn fovr0(&self) -> FOVR0_R {
                FOVR0_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 3 - FULL0"]
            #[inline(always)]
            pub fn full0(&self) -> FULL0_R {
                FULL0_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bits 0:1 - FMP0"]
            #[inline(always)]
            pub fn fmp0(&self) -> FMP0_R {
                FMP0_R::new((self.bits & 3) as u8)
            }
        }
        impl W {
            #[doc = "Bit 5 - RFOM0"]
            #[inline(always)]
            pub fn rfom0(&mut self) -> RFOM0_W {
                RFOM0_W { w: self }
            }
            #[doc = "Bit 4 - FOVR0"]
            #[inline(always)]
            pub fn fovr0(&mut self) -> FOVR0_W {
                FOVR0_W { w: self }
            }
            #[doc = "Bit 3 - FULL0"]
            #[inline(always)]
            pub fn full0(&mut self) -> FULL0_W {
                FULL0_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "RFIFO0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rfifo0](index.html) module"]
        pub struct RFIFO0_SPEC;
        impl crate::RegisterSpec for RFIFO0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rfifo0::R](R) reader structure"]
        impl crate::Readable for RFIFO0_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [rfifo0::W](W) writer structure"]
        impl crate::Writable for RFIFO0_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets RFIFO0 to value 0"]
        impl crate::Resettable for RFIFO0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RFIFO1 register accessor: an alias for `Reg<RFIFO1_SPEC>`"]
    pub type RFIFO1 = crate::Reg<rfifo1::RFIFO1_SPEC>;
    #[doc = "RFIFO1"]
    pub mod rfifo1 {
        #[doc = "Register `RFIFO1` reader"]
        pub struct R(crate::R<RFIFO1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RFIFO1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RFIFO1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RFIFO1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `RFIFO1` writer"]
        pub struct W(crate::W<RFIFO1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<RFIFO1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<RFIFO1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<RFIFO1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `RFOM1` reader - RFOM1"]
        pub struct RFOM1_R(crate::FieldReader<bool>);
        impl RFOM1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RFOM1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RFOM1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RFOM1` writer - RFOM1"]
        pub struct RFOM1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RFOM1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FOVR1` reader - FOVR1"]
        pub struct FOVR1_R(crate::FieldReader<bool>);
        impl FOVR1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FOVR1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FOVR1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FOVR1` writer - FOVR1"]
        pub struct FOVR1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FOVR1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FULL1` reader - FULL1"]
        pub struct FULL1_R(crate::FieldReader<bool>);
        impl FULL1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FULL1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FULL1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FULL1` writer - FULL1"]
        pub struct FULL1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FULL1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FMP1` reader - FMP1"]
        pub struct FMP1_R(crate::FieldReader<u8>);
        impl FMP1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                FMP1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FMP1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bit 5 - RFOM1"]
            #[inline(always)]
            pub fn rfom1(&self) -> RFOM1_R {
                RFOM1_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 4 - FOVR1"]
            #[inline(always)]
            pub fn fovr1(&self) -> FOVR1_R {
                FOVR1_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 3 - FULL1"]
            #[inline(always)]
            pub fn full1(&self) -> FULL1_R {
                FULL1_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bits 0:1 - FMP1"]
            #[inline(always)]
            pub fn fmp1(&self) -> FMP1_R {
                FMP1_R::new((self.bits & 3) as u8)
            }
        }
        impl W {
            #[doc = "Bit 5 - RFOM1"]
            #[inline(always)]
            pub fn rfom1(&mut self) -> RFOM1_W {
                RFOM1_W { w: self }
            }
            #[doc = "Bit 4 - FOVR1"]
            #[inline(always)]
            pub fn fovr1(&mut self) -> FOVR1_W {
                FOVR1_W { w: self }
            }
            #[doc = "Bit 3 - FULL1"]
            #[inline(always)]
            pub fn full1(&mut self) -> FULL1_W {
                FULL1_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "RFIFO1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rfifo1](index.html) module"]
        pub struct RFIFO1_SPEC;
        impl crate::RegisterSpec for RFIFO1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rfifo1::R](R) reader structure"]
        impl crate::Readable for RFIFO1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [rfifo1::W](W) writer structure"]
        impl crate::Writable for RFIFO1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets RFIFO1 to value 0"]
        impl crate::Resettable for RFIFO1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "INTENR register accessor: an alias for `Reg<INTENR_SPEC>`"]
    pub type INTENR = crate::Reg<intenr::INTENR_SPEC>;
    #[doc = "INTENR"]
    pub mod intenr {
        #[doc = "Register `INTENR` reader"]
        pub struct R(crate::R<INTENR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<INTENR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<INTENR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<INTENR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `INTENR` writer"]
        pub struct W(crate::W<INTENR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<INTENR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<INTENR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<INTENR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `SLKIE` reader - SLKIE"]
        pub struct SLKIE_R(crate::FieldReader<bool>);
        impl SLKIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SLKIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SLKIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SLKIE` writer - SLKIE"]
        pub struct SLKIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SLKIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `WKUIE` reader - WKUIE"]
        pub struct WKUIE_R(crate::FieldReader<bool>);
        impl WKUIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                WKUIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for WKUIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `WKUIE` writer - WKUIE"]
        pub struct WKUIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> WKUIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `ERRIE` reader - ERRIE"]
        pub struct ERRIE_R(crate::FieldReader<bool>);
        impl ERRIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                ERRIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for ERRIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `ERRIE` writer - ERRIE"]
        pub struct ERRIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> ERRIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `LECIE` reader - LECIE"]
        pub struct LECIE_R(crate::FieldReader<bool>);
        impl LECIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LECIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LECIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LECIE` writer - LECIE"]
        pub struct LECIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LECIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `BOFIE` reader - BOFIE"]
        pub struct BOFIE_R(crate::FieldReader<bool>);
        impl BOFIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                BOFIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for BOFIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `BOFIE` writer - BOFIE"]
        pub struct BOFIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BOFIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `EPVIE` reader - EPVIE"]
        pub struct EPVIE_R(crate::FieldReader<bool>);
        impl EPVIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EPVIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EPVIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EPVIE` writer - EPVIE"]
        pub struct EPVIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EPVIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `EWGIE` reader - EWGIE"]
        pub struct EWGIE_R(crate::FieldReader<bool>);
        impl EWGIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EWGIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EWGIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EWGIE` writer - EWGIE"]
        pub struct EWGIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EWGIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FOVIE1` reader - FOVIE1"]
        pub struct FOVIE1_R(crate::FieldReader<bool>);
        impl FOVIE1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FOVIE1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FOVIE1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FOVIE1` writer - FOVIE1"]
        pub struct FOVIE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FOVIE1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FFIE1` reader - FFIE1"]
        pub struct FFIE1_R(crate::FieldReader<bool>);
        impl FFIE1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFIE1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFIE1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFIE1` writer - FFIE1"]
        pub struct FFIE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFIE1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FMPIE1` reader - FMPIE1"]
        pub struct FMPIE1_R(crate::FieldReader<bool>);
        impl FMPIE1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FMPIE1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FMPIE1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FMPIE1` writer - FMPIE1"]
        pub struct FMPIE1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FMPIE1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FOVIE0` reader - FOVIE0"]
        pub struct FOVIE0_R(crate::FieldReader<bool>);
        impl FOVIE0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FOVIE0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FOVIE0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FOVIE0` writer - FOVIE0"]
        pub struct FOVIE0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FOVIE0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FFIE0` reader - FFIE0"]
        pub struct FFIE0_R(crate::FieldReader<bool>);
        impl FFIE0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFIE0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFIE0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFIE0` writer - FFIE0"]
        pub struct FFIE0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFIE0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FMPIE0` reader - FMPIE0"]
        pub struct FMPIE0_R(crate::FieldReader<bool>);
        impl FMPIE0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FMPIE0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FMPIE0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FMPIE0` writer - FMPIE0"]
        pub struct FMPIE0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FMPIE0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `TMEIE` reader - TMEIE"]
        pub struct TMEIE_R(crate::FieldReader<bool>);
        impl TMEIE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TMEIE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TMEIE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TMEIE` writer - TMEIE"]
        pub struct TMEIE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TMEIE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 17 - SLKIE"]
            #[inline(always)]
            pub fn slkie(&self) -> SLKIE_R {
                SLKIE_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 16 - WKUIE"]
            #[inline(always)]
            pub fn wkuie(&self) -> WKUIE_R {
                WKUIE_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 15 - ERRIE"]
            #[inline(always)]
            pub fn errie(&self) -> ERRIE_R {
                ERRIE_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 11 - LECIE"]
            #[inline(always)]
            pub fn lecie(&self) -> LECIE_R {
                LECIE_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 10 - BOFIE"]
            #[inline(always)]
            pub fn bofie(&self) -> BOFIE_R {
                BOFIE_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 9 - EPVIE"]
            #[inline(always)]
            pub fn epvie(&self) -> EPVIE_R {
                EPVIE_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 8 - EWGIE"]
            #[inline(always)]
            pub fn ewgie(&self) -> EWGIE_R {
                EWGIE_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 6 - FOVIE1"]
            #[inline(always)]
            pub fn fovie1(&self) -> FOVIE1_R {
                FOVIE1_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 5 - FFIE1"]
            #[inline(always)]
            pub fn ffie1(&self) -> FFIE1_R {
                FFIE1_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 4 - FMPIE1"]
            #[inline(always)]
            pub fn fmpie1(&self) -> FMPIE1_R {
                FMPIE1_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 3 - FOVIE0"]
            #[inline(always)]
            pub fn fovie0(&self) -> FOVIE0_R {
                FOVIE0_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 2 - FFIE0"]
            #[inline(always)]
            pub fn ffie0(&self) -> FFIE0_R {
                FFIE0_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - FMPIE0"]
            #[inline(always)]
            pub fn fmpie0(&self) -> FMPIE0_R {
                FMPIE0_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - TMEIE"]
            #[inline(always)]
            pub fn tmeie(&self) -> TMEIE_R {
                TMEIE_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 17 - SLKIE"]
            #[inline(always)]
            pub fn slkie(&mut self) -> SLKIE_W {
                SLKIE_W { w: self }
            }
            #[doc = "Bit 16 - WKUIE"]
            #[inline(always)]
            pub fn wkuie(&mut self) -> WKUIE_W {
                WKUIE_W { w: self }
            }
            #[doc = "Bit 15 - ERRIE"]
            #[inline(always)]
            pub fn errie(&mut self) -> ERRIE_W {
                ERRIE_W { w: self }
            }
            #[doc = "Bit 11 - LECIE"]
            #[inline(always)]
            pub fn lecie(&mut self) -> LECIE_W {
                LECIE_W { w: self }
            }
            #[doc = "Bit 10 - BOFIE"]
            #[inline(always)]
            pub fn bofie(&mut self) -> BOFIE_W {
                BOFIE_W { w: self }
            }
            #[doc = "Bit 9 - EPVIE"]
            #[inline(always)]
            pub fn epvie(&mut self) -> EPVIE_W {
                EPVIE_W { w: self }
            }
            #[doc = "Bit 8 - EWGIE"]
            #[inline(always)]
            pub fn ewgie(&mut self) -> EWGIE_W {
                EWGIE_W { w: self }
            }
            #[doc = "Bit 6 - FOVIE1"]
            #[inline(always)]
            pub fn fovie1(&mut self) -> FOVIE1_W {
                FOVIE1_W { w: self }
            }
            #[doc = "Bit 5 - FFIE1"]
            #[inline(always)]
            pub fn ffie1(&mut self) -> FFIE1_W {
                FFIE1_W { w: self }
            }
            #[doc = "Bit 4 - FMPIE1"]
            #[inline(always)]
            pub fn fmpie1(&mut self) -> FMPIE1_W {
                FMPIE1_W { w: self }
            }
            #[doc = "Bit 3 - FOVIE0"]
            #[inline(always)]
            pub fn fovie0(&mut self) -> FOVIE0_W {
                FOVIE0_W { w: self }
            }
            #[doc = "Bit 2 - FFIE0"]
            #[inline(always)]
            pub fn ffie0(&mut self) -> FFIE0_W {
                FFIE0_W { w: self }
            }
            #[doc = "Bit 1 - FMPIE0"]
            #[inline(always)]
            pub fn fmpie0(&mut self) -> FMPIE0_W {
                FMPIE0_W { w: self }
            }
            #[doc = "Bit 0 - TMEIE"]
            #[inline(always)]
            pub fn tmeie(&mut self) -> TMEIE_W {
                TMEIE_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "INTENR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intenr](index.html) module"]
        pub struct INTENR_SPEC;
        impl crate::RegisterSpec for INTENR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [intenr::R](R) reader structure"]
        impl crate::Readable for INTENR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [intenr::W](W) writer structure"]
        impl crate::Writable for INTENR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets INTENR to value 0"]
        impl crate::Resettable for INTENR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "ERRSR register accessor: an alias for `Reg<ERRSR_SPEC>`"]
    pub type ERRSR = crate::Reg<errsr::ERRSR_SPEC>;
    #[doc = "ERRSR"]
    pub mod errsr {
        #[doc = "Register `ERRSR` reader"]
        pub struct R(crate::R<ERRSR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<ERRSR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<ERRSR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<ERRSR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `ERRSR` writer"]
        pub struct W(crate::W<ERRSR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<ERRSR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<ERRSR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<ERRSR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `REC` reader - REC"]
        pub struct REC_R(crate::FieldReader<u8>);
        impl REC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                REC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for REC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TEC` reader - TEC"]
        pub struct TEC_R(crate::FieldReader<u8>);
        impl TEC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                TEC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TEC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LEC` reader - LEC"]
        pub struct LEC_R(crate::FieldReader<u8>);
        impl LEC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                LEC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LEC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LEC` writer - LEC"]
        pub struct LEC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LEC_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(7 << 4)) | ((value as u32 & 7) << 4);
                self.w
            }
        }
        #[doc = "Field `BOFF` reader - BOFF"]
        pub struct BOFF_R(crate::FieldReader<bool>);
        impl BOFF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                BOFF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for BOFF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EPVF` reader - EPVF"]
        pub struct EPVF_R(crate::FieldReader<bool>);
        impl EPVF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EPVF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EPVF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EWGF` reader - EWGF"]
        pub struct EWGF_R(crate::FieldReader<bool>);
        impl EWGF_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                EWGF_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EWGF_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 24:31 - REC"]
            #[inline(always)]
            pub fn rec(&self) -> REC_R {
                REC_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - TEC"]
            #[inline(always)]
            pub fn tec(&self) -> TEC_R {
                TEC_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 4:6 - LEC"]
            #[inline(always)]
            pub fn lec(&self) -> LEC_R {
                LEC_R::new(((self.bits >> 4) & 7) as u8)
            }
            #[doc = "Bit 2 - BOFF"]
            #[inline(always)]
            pub fn boff(&self) -> BOFF_R {
                BOFF_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - EPVF"]
            #[inline(always)]
            pub fn epvf(&self) -> EPVF_R {
                EPVF_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - EWGF"]
            #[inline(always)]
            pub fn ewgf(&self) -> EWGF_R {
                EWGF_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 4:6 - LEC"]
            #[inline(always)]
            pub fn lec(&mut self) -> LEC_W {
                LEC_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "ERRSR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [errsr](index.html) module"]
        pub struct ERRSR_SPEC;
        impl crate::RegisterSpec for ERRSR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [errsr::R](R) reader structure"]
        impl crate::Readable for ERRSR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [errsr::W](W) writer structure"]
        impl crate::Writable for ERRSR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets ERRSR to value 0"]
        impl crate::Resettable for ERRSR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "BTIMR register accessor: an alias for `Reg<BTIMR_SPEC>`"]
    pub type BTIMR = crate::Reg<btimr::BTIMR_SPEC>;
    #[doc = "BTIMR"]
    pub mod btimr {
        #[doc = "Register `BTIMR` reader"]
        pub struct R(crate::R<BTIMR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<BTIMR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<BTIMR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<BTIMR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `BTIMR` writer"]
        pub struct W(crate::W<BTIMR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<BTIMR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<BTIMR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<BTIMR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `SILM` reader - SILM"]
        pub struct SILM_R(crate::FieldReader<bool>);
        impl SILM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                SILM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SILM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SILM` writer - SILM"]
        pub struct SILM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SILM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        #[doc = "Field `LBKM` reader - LBKM"]
        pub struct LBKM_R(crate::FieldReader<bool>);
        impl LBKM_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                LBKM_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for LBKM_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `LBKM` writer - LBKM"]
        pub struct LBKM_W<'a> {
            w: &'a mut W,
        }
        impl<'a> LBKM_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `SJW` reader - SJW"]
        pub struct SJW_R(crate::FieldReader<u8>);
        impl SJW_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                SJW_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for SJW_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `SJW` writer - SJW"]
        pub struct SJW_W<'a> {
            w: &'a mut W,
        }
        impl<'a> SJW_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(3 << 24)) | ((value as u32 & 3) << 24);
                self.w
            }
        }
        #[doc = "Field `TS2` reader - TS2"]
        pub struct TS2_R(crate::FieldReader<u8>);
        impl TS2_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                TS2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TS2_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TS2` writer - TS2"]
        pub struct TS2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TS2_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(7 << 20)) | ((value as u32 & 7) << 20);
                self.w
            }
        }
        #[doc = "Field `TS1` reader - TS1"]
        pub struct TS1_R(crate::FieldReader<u8>);
        impl TS1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                TS1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TS1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TS1` writer - TS1"]
        pub struct TS1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TS1_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x0f << 16)) | ((value as u32 & 0x0f) << 16);
                self.w
            }
        }
        #[doc = "Field `BRP` reader - BRP"]
        pub struct BRP_R(crate::FieldReader<u16>);
        impl BRP_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                BRP_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for BRP_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `BRP` writer - BRP"]
        pub struct BRP_W<'a> {
            w: &'a mut W,
        }
        impl<'a> BRP_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x03ff) | (value as u32 & 0x03ff);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 31 - SILM"]
            #[inline(always)]
            pub fn silm(&self) -> SILM_R {
                SILM_R::new(((self.bits >> 31) & 1) != 0)
            }
            #[doc = "Bit 30 - LBKM"]
            #[inline(always)]
            pub fn lbkm(&self) -> LBKM_R {
                LBKM_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bits 24:25 - SJW"]
            #[inline(always)]
            pub fn sjw(&self) -> SJW_R {
                SJW_R::new(((self.bits >> 24) & 3) as u8)
            }
            #[doc = "Bits 20:22 - TS2"]
            #[inline(always)]
            pub fn ts2(&self) -> TS2_R {
                TS2_R::new(((self.bits >> 20) & 7) as u8)
            }
            #[doc = "Bits 16:19 - TS1"]
            #[inline(always)]
            pub fn ts1(&self) -> TS1_R {
                TS1_R::new(((self.bits >> 16) & 0x0f) as u8)
            }
            #[doc = "Bits 0:9 - BRP"]
            #[inline(always)]
            pub fn brp(&self) -> BRP_R {
                BRP_R::new((self.bits & 0x03ff) as u16)
            }
        }
        impl W {
            #[doc = "Bit 31 - SILM"]
            #[inline(always)]
            pub fn silm(&mut self) -> SILM_W {
                SILM_W { w: self }
            }
            #[doc = "Bit 30 - LBKM"]
            #[inline(always)]
            pub fn lbkm(&mut self) -> LBKM_W {
                LBKM_W { w: self }
            }
            #[doc = "Bits 24:25 - SJW"]
            #[inline(always)]
            pub fn sjw(&mut self) -> SJW_W {
                SJW_W { w: self }
            }
            #[doc = "Bits 20:22 - TS2"]
            #[inline(always)]
            pub fn ts2(&mut self) -> TS2_W {
                TS2_W { w: self }
            }
            #[doc = "Bits 16:19 - TS1"]
            #[inline(always)]
            pub fn ts1(&mut self) -> TS1_W {
                TS1_W { w: self }
            }
            #[doc = "Bits 0:9 - BRP"]
            #[inline(always)]
            pub fn brp(&mut self) -> BRP_W {
                BRP_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "BTIMR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [btimr](index.html) module"]
        pub struct BTIMR_SPEC;
        impl crate::RegisterSpec for BTIMR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [btimr::R](R) reader structure"]
        impl crate::Readable for BTIMR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [btimr::W](W) writer structure"]
        impl crate::Writable for BTIMR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets BTIMR to value 0"]
        impl crate::Resettable for BTIMR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMIR0 register accessor: an alias for `Reg<TXMIR0_SPEC>`"]
    pub type TXMIR0 = crate::Reg<txmir0::TXMIR0_SPEC>;
    #[doc = "TXMIR0"]
    pub mod txmir0 {
        #[doc = "Register `TXMIR0` reader"]
        pub struct R(crate::R<TXMIR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMIR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMIR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMIR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMIR0` writer"]
        pub struct W(crate::W<TXMIR0_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMIR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMIR0_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMIR0_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `STID` reader - STID"]
        pub struct STID_R(crate::FieldReader<u16>);
        impl STID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                STID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STID_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STID` writer - STID"]
        pub struct STID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07ff << 21)) | ((value as u32 & 0x07ff) << 21);
                self.w
            }
        }
        #[doc = "Field `EXID` reader - EXID"]
        pub struct EXID_R(crate::FieldReader<u32>);
        impl EXID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u32) -> Self {
                EXID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EXID_R {
            type Target = crate::FieldReader<u32>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EXID` writer - EXID"]
        pub struct EXID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EXID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits =
                    (self.w.bits & !(0x0003_ffff << 3)) | ((value as u32 & 0x0003_ffff) << 3);
                self.w
            }
        }
        #[doc = "Field `IDE` reader - IDE"]
        pub struct IDE_R(crate::FieldReader<bool>);
        impl IDE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                IDE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for IDE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `IDE` writer - IDE"]
        pub struct IDE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IDE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `RTR` reader - RTR"]
        pub struct RTR_R(crate::FieldReader<bool>);
        impl RTR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RTR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RTR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RTR` writer - RTR"]
        pub struct RTR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RTR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `TXRQ` reader - TXRQ"]
        pub struct TXRQ_R(crate::FieldReader<bool>);
        impl TXRQ_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXRQ_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXRQ_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXRQ` writer - TXRQ"]
        pub struct TXRQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXRQ_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&self) -> STID_R {
                STID_R::new(((self.bits >> 21) & 0x07ff) as u16)
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&self) -> EXID_R {
                EXID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&self) -> IDE_R {
                IDE_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&self) -> RTR_R {
                RTR_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - TXRQ"]
            #[inline(always)]
            pub fn txrq(&self) -> TXRQ_R {
                TXRQ_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&mut self) -> STID_W {
                STID_W { w: self }
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&mut self) -> EXID_W {
                EXID_W { w: self }
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&mut self) -> IDE_W {
                IDE_W { w: self }
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&mut self) -> RTR_W {
                RTR_W { w: self }
            }
            #[doc = "Bit 0 - TXRQ"]
            #[inline(always)]
            pub fn txrq(&mut self) -> TXRQ_W {
                TXRQ_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMIR0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmir0](index.html) module"]
        pub struct TXMIR0_SPEC;
        impl crate::RegisterSpec for TXMIR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmir0::R](R) reader structure"]
        impl crate::Readable for TXMIR0_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmir0::W](W) writer structure"]
        impl crate::Writable for TXMIR0_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMIR0 to value 0"]
        impl crate::Resettable for TXMIR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDTR0 register accessor: an alias for `Reg<TXMDTR0_SPEC>`"]
    pub type TXMDTR0 = crate::Reg<txmdtr0::TXMDTR0_SPEC>;
    #[doc = "TXMDTR0"]
    pub mod txmdtr0 {
        #[doc = "Register `TXMDTR0` reader"]
        pub struct R(crate::R<TXMDTR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDTR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDTR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDTR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDTR0` writer"]
        pub struct W(crate::W<TXMDTR0_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDTR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDTR0_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDTR0_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `TIME` reader - TIME"]
        pub struct TIME_R(crate::FieldReader<u16>);
        impl TIME_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                TIME_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TIME_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TIME` writer - TIME"]
        pub struct TIME_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TIME_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
                self.w
            }
        }
        #[doc = "Field `TGT` reader - TGT"]
        pub struct TGT_R(crate::FieldReader<bool>);
        impl TGT_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TGT_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TGT_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TGT` writer - TGT"]
        pub struct TGT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TGT_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `DLC` reader - DLC"]
        pub struct DLC_R(crate::FieldReader<u8>);
        impl DLC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DLC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DLC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DLC` writer - DLC"]
        pub struct DLC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DLC_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&self) -> TIME_R {
                TIME_R::new(((self.bits >> 16) & 0xffff) as u16)
            }
            #[doc = "Bit 8 - TGT"]
            #[inline(always)]
            pub fn tgt(&self) -> TGT_R {
                TGT_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&self) -> DLC_R {
                DLC_R::new((self.bits & 0x0f) as u8)
            }
        }
        impl W {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&mut self) -> TIME_W {
                TIME_W { w: self }
            }
            #[doc = "Bit 8 - TGT"]
            #[inline(always)]
            pub fn tgt(&mut self) -> TGT_W {
                TGT_W { w: self }
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&mut self) -> DLC_W {
                DLC_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDTR0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdtr0](index.html) module"]
        pub struct TXMDTR0_SPEC;
        impl crate::RegisterSpec for TXMDTR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdtr0::R](R) reader structure"]
        impl crate::Readable for TXMDTR0_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdtr0::W](W) writer structure"]
        impl crate::Writable for TXMDTR0_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDTR0 to value 0"]
        impl crate::Resettable for TXMDTR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDLR0 register accessor: an alias for `Reg<TXMDLR0_SPEC>`"]
    pub type TXMDLR0 = crate::Reg<txmdlr0::TXMDLR0_SPEC>;
    #[doc = "TXMDLR0"]
    pub mod txmdlr0 {
        #[doc = "Register `TXMDLR0` reader"]
        pub struct R(crate::R<TXMDLR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDLR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDLR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDLR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDLR0` writer"]
        pub struct W(crate::W<TXMDLR0_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDLR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDLR0_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDLR0_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DATA3` reader - DATA3"]
        pub struct DATA3_R(crate::FieldReader<u8>);
        impl DATA3_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA3_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA3` writer - DATA3"]
        pub struct DATA3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA3_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
                self.w
            }
        }
        #[doc = "Field `DATA2` reader - DATA2"]
        pub struct DATA2_R(crate::FieldReader<u8>);
        impl DATA2_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA2_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA2` writer - DATA2"]
        pub struct DATA2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA2_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
                self.w
            }
        }
        #[doc = "Field `DATA1` reader - DATA1"]
        pub struct DATA1_R(crate::FieldReader<u8>);
        impl DATA1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA1` writer - DATA1"]
        pub struct DATA1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA1_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
                self.w
            }
        }
        #[doc = "Field `DATA0` reader - DATA0"]
        pub struct DATA0_R(crate::FieldReader<u8>);
        impl DATA0_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA0_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA0` writer - DATA0"]
        pub struct DATA0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA0_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&self) -> DATA3_R {
                DATA3_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&self) -> DATA2_R {
                DATA2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&self) -> DATA1_R {
                DATA1_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&self) -> DATA0_R {
                DATA0_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&mut self) -> DATA3_W {
                DATA3_W { w: self }
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&mut self) -> DATA2_W {
                DATA2_W { w: self }
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&mut self) -> DATA1_W {
                DATA1_W { w: self }
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&mut self) -> DATA0_W {
                DATA0_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDLR0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdlr0](index.html) module"]
        pub struct TXMDLR0_SPEC;
        impl crate::RegisterSpec for TXMDLR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdlr0::R](R) reader structure"]
        impl crate::Readable for TXMDLR0_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdlr0::W](W) writer structure"]
        impl crate::Writable for TXMDLR0_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDLR0 to value 0"]
        impl crate::Resettable for TXMDLR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDHR0 register accessor: an alias for `Reg<TXMDHR0_SPEC>`"]
    pub type TXMDHR0 = crate::Reg<txmdhr0::TXMDHR0_SPEC>;
    #[doc = "TXMDHR0"]
    pub mod txmdhr0 {
        #[doc = "Register `TXMDHR0` reader"]
        pub struct R(crate::R<TXMDHR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDHR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDHR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDHR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDHR0` writer"]
        pub struct W(crate::W<TXMDHR0_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDHR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDHR0_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDHR0_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DATA7` reader - DATA7"]
        pub struct DATA7_R(crate::FieldReader<u8>);
        impl DATA7_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA7_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA7` writer - DATA7"]
        pub struct DATA7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA7_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
                self.w
            }
        }
        #[doc = "Field `DATA6` reader - DATA6"]
        pub struct DATA6_R(crate::FieldReader<u8>);
        impl DATA6_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA6_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA6` writer - DATA6"]
        pub struct DATA6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA6_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
                self.w
            }
        }
        #[doc = "Field `DATA5` reader - DATA5"]
        pub struct DATA5_R(crate::FieldReader<u8>);
        impl DATA5_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA5_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA5` writer - DATA5"]
        pub struct DATA5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA5_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
                self.w
            }
        }
        #[doc = "Field `DATA4` reader - DATA4"]
        pub struct DATA4_R(crate::FieldReader<u8>);
        impl DATA4_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA4_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA4` writer - DATA4"]
        pub struct DATA4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA4_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&self) -> DATA7_R {
                DATA7_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&self) -> DATA6_R {
                DATA6_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&self) -> DATA5_R {
                DATA5_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&self) -> DATA4_R {
                DATA4_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&mut self) -> DATA7_W {
                DATA7_W { w: self }
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&mut self) -> DATA6_W {
                DATA6_W { w: self }
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&mut self) -> DATA5_W {
                DATA5_W { w: self }
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&mut self) -> DATA4_W {
                DATA4_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDHR0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdhr0](index.html) module"]
        pub struct TXMDHR0_SPEC;
        impl crate::RegisterSpec for TXMDHR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdhr0::R](R) reader structure"]
        impl crate::Readable for TXMDHR0_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdhr0::W](W) writer structure"]
        impl crate::Writable for TXMDHR0_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDHR0 to value 0"]
        impl crate::Resettable for TXMDHR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMIR1 register accessor: an alias for `Reg<TXMIR1_SPEC>`"]
    pub type TXMIR1 = crate::Reg<txmir1::TXMIR1_SPEC>;
    #[doc = "TXMIR1"]
    pub mod txmir1 {
        #[doc = "Register `TXMIR1` reader"]
        pub struct R(crate::R<TXMIR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMIR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMIR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMIR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMIR1` writer"]
        pub struct W(crate::W<TXMIR1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMIR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMIR1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMIR1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `STID` reader - STID"]
        pub struct STID_R(crate::FieldReader<u16>);
        impl STID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                STID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STID_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STID` writer - STID"]
        pub struct STID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07ff << 21)) | ((value as u32 & 0x07ff) << 21);
                self.w
            }
        }
        #[doc = "Field `EXID` reader - EXID"]
        pub struct EXID_R(crate::FieldReader<u32>);
        impl EXID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u32) -> Self {
                EXID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EXID_R {
            type Target = crate::FieldReader<u32>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EXID` writer - EXID"]
        pub struct EXID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EXID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits =
                    (self.w.bits & !(0x0003_ffff << 3)) | ((value as u32 & 0x0003_ffff) << 3);
                self.w
            }
        }
        #[doc = "Field `IDE` reader - IDE"]
        pub struct IDE_R(crate::FieldReader<bool>);
        impl IDE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                IDE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for IDE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `IDE` writer - IDE"]
        pub struct IDE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IDE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `RTR` reader - RTR"]
        pub struct RTR_R(crate::FieldReader<bool>);
        impl RTR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RTR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RTR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RTR` writer - RTR"]
        pub struct RTR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RTR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `TXRQ` reader - TXRQ"]
        pub struct TXRQ_R(crate::FieldReader<bool>);
        impl TXRQ_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXRQ_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXRQ_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXRQ` writer - TXRQ"]
        pub struct TXRQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXRQ_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&self) -> STID_R {
                STID_R::new(((self.bits >> 21) & 0x07ff) as u16)
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&self) -> EXID_R {
                EXID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&self) -> IDE_R {
                IDE_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&self) -> RTR_R {
                RTR_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - TXRQ"]
            #[inline(always)]
            pub fn txrq(&self) -> TXRQ_R {
                TXRQ_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&mut self) -> STID_W {
                STID_W { w: self }
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&mut self) -> EXID_W {
                EXID_W { w: self }
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&mut self) -> IDE_W {
                IDE_W { w: self }
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&mut self) -> RTR_W {
                RTR_W { w: self }
            }
            #[doc = "Bit 0 - TXRQ"]
            #[inline(always)]
            pub fn txrq(&mut self) -> TXRQ_W {
                TXRQ_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMIR1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmir1](index.html) module"]
        pub struct TXMIR1_SPEC;
        impl crate::RegisterSpec for TXMIR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmir1::R](R) reader structure"]
        impl crate::Readable for TXMIR1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmir1::W](W) writer structure"]
        impl crate::Writable for TXMIR1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMIR1 to value 0"]
        impl crate::Resettable for TXMIR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDTR1 register accessor: an alias for `Reg<TXMDTR1_SPEC>`"]
    pub type TXMDTR1 = crate::Reg<txmdtr1::TXMDTR1_SPEC>;
    #[doc = "TXMDTR1"]
    pub mod txmdtr1 {
        #[doc = "Register `TXMDTR1` reader"]
        pub struct R(crate::R<TXMDTR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDTR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDTR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDTR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDTR1` writer"]
        pub struct W(crate::W<TXMDTR1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDTR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDTR1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDTR1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `TIME` reader - TIME"]
        pub struct TIME_R(crate::FieldReader<u16>);
        impl TIME_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                TIME_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TIME_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TIME` writer - TIME"]
        pub struct TIME_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TIME_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
                self.w
            }
        }
        #[doc = "Field `TGT` reader - TGT"]
        pub struct TGT_R(crate::FieldReader<bool>);
        impl TGT_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TGT_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TGT_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TGT` writer - TGT"]
        pub struct TGT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TGT_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `DLC` reader - DLC"]
        pub struct DLC_R(crate::FieldReader<u8>);
        impl DLC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DLC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DLC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DLC` writer - DLC"]
        pub struct DLC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DLC_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&self) -> TIME_R {
                TIME_R::new(((self.bits >> 16) & 0xffff) as u16)
            }
            #[doc = "Bit 8 - TGT"]
            #[inline(always)]
            pub fn tgt(&self) -> TGT_R {
                TGT_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&self) -> DLC_R {
                DLC_R::new((self.bits & 0x0f) as u8)
            }
        }
        impl W {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&mut self) -> TIME_W {
                TIME_W { w: self }
            }
            #[doc = "Bit 8 - TGT"]
            #[inline(always)]
            pub fn tgt(&mut self) -> TGT_W {
                TGT_W { w: self }
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&mut self) -> DLC_W {
                DLC_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDTR1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdtr1](index.html) module"]
        pub struct TXMDTR1_SPEC;
        impl crate::RegisterSpec for TXMDTR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdtr1::R](R) reader structure"]
        impl crate::Readable for TXMDTR1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdtr1::W](W) writer structure"]
        impl crate::Writable for TXMDTR1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDTR1 to value 0"]
        impl crate::Resettable for TXMDTR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDLR1 register accessor: an alias for `Reg<TXMDLR1_SPEC>`"]
    pub type TXMDLR1 = crate::Reg<txmdlr1::TXMDLR1_SPEC>;
    #[doc = "TXMDLR1"]
    pub mod txmdlr1 {
        #[doc = "Register `TXMDLR1` reader"]
        pub struct R(crate::R<TXMDLR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDLR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDLR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDLR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDLR1` writer"]
        pub struct W(crate::W<TXMDLR1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDLR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDLR1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDLR1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DATA3` reader - DATA3"]
        pub struct DATA3_R(crate::FieldReader<u8>);
        impl DATA3_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA3_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA3` writer - DATA3"]
        pub struct DATA3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA3_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
                self.w
            }
        }
        #[doc = "Field `DATA2` reader - DATA2"]
        pub struct DATA2_R(crate::FieldReader<u8>);
        impl DATA2_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA2_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA2` writer - DATA2"]
        pub struct DATA2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA2_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
                self.w
            }
        }
        #[doc = "Field `DATA1` reader - DATA1"]
        pub struct DATA1_R(crate::FieldReader<u8>);
        impl DATA1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA1` writer - DATA1"]
        pub struct DATA1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA1_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
                self.w
            }
        }
        #[doc = "Field `DATA0` reader - DATA0"]
        pub struct DATA0_R(crate::FieldReader<u8>);
        impl DATA0_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA0_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA0` writer - DATA0"]
        pub struct DATA0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA0_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&self) -> DATA3_R {
                DATA3_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&self) -> DATA2_R {
                DATA2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&self) -> DATA1_R {
                DATA1_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&self) -> DATA0_R {
                DATA0_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&mut self) -> DATA3_W {
                DATA3_W { w: self }
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&mut self) -> DATA2_W {
                DATA2_W { w: self }
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&mut self) -> DATA1_W {
                DATA1_W { w: self }
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&mut self) -> DATA0_W {
                DATA0_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDLR1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdlr1](index.html) module"]
        pub struct TXMDLR1_SPEC;
        impl crate::RegisterSpec for TXMDLR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdlr1::R](R) reader structure"]
        impl crate::Readable for TXMDLR1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdlr1::W](W) writer structure"]
        impl crate::Writable for TXMDLR1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDLR1 to value 0"]
        impl crate::Resettable for TXMDLR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDHR1 register accessor: an alias for `Reg<TXMDHR1_SPEC>`"]
    pub type TXMDHR1 = crate::Reg<txmdhr1::TXMDHR1_SPEC>;
    #[doc = "TXMDHR1"]
    pub mod txmdhr1 {
        #[doc = "Register `TXMDHR1` reader"]
        pub struct R(crate::R<TXMDHR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDHR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDHR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDHR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDHR1` writer"]
        pub struct W(crate::W<TXMDHR1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDHR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDHR1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDHR1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DATA7` reader - DATA7"]
        pub struct DATA7_R(crate::FieldReader<u8>);
        impl DATA7_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA7_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA7` writer - DATA7"]
        pub struct DATA7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA7_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
                self.w
            }
        }
        #[doc = "Field `DATA6` reader - DATA6"]
        pub struct DATA6_R(crate::FieldReader<u8>);
        impl DATA6_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA6_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA6` writer - DATA6"]
        pub struct DATA6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA6_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
                self.w
            }
        }
        #[doc = "Field `DATA5` reader - DATA5"]
        pub struct DATA5_R(crate::FieldReader<u8>);
        impl DATA5_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA5_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA5` writer - DATA5"]
        pub struct DATA5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA5_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
                self.w
            }
        }
        #[doc = "Field `DATA4` reader - DATA4"]
        pub struct DATA4_R(crate::FieldReader<u8>);
        impl DATA4_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA4_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA4` writer - DATA4"]
        pub struct DATA4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA4_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&self) -> DATA7_R {
                DATA7_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&self) -> DATA6_R {
                DATA6_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&self) -> DATA5_R {
                DATA5_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&self) -> DATA4_R {
                DATA4_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&mut self) -> DATA7_W {
                DATA7_W { w: self }
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&mut self) -> DATA6_W {
                DATA6_W { w: self }
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&mut self) -> DATA5_W {
                DATA5_W { w: self }
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&mut self) -> DATA4_W {
                DATA4_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDHR1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdhr1](index.html) module"]
        pub struct TXMDHR1_SPEC;
        impl crate::RegisterSpec for TXMDHR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdhr1::R](R) reader structure"]
        impl crate::Readable for TXMDHR1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdhr1::W](W) writer structure"]
        impl crate::Writable for TXMDHR1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDHR1 to value 0"]
        impl crate::Resettable for TXMDHR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMIR2 register accessor: an alias for `Reg<TXMIR2_SPEC>`"]
    pub type TXMIR2 = crate::Reg<txmir2::TXMIR2_SPEC>;
    #[doc = "TXMIR2"]
    pub mod txmir2 {
        #[doc = "Register `TXMIR2` reader"]
        pub struct R(crate::R<TXMIR2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMIR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMIR2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMIR2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMIR2` writer"]
        pub struct W(crate::W<TXMIR2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMIR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMIR2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMIR2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `STID` reader - STID"]
        pub struct STID_R(crate::FieldReader<u16>);
        impl STID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                STID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STID_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `STID` writer - STID"]
        pub struct STID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> STID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0x07ff << 21)) | ((value as u32 & 0x07ff) << 21);
                self.w
            }
        }
        #[doc = "Field `EXID` reader - EXID"]
        pub struct EXID_R(crate::FieldReader<u32>);
        impl EXID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u32) -> Self {
                EXID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EXID_R {
            type Target = crate::FieldReader<u32>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EXID` writer - EXID"]
        pub struct EXID_W<'a> {
            w: &'a mut W,
        }
        impl<'a> EXID_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u32) -> &'a mut W {
                self.w.bits =
                    (self.w.bits & !(0x0003_ffff << 3)) | ((value as u32 & 0x0003_ffff) << 3);
                self.w
            }
        }
        #[doc = "Field `IDE` reader - IDE"]
        pub struct IDE_R(crate::FieldReader<bool>);
        impl IDE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                IDE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for IDE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `IDE` writer - IDE"]
        pub struct IDE_W<'a> {
            w: &'a mut W,
        }
        impl<'a> IDE_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `RTR` reader - RTR"]
        pub struct RTR_R(crate::FieldReader<bool>);
        impl RTR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RTR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RTR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RTR` writer - RTR"]
        pub struct RTR_W<'a> {
            w: &'a mut W,
        }
        impl<'a> RTR_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `TXRQ` reader - TXRQ"]
        pub struct TXRQ_R(crate::FieldReader<bool>);
        impl TXRQ_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TXRQ_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TXRQ_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TXRQ` writer - TXRQ"]
        pub struct TXRQ_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TXRQ_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&self) -> STID_R {
                STID_R::new(((self.bits >> 21) & 0x07ff) as u16)
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&self) -> EXID_R {
                EXID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&self) -> IDE_R {
                IDE_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&self) -> RTR_R {
                RTR_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 0 - TXRQ"]
            #[inline(always)]
            pub fn txrq(&self) -> TXRQ_R {
                TXRQ_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&mut self) -> STID_W {
                STID_W { w: self }
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&mut self) -> EXID_W {
                EXID_W { w: self }
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&mut self) -> IDE_W {
                IDE_W { w: self }
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&mut self) -> RTR_W {
                RTR_W { w: self }
            }
            #[doc = "Bit 0 - TXRQ"]
            #[inline(always)]
            pub fn txrq(&mut self) -> TXRQ_W {
                TXRQ_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMIR2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmir2](index.html) module"]
        pub struct TXMIR2_SPEC;
        impl crate::RegisterSpec for TXMIR2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmir2::R](R) reader structure"]
        impl crate::Readable for TXMIR2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmir2::W](W) writer structure"]
        impl crate::Writable for TXMIR2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMIR2 to value 0"]
        impl crate::Resettable for TXMIR2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDTR2 register accessor: an alias for `Reg<TXMDTR2_SPEC>`"]
    pub type TXMDTR2 = crate::Reg<txmdtr2::TXMDTR2_SPEC>;
    #[doc = "TXMDTR2"]
    pub mod txmdtr2 {
        #[doc = "Register `TXMDTR2` reader"]
        pub struct R(crate::R<TXMDTR2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDTR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDTR2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDTR2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDTR2` writer"]
        pub struct W(crate::W<TXMDTR2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDTR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDTR2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDTR2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `TIME` reader - TIME"]
        pub struct TIME_R(crate::FieldReader<u16>);
        impl TIME_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                TIME_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TIME_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TIME` writer - TIME"]
        pub struct TIME_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TIME_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u16) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
                self.w
            }
        }
        #[doc = "Field `TGT` reader - TGT"]
        pub struct TGT_R(crate::FieldReader<bool>);
        impl TGT_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                TGT_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TGT_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `TGT` writer - TGT"]
        pub struct TGT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> TGT_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `DLC` reader - DLC"]
        pub struct DLC_R(crate::FieldReader<u8>);
        impl DLC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DLC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DLC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DLC` writer - DLC"]
        pub struct DLC_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DLC_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&self) -> TIME_R {
                TIME_R::new(((self.bits >> 16) & 0xffff) as u16)
            }
            #[doc = "Bit 8 - TGT"]
            #[inline(always)]
            pub fn tgt(&self) -> TGT_R {
                TGT_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&self) -> DLC_R {
                DLC_R::new((self.bits & 0x0f) as u8)
            }
        }
        impl W {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&mut self) -> TIME_W {
                TIME_W { w: self }
            }
            #[doc = "Bit 8 - TGT"]
            #[inline(always)]
            pub fn tgt(&mut self) -> TGT_W {
                TGT_W { w: self }
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&mut self) -> DLC_W {
                DLC_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDTR2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdtr2](index.html) module"]
        pub struct TXMDTR2_SPEC;
        impl crate::RegisterSpec for TXMDTR2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdtr2::R](R) reader structure"]
        impl crate::Readable for TXMDTR2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdtr2::W](W) writer structure"]
        impl crate::Writable for TXMDTR2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDTR2 to value 0"]
        impl crate::Resettable for TXMDTR2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDLR2 register accessor: an alias for `Reg<TXMDLR2_SPEC>`"]
    pub type TXMDLR2 = crate::Reg<txmdlr2::TXMDLR2_SPEC>;
    #[doc = "TXMDLR2"]
    pub mod txmdlr2 {
        #[doc = "Register `TXMDLR2` reader"]
        pub struct R(crate::R<TXMDLR2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDLR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDLR2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDLR2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDLR2` writer"]
        pub struct W(crate::W<TXMDLR2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDLR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDLR2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDLR2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DATA3` reader - DATA3"]
        pub struct DATA3_R(crate::FieldReader<u8>);
        impl DATA3_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA3_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA3` writer - DATA3"]
        pub struct DATA3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA3_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
                self.w
            }
        }
        #[doc = "Field `DATA2` reader - DATA2"]
        pub struct DATA2_R(crate::FieldReader<u8>);
        impl DATA2_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA2_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA2` writer - DATA2"]
        pub struct DATA2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA2_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
                self.w
            }
        }
        #[doc = "Field `DATA1` reader - DATA1"]
        pub struct DATA1_R(crate::FieldReader<u8>);
        impl DATA1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA1` writer - DATA1"]
        pub struct DATA1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA1_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
                self.w
            }
        }
        #[doc = "Field `DATA0` reader - DATA0"]
        pub struct DATA0_R(crate::FieldReader<u8>);
        impl DATA0_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA0_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA0` writer - DATA0"]
        pub struct DATA0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA0_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&self) -> DATA3_R {
                DATA3_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&self) -> DATA2_R {
                DATA2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&self) -> DATA1_R {
                DATA1_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&self) -> DATA0_R {
                DATA0_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&mut self) -> DATA3_W {
                DATA3_W { w: self }
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&mut self) -> DATA2_W {
                DATA2_W { w: self }
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&mut self) -> DATA1_W {
                DATA1_W { w: self }
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&mut self) -> DATA0_W {
                DATA0_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDLR2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdlr2](index.html) module"]
        pub struct TXMDLR2_SPEC;
        impl crate::RegisterSpec for TXMDLR2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdlr2::R](R) reader structure"]
        impl crate::Readable for TXMDLR2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdlr2::W](W) writer structure"]
        impl crate::Writable for TXMDLR2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDLR2 to value 0"]
        impl crate::Resettable for TXMDLR2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "TXMDHR2 register accessor: an alias for `Reg<TXMDHR2_SPEC>`"]
    pub type TXMDHR2 = crate::Reg<txmdhr2::TXMDHR2_SPEC>;
    #[doc = "TXMDHR2"]
    pub mod txmdhr2 {
        #[doc = "Register `TXMDHR2` reader"]
        pub struct R(crate::R<TXMDHR2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<TXMDHR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<TXMDHR2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<TXMDHR2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `TXMDHR2` writer"]
        pub struct W(crate::W<TXMDHR2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<TXMDHR2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<TXMDHR2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<TXMDHR2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `DATA7` reader - DATA7"]
        pub struct DATA7_R(crate::FieldReader<u8>);
        impl DATA7_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA7_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA7` writer - DATA7"]
        pub struct DATA7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA7_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
                self.w
            }
        }
        #[doc = "Field `DATA6` reader - DATA6"]
        pub struct DATA6_R(crate::FieldReader<u8>);
        impl DATA6_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA6_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA6` writer - DATA6"]
        pub struct DATA6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA6_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 16)) | ((value as u32 & 0xff) << 16);
                self.w
            }
        }
        #[doc = "Field `DATA5` reader - DATA5"]
        pub struct DATA5_R(crate::FieldReader<u8>);
        impl DATA5_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA5_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA5` writer - DATA5"]
        pub struct DATA5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA5_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !(0xff << 8)) | ((value as u32 & 0xff) << 8);
                self.w
            }
        }
        #[doc = "Field `DATA4` reader - DATA4"]
        pub struct DATA4_R(crate::FieldReader<u8>);
        impl DATA4_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA4_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA4` writer - DATA4"]
        pub struct DATA4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> DATA4_W<'a> {
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub unsafe fn bits(self, value: u8) -> &'a mut W {
                self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
                self.w
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&self) -> DATA7_R {
                DATA7_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&self) -> DATA6_R {
                DATA6_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&self) -> DATA5_R {
                DATA5_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&self) -> DATA4_R {
                DATA4_R::new((self.bits & 0xff) as u8)
            }
        }
        impl W {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&mut self) -> DATA7_W {
                DATA7_W { w: self }
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&mut self) -> DATA6_W {
                DATA6_W { w: self }
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&mut self) -> DATA5_W {
                DATA5_W { w: self }
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&mut self) -> DATA4_W {
                DATA4_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "TXMDHR2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [txmdhr2](index.html) module"]
        pub struct TXMDHR2_SPEC;
        impl crate::RegisterSpec for TXMDHR2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [txmdhr2::R](R) reader structure"]
        impl crate::Readable for TXMDHR2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [txmdhr2::W](W) writer structure"]
        impl crate::Writable for TXMDHR2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets TXMDHR2 to value 0"]
        impl crate::Resettable for TXMDHR2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMIR0 register accessor: an alias for `Reg<RXMIR0_SPEC>`"]
    pub type RXMIR0 = crate::Reg<rxmir0::RXMIR0_SPEC>;
    #[doc = "RXMIR0"]
    pub mod rxmir0 {
        #[doc = "Register `RXMIR0` reader"]
        pub struct R(crate::R<RXMIR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMIR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMIR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMIR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `STID` reader - STID"]
        pub struct STID_R(crate::FieldReader<u16>);
        impl STID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                STID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STID_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EXID` reader - EXID"]
        pub struct EXID_R(crate::FieldReader<u32>);
        impl EXID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u32) -> Self {
                EXID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EXID_R {
            type Target = crate::FieldReader<u32>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `IDE` reader - IDE"]
        pub struct IDE_R(crate::FieldReader<bool>);
        impl IDE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                IDE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for IDE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RTR` reader - RTR"]
        pub struct RTR_R(crate::FieldReader<bool>);
        impl RTR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RTR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RTR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&self) -> STID_R {
                STID_R::new(((self.bits >> 21) & 0x07ff) as u16)
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&self) -> EXID_R {
                EXID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&self) -> IDE_R {
                IDE_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&self) -> RTR_R {
                RTR_R::new(((self.bits >> 1) & 1) != 0)
            }
        }
        #[doc = "RXMIR0\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmir0](index.html) module"]
        pub struct RXMIR0_SPEC;
        impl crate::RegisterSpec for RXMIR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmir0::R](R) reader structure"]
        impl crate::Readable for RXMIR0_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMIR0 to value 0"]
        impl crate::Resettable for RXMIR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMDTR0 register accessor: an alias for `Reg<RXMDTR0_SPEC>`"]
    pub type RXMDTR0 = crate::Reg<rxmdtr0::RXMDTR0_SPEC>;
    #[doc = "RXMDTR0"]
    pub mod rxmdtr0 {
        #[doc = "Register `RXMDTR0` reader"]
        pub struct R(crate::R<RXMDTR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMDTR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMDTR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMDTR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `TIME` reader - TIME"]
        pub struct TIME_R(crate::FieldReader<u16>);
        impl TIME_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                TIME_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TIME_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FMI` reader - FMI"]
        pub struct FMI_R(crate::FieldReader<u8>);
        impl FMI_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                FMI_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FMI_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DLC` reader - DLC"]
        pub struct DLC_R(crate::FieldReader<u8>);
        impl DLC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DLC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DLC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&self) -> TIME_R {
                TIME_R::new(((self.bits >> 16) & 0xffff) as u16)
            }
            #[doc = "Bits 8:15 - FMI"]
            #[inline(always)]
            pub fn fmi(&self) -> FMI_R {
                FMI_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&self) -> DLC_R {
                DLC_R::new((self.bits & 0x0f) as u8)
            }
        }
        #[doc = "RXMDTR0\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmdtr0](index.html) module"]
        pub struct RXMDTR0_SPEC;
        impl crate::RegisterSpec for RXMDTR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmdtr0::R](R) reader structure"]
        impl crate::Readable for RXMDTR0_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMDTR0 to value 0"]
        impl crate::Resettable for RXMDTR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMDLR0 register accessor: an alias for `Reg<RXMDLR0_SPEC>`"]
    pub type RXMDLR0 = crate::Reg<rxmdlr0::RXMDLR0_SPEC>;
    #[doc = "RXMDLR0"]
    pub mod rxmdlr0 {
        #[doc = "Register `RXMDLR0` reader"]
        pub struct R(crate::R<RXMDLR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMDLR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMDLR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMDLR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `DATA3` reader - DATA3"]
        pub struct DATA3_R(crate::FieldReader<u8>);
        impl DATA3_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA3_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA2` reader - DATA2"]
        pub struct DATA2_R(crate::FieldReader<u8>);
        impl DATA2_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA2_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA1` reader - DATA1"]
        pub struct DATA1_R(crate::FieldReader<u8>);
        impl DATA1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA0` reader - DATA0"]
        pub struct DATA0_R(crate::FieldReader<u8>);
        impl DATA0_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA0_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&self) -> DATA3_R {
                DATA3_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&self) -> DATA2_R {
                DATA2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&self) -> DATA1_R {
                DATA1_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&self) -> DATA0_R {
                DATA0_R::new((self.bits & 0xff) as u8)
            }
        }
        #[doc = "RXMDLR0\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmdlr0](index.html) module"]
        pub struct RXMDLR0_SPEC;
        impl crate::RegisterSpec for RXMDLR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmdlr0::R](R) reader structure"]
        impl crate::Readable for RXMDLR0_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMDLR0 to value 0"]
        impl crate::Resettable for RXMDLR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMDHR0 register accessor: an alias for `Reg<RXMDHR0_SPEC>`"]
    pub type RXMDHR0 = crate::Reg<rxmdhr0::RXMDHR0_SPEC>;
    #[doc = "RXMDHR0"]
    pub mod rxmdhr0 {
        #[doc = "Register `RXMDHR0` reader"]
        pub struct R(crate::R<RXMDHR0_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMDHR0_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMDHR0_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMDHR0_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `DATA7` reader - DATA7"]
        pub struct DATA7_R(crate::FieldReader<u8>);
        impl DATA7_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA7_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA6` reader - DATA6"]
        pub struct DATA6_R(crate::FieldReader<u8>);
        impl DATA6_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA6_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA5` reader - DATA5"]
        pub struct DATA5_R(crate::FieldReader<u8>);
        impl DATA5_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA5_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA4` reader - DATA4"]
        pub struct DATA4_R(crate::FieldReader<u8>);
        impl DATA4_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA4_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&self) -> DATA7_R {
                DATA7_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&self) -> DATA6_R {
                DATA6_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&self) -> DATA5_R {
                DATA5_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&self) -> DATA4_R {
                DATA4_R::new((self.bits & 0xff) as u8)
            }
        }
        #[doc = "RXMDHR0\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmdhr0](index.html) module"]
        pub struct RXMDHR0_SPEC;
        impl crate::RegisterSpec for RXMDHR0_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmdhr0::R](R) reader structure"]
        impl crate::Readable for RXMDHR0_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMDHR0 to value 0"]
        impl crate::Resettable for RXMDHR0_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMIR1 register accessor: an alias for `Reg<RXMIR1_SPEC>`"]
    pub type RXMIR1 = crate::Reg<rxmir1::RXMIR1_SPEC>;
    #[doc = "RXMIR1"]
    pub mod rxmir1 {
        #[doc = "Register `RXMIR1` reader"]
        pub struct R(crate::R<RXMIR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMIR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMIR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMIR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `STID` reader - STID"]
        pub struct STID_R(crate::FieldReader<u16>);
        impl STID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                STID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for STID_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `EXID` reader - EXID"]
        pub struct EXID_R(crate::FieldReader<u32>);
        impl EXID_R {
            #[inline(always)]
            pub(crate) fn new(bits: u32) -> Self {
                EXID_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for EXID_R {
            type Target = crate::FieldReader<u32>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `IDE` reader - IDE"]
        pub struct IDE_R(crate::FieldReader<bool>);
        impl IDE_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                IDE_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for IDE_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `RTR` reader - RTR"]
        pub struct RTR_R(crate::FieldReader<bool>);
        impl RTR_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                RTR_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for RTR_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 21:31 - STID"]
            #[inline(always)]
            pub fn stid(&self) -> STID_R {
                STID_R::new(((self.bits >> 21) & 0x07ff) as u16)
            }
            #[doc = "Bits 3:20 - EXID"]
            #[inline(always)]
            pub fn exid(&self) -> EXID_R {
                EXID_R::new(((self.bits >> 3) & 0x0003_ffff) as u32)
            }
            #[doc = "Bit 2 - IDE"]
            #[inline(always)]
            pub fn ide(&self) -> IDE_R {
                IDE_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 1 - RTR"]
            #[inline(always)]
            pub fn rtr(&self) -> RTR_R {
                RTR_R::new(((self.bits >> 1) & 1) != 0)
            }
        }
        #[doc = "RXMIR1\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmir1](index.html) module"]
        pub struct RXMIR1_SPEC;
        impl crate::RegisterSpec for RXMIR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmir1::R](R) reader structure"]
        impl crate::Readable for RXMIR1_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMIR1 to value 0"]
        impl crate::Resettable for RXMIR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMDTR1 register accessor: an alias for `Reg<RXMDTR1_SPEC>`"]
    pub type RXMDTR1 = crate::Reg<rxmdtr1::RXMDTR1_SPEC>;
    #[doc = "RXMDTR1"]
    pub mod rxmdtr1 {
        #[doc = "Register `RXMDTR1` reader"]
        pub struct R(crate::R<RXMDTR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMDTR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMDTR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMDTR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `TIME` reader - TIME"]
        pub struct TIME_R(crate::FieldReader<u16>);
        impl TIME_R {
            #[inline(always)]
            pub(crate) fn new(bits: u16) -> Self {
                TIME_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for TIME_R {
            type Target = crate::FieldReader<u16>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FMI` reader - FMI"]
        pub struct FMI_R(crate::FieldReader<u8>);
        impl FMI_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                FMI_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FMI_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DLC` reader - DLC"]
        pub struct DLC_R(crate::FieldReader<u8>);
        impl DLC_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DLC_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DLC_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 16:31 - TIME"]
            #[inline(always)]
            pub fn time(&self) -> TIME_R {
                TIME_R::new(((self.bits >> 16) & 0xffff) as u16)
            }
            #[doc = "Bits 8:15 - FMI"]
            #[inline(always)]
            pub fn fmi(&self) -> FMI_R {
                FMI_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:3 - DLC"]
            #[inline(always)]
            pub fn dlc(&self) -> DLC_R {
                DLC_R::new((self.bits & 0x0f) as u8)
            }
        }
        #[doc = "RXMDTR1\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmdtr1](index.html) module"]
        pub struct RXMDTR1_SPEC;
        impl crate::RegisterSpec for RXMDTR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmdtr1::R](R) reader structure"]
        impl crate::Readable for RXMDTR1_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMDTR1 to value 0"]
        impl crate::Resettable for RXMDTR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMDLR1 register accessor: an alias for `Reg<RXMDLR1_SPEC>`"]
    pub type RXMDLR1 = crate::Reg<rxmdlr1::RXMDLR1_SPEC>;
    #[doc = "RXMDLR1"]
    pub mod rxmdlr1 {
        #[doc = "Register `RXMDLR1` reader"]
        pub struct R(crate::R<RXMDLR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMDLR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMDLR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMDLR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `DATA3` reader - DATA3"]
        pub struct DATA3_R(crate::FieldReader<u8>);
        impl DATA3_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA3_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA2` reader - DATA2"]
        pub struct DATA2_R(crate::FieldReader<u8>);
        impl DATA2_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA2_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA1` reader - DATA1"]
        pub struct DATA1_R(crate::FieldReader<u8>);
        impl DATA1_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA1_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA0` reader - DATA0"]
        pub struct DATA0_R(crate::FieldReader<u8>);
        impl DATA0_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA0_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA3"]
            #[inline(always)]
            pub fn data3(&self) -> DATA3_R {
                DATA3_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA2"]
            #[inline(always)]
            pub fn data2(&self) -> DATA2_R {
                DATA2_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA1"]
            #[inline(always)]
            pub fn data1(&self) -> DATA1_R {
                DATA1_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA0"]
            #[inline(always)]
            pub fn data0(&self) -> DATA0_R {
                DATA0_R::new((self.bits & 0xff) as u8)
            }
        }
        #[doc = "RXMDLR1\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmdlr1](index.html) module"]
        pub struct RXMDLR1_SPEC;
        impl crate::RegisterSpec for RXMDLR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmdlr1::R](R) reader structure"]
        impl crate::Readable for RXMDLR1_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMDLR1 to value 0"]
        impl crate::Resettable for RXMDLR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "RXMDHR1 register accessor: an alias for `Reg<RXMDHR1_SPEC>`"]
    pub type RXMDHR1 = crate::Reg<rxmdhr1::RXMDHR1_SPEC>;
    #[doc = "RXMDHR1"]
    pub mod rxmdhr1 {
        #[doc = "Register `RXMDHR1` reader"]
        pub struct R(crate::R<RXMDHR1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<RXMDHR1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<RXMDHR1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<RXMDHR1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Field `DATA7` reader - DATA7"]
        pub struct DATA7_R(crate::FieldReader<u8>);
        impl DATA7_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA7_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA6` reader - DATA6"]
        pub struct DATA6_R(crate::FieldReader<u8>);
        impl DATA6_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA6_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA5` reader - DATA5"]
        pub struct DATA5_R(crate::FieldReader<u8>);
        impl DATA5_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA5_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `DATA4` reader - DATA4"]
        pub struct DATA4_R(crate::FieldReader<u8>);
        impl DATA4_R {
            #[inline(always)]
            pub(crate) fn new(bits: u8) -> Self {
                DATA4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for DATA4_R {
            type Target = crate::FieldReader<u8>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl R {
            #[doc = "Bits 24:31 - DATA7"]
            #[inline(always)]
            pub fn data7(&self) -> DATA7_R {
                DATA7_R::new(((self.bits >> 24) & 0xff) as u8)
            }
            #[doc = "Bits 16:23 - DATA6"]
            #[inline(always)]
            pub fn data6(&self) -> DATA6_R {
                DATA6_R::new(((self.bits >> 16) & 0xff) as u8)
            }
            #[doc = "Bits 8:15 - DATA5"]
            #[inline(always)]
            pub fn data5(&self) -> DATA5_R {
                DATA5_R::new(((self.bits >> 8) & 0xff) as u8)
            }
            #[doc = "Bits 0:7 - DATA4"]
            #[inline(always)]
            pub fn data4(&self) -> DATA4_R {
                DATA4_R::new((self.bits & 0xff) as u8)
            }
        }
        #[doc = "RXMDHR1\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rxmdhr1](index.html) module"]
        pub struct RXMDHR1_SPEC;
        impl crate::RegisterSpec for RXMDHR1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [rxmdhr1::R](R) reader structure"]
        impl crate::Readable for RXMDHR1_SPEC {
            type Reader = R;
        }
        #[doc = "`reset()` method sets RXMDHR1 to value 0"]
        impl crate::Resettable for RXMDHR1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "FCTLR register accessor: an alias for `Reg<FCTLR_SPEC>`"]
    pub type FCTLR = crate::Reg<fctlr::FCTLR_SPEC>;
    #[doc = "FCTLR"]
    pub mod fctlr {
        #[doc = "Register `FCTLR` reader"]
        pub struct R(crate::R<FCTLR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<FCTLR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<FCTLR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<FCTLR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `FCTLR` writer"]
        pub struct W(crate::W<FCTLR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<FCTLR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<FCTLR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<FCTLR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FINIT` reader - FINIT"]
        pub struct FINIT_R(crate::FieldReader<bool>);
        impl FINIT_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FINIT_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FINIT_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FINIT` writer - FINIT"]
        pub struct FINIT_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FINIT_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - FINIT"]
            #[inline(always)]
            pub fn finit(&self) -> FINIT_R {
                FINIT_R::new((self.bits & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - FINIT"]
            #[inline(always)]
            pub fn finit(&mut self) -> FINIT_W {
                FINIT_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "FCTLR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fctlr](index.html) module"]
        pub struct FCTLR_SPEC;
        impl crate::RegisterSpec for FCTLR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [fctlr::R](R) reader structure"]
        impl crate::Readable for FCTLR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [fctlr::W](W) writer structure"]
        impl crate::Writable for FCTLR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets FCTLR to value 0"]
        impl crate::Resettable for FCTLR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "FMCFGR register accessor: an alias for `Reg<FMCFGR_SPEC>`"]
    pub type FMCFGR = crate::Reg<fmcfgr::FMCFGR_SPEC>;
    #[doc = "FMCFGR"]
    pub mod fmcfgr {
        #[doc = "Register `FMCFGR` reader"]
        pub struct R(crate::R<FMCFGR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<FMCFGR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<FMCFGR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<FMCFGR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `FMCFGR` writer"]
        pub struct W(crate::W<FMCFGR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<FMCFGR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<FMCFGR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<FMCFGR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FBM0` reader - Filter mode"]
        pub struct FBM0_R(crate::FieldReader<bool>);
        impl FBM0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM0` writer - Filter mode"]
        pub struct FBM0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FBM1` reader - Filter mode"]
        pub struct FBM1_R(crate::FieldReader<bool>);
        impl FBM1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM1` writer - Filter mode"]
        pub struct FBM1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FBM2` reader - Filter mode"]
        pub struct FBM2_R(crate::FieldReader<bool>);
        impl FBM2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM2` writer - Filter mode"]
        pub struct FBM2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FBM3` reader - Filter mode"]
        pub struct FBM3_R(crate::FieldReader<bool>);
        impl FBM3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM3` writer - Filter mode"]
        pub struct FBM3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FBM4` reader - Filter mode"]
        pub struct FBM4_R(crate::FieldReader<bool>);
        impl FBM4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM4` writer - Filter mode"]
        pub struct FBM4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FBM5` reader - Filter mode"]
        pub struct FBM5_R(crate::FieldReader<bool>);
        impl FBM5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM5` writer - Filter mode"]
        pub struct FBM5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FBM6` reader - Filter mode"]
        pub struct FBM6_R(crate::FieldReader<bool>);
        impl FBM6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM6` writer - Filter mode"]
        pub struct FBM6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FBM7` reader - Filter mode"]
        pub struct FBM7_R(crate::FieldReader<bool>);
        impl FBM7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM7` writer - Filter mode"]
        pub struct FBM7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FBM8` reader - Filter mode"]
        pub struct FBM8_R(crate::FieldReader<bool>);
        impl FBM8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM8` writer - Filter mode"]
        pub struct FBM8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FBM9` reader - Filter mode"]
        pub struct FBM9_R(crate::FieldReader<bool>);
        impl FBM9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM9` writer - Filter mode"]
        pub struct FBM9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FBM10` reader - Filter mode"]
        pub struct FBM10_R(crate::FieldReader<bool>);
        impl FBM10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM10` writer - Filter mode"]
        pub struct FBM10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FBM11` reader - Filter mode"]
        pub struct FBM11_R(crate::FieldReader<bool>);
        impl FBM11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM11` writer - Filter mode"]
        pub struct FBM11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FBM12` reader - Filter mode"]
        pub struct FBM12_R(crate::FieldReader<bool>);
        impl FBM12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM12` writer - Filter mode"]
        pub struct FBM12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FBM13` reader - Filter mode"]
        pub struct FBM13_R(crate::FieldReader<bool>);
        impl FBM13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FBM13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FBM13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FBM13` writer - Filter mode"]
        pub struct FBM13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FBM13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter mode"]
            #[inline(always)]
            pub fn fbm0(&self) -> FBM0_R {
                FBM0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter mode"]
            #[inline(always)]
            pub fn fbm1(&self) -> FBM1_R {
                FBM1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter mode"]
            #[inline(always)]
            pub fn fbm2(&self) -> FBM2_R {
                FBM2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter mode"]
            #[inline(always)]
            pub fn fbm3(&self) -> FBM3_R {
                FBM3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter mode"]
            #[inline(always)]
            pub fn fbm4(&self) -> FBM4_R {
                FBM4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter mode"]
            #[inline(always)]
            pub fn fbm5(&self) -> FBM5_R {
                FBM5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter mode"]
            #[inline(always)]
            pub fn fbm6(&self) -> FBM6_R {
                FBM6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter mode"]
            #[inline(always)]
            pub fn fbm7(&self) -> FBM7_R {
                FBM7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter mode"]
            #[inline(always)]
            pub fn fbm8(&self) -> FBM8_R {
                FBM8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter mode"]
            #[inline(always)]
            pub fn fbm9(&self) -> FBM9_R {
                FBM9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter mode"]
            #[inline(always)]
            pub fn fbm10(&self) -> FBM10_R {
                FBM10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter mode"]
            #[inline(always)]
            pub fn fbm11(&self) -> FBM11_R {
                FBM11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter mode"]
            #[inline(always)]
            pub fn fbm12(&self) -> FBM12_R {
                FBM12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter mode"]
            #[inline(always)]
            pub fn fbm13(&self) -> FBM13_R {
                FBM13_R::new(((self.bits >> 13) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter mode"]
            #[inline(always)]
            pub fn fbm0(&mut self) -> FBM0_W {
                FBM0_W { w: self }
            }
            #[doc = "Bit 1 - Filter mode"]
            #[inline(always)]
            pub fn fbm1(&mut self) -> FBM1_W {
                FBM1_W { w: self }
            }
            #[doc = "Bit 2 - Filter mode"]
            #[inline(always)]
            pub fn fbm2(&mut self) -> FBM2_W {
                FBM2_W { w: self }
            }
            #[doc = "Bit 3 - Filter mode"]
            #[inline(always)]
            pub fn fbm3(&mut self) -> FBM3_W {
                FBM3_W { w: self }
            }
            #[doc = "Bit 4 - Filter mode"]
            #[inline(always)]
            pub fn fbm4(&mut self) -> FBM4_W {
                FBM4_W { w: self }
            }
            #[doc = "Bit 5 - Filter mode"]
            #[inline(always)]
            pub fn fbm5(&mut self) -> FBM5_W {
                FBM5_W { w: self }
            }
            #[doc = "Bit 6 - Filter mode"]
            #[inline(always)]
            pub fn fbm6(&mut self) -> FBM6_W {
                FBM6_W { w: self }
            }
            #[doc = "Bit 7 - Filter mode"]
            #[inline(always)]
            pub fn fbm7(&mut self) -> FBM7_W {
                FBM7_W { w: self }
            }
            #[doc = "Bit 8 - Filter mode"]
            #[inline(always)]
            pub fn fbm8(&mut self) -> FBM8_W {
                FBM8_W { w: self }
            }
            #[doc = "Bit 9 - Filter mode"]
            #[inline(always)]
            pub fn fbm9(&mut self) -> FBM9_W {
                FBM9_W { w: self }
            }
            #[doc = "Bit 10 - Filter mode"]
            #[inline(always)]
            pub fn fbm10(&mut self) -> FBM10_W {
                FBM10_W { w: self }
            }
            #[doc = "Bit 11 - Filter mode"]
            #[inline(always)]
            pub fn fbm11(&mut self) -> FBM11_W {
                FBM11_W { w: self }
            }
            #[doc = "Bit 12 - Filter mode"]
            #[inline(always)]
            pub fn fbm12(&mut self) -> FBM12_W {
                FBM12_W { w: self }
            }
            #[doc = "Bit 13 - Filter mode"]
            #[inline(always)]
            pub fn fbm13(&mut self) -> FBM13_W {
                FBM13_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "FMCFGR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fmcfgr](index.html) module"]
        pub struct FMCFGR_SPEC;
        impl crate::RegisterSpec for FMCFGR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [fmcfgr::R](R) reader structure"]
        impl crate::Readable for FMCFGR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [fmcfgr::W](W) writer structure"]
        impl crate::Writable for FMCFGR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets FMCFGR to value 0"]
        impl crate::Resettable for FMCFGR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "FSCFGR register accessor: an alias for `Reg<FSCFGR_SPEC>`"]
    pub type FSCFGR = crate::Reg<fscfgr::FSCFGR_SPEC>;
    #[doc = "FSCFGR"]
    pub mod fscfgr {
        #[doc = "Register `FSCFGR` reader"]
        pub struct R(crate::R<FSCFGR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<FSCFGR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<FSCFGR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<FSCFGR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `FSCFGR` writer"]
        pub struct W(crate::W<FSCFGR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<FSCFGR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<FSCFGR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<FSCFGR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FSC0` reader - Filter scale configuration"]
        pub struct FSC0_R(crate::FieldReader<bool>);
        impl FSC0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC0` writer - Filter scale configuration"]
        pub struct FSC0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FSC1` reader - Filter scale configuration"]
        pub struct FSC1_R(crate::FieldReader<bool>);
        impl FSC1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC1` writer - Filter scale configuration"]
        pub struct FSC1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FSC2` reader - Filter scale configuration"]
        pub struct FSC2_R(crate::FieldReader<bool>);
        impl FSC2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC2` writer - Filter scale configuration"]
        pub struct FSC2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FSC3` reader - Filter scale configuration"]
        pub struct FSC3_R(crate::FieldReader<bool>);
        impl FSC3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC3` writer - Filter scale configuration"]
        pub struct FSC3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FSC4` reader - Filter scale configuration"]
        pub struct FSC4_R(crate::FieldReader<bool>);
        impl FSC4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC4` writer - Filter scale configuration"]
        pub struct FSC4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FSC5` reader - Filter scale configuration"]
        pub struct FSC5_R(crate::FieldReader<bool>);
        impl FSC5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC5` writer - Filter scale configuration"]
        pub struct FSC5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FSC6` reader - Filter scale configuration"]
        pub struct FSC6_R(crate::FieldReader<bool>);
        impl FSC6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC6` writer - Filter scale configuration"]
        pub struct FSC6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FSC7` reader - Filter scale configuration"]
        pub struct FSC7_R(crate::FieldReader<bool>);
        impl FSC7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC7` writer - Filter scale configuration"]
        pub struct FSC7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FSC8` reader - Filter scale configuration"]
        pub struct FSC8_R(crate::FieldReader<bool>);
        impl FSC8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC8` writer - Filter scale configuration"]
        pub struct FSC8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FSC9` reader - Filter scale configuration"]
        pub struct FSC9_R(crate::FieldReader<bool>);
        impl FSC9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC9` writer - Filter scale configuration"]
        pub struct FSC9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FSC10` reader - Filter scale configuration"]
        pub struct FSC10_R(crate::FieldReader<bool>);
        impl FSC10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC10` writer - Filter scale configuration"]
        pub struct FSC10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FSC11` reader - Filter scale configuration"]
        pub struct FSC11_R(crate::FieldReader<bool>);
        impl FSC11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC11` writer - Filter scale configuration"]
        pub struct FSC11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FSC12` reader - Filter scale configuration"]
        pub struct FSC12_R(crate::FieldReader<bool>);
        impl FSC12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC12` writer - Filter scale configuration"]
        pub struct FSC12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FSC13` reader - Filter scale configuration"]
        pub struct FSC13_R(crate::FieldReader<bool>);
        impl FSC13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FSC13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FSC13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FSC13` writer - Filter scale configuration"]
        pub struct FSC13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FSC13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc0(&self) -> FSC0_R {
                FSC0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc1(&self) -> FSC1_R {
                FSC1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc2(&self) -> FSC2_R {
                FSC2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc3(&self) -> FSC3_R {
                FSC3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc4(&self) -> FSC4_R {
                FSC4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc5(&self) -> FSC5_R {
                FSC5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc6(&self) -> FSC6_R {
                FSC6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc7(&self) -> FSC7_R {
                FSC7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc8(&self) -> FSC8_R {
                FSC8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc9(&self) -> FSC9_R {
                FSC9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc10(&self) -> FSC10_R {
                FSC10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc11(&self) -> FSC11_R {
                FSC11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc12(&self) -> FSC12_R {
                FSC12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc13(&self) -> FSC13_R {
                FSC13_R::new(((self.bits >> 13) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc0(&mut self) -> FSC0_W {
                FSC0_W { w: self }
            }
            #[doc = "Bit 1 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc1(&mut self) -> FSC1_W {
                FSC1_W { w: self }
            }
            #[doc = "Bit 2 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc2(&mut self) -> FSC2_W {
                FSC2_W { w: self }
            }
            #[doc = "Bit 3 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc3(&mut self) -> FSC3_W {
                FSC3_W { w: self }
            }
            #[doc = "Bit 4 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc4(&mut self) -> FSC4_W {
                FSC4_W { w: self }
            }
            #[doc = "Bit 5 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc5(&mut self) -> FSC5_W {
                FSC5_W { w: self }
            }
            #[doc = "Bit 6 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc6(&mut self) -> FSC6_W {
                FSC6_W { w: self }
            }
            #[doc = "Bit 7 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc7(&mut self) -> FSC7_W {
                FSC7_W { w: self }
            }
            #[doc = "Bit 8 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc8(&mut self) -> FSC8_W {
                FSC8_W { w: self }
            }
            #[doc = "Bit 9 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc9(&mut self) -> FSC9_W {
                FSC9_W { w: self }
            }
            #[doc = "Bit 10 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc10(&mut self) -> FSC10_W {
                FSC10_W { w: self }
            }
            #[doc = "Bit 11 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc11(&mut self) -> FSC11_W {
                FSC11_W { w: self }
            }
            #[doc = "Bit 12 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc12(&mut self) -> FSC12_W {
                FSC12_W { w: self }
            }
            #[doc = "Bit 13 - Filter scale configuration"]
            #[inline(always)]
            pub fn fsc13(&mut self) -> FSC13_W {
                FSC13_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "FSCFGR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fscfgr](index.html) module"]
        pub struct FSCFGR_SPEC;
        impl crate::RegisterSpec for FSCFGR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [fscfgr::R](R) reader structure"]
        impl crate::Readable for FSCFGR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [fscfgr::W](W) writer structure"]
        impl crate::Writable for FSCFGR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets FSCFGR to value 0"]
        impl crate::Resettable for FSCFGR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "FAFIFOR register accessor: an alias for `Reg<FAFIFOR_SPEC>`"]
    pub type FAFIFOR = crate::Reg<fafifor::FAFIFOR_SPEC>;
    #[doc = "FAFIFOR"]
    pub mod fafifor {
        #[doc = "Register `FAFIFOR` reader"]
        pub struct R(crate::R<FAFIFOR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<FAFIFOR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<FAFIFOR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<FAFIFOR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `FAFIFOR` writer"]
        pub struct W(crate::W<FAFIFOR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<FAFIFOR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<FAFIFOR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<FAFIFOR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FFA0` reader - Filter FIFO assignment for filter 0"]
        pub struct FFA0_R(crate::FieldReader<bool>);
        impl FFA0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA0` writer - Filter FIFO assignment for filter 0"]
        pub struct FFA0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FFA1` reader - Filter FIFO assignment for filter 1"]
        pub struct FFA1_R(crate::FieldReader<bool>);
        impl FFA1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA1` writer - Filter FIFO assignment for filter 1"]
        pub struct FFA1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FFA2` reader - Filter FIFO assignment for filter 2"]
        pub struct FFA2_R(crate::FieldReader<bool>);
        impl FFA2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA2` writer - Filter FIFO assignment for filter 2"]
        pub struct FFA2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FFA3` reader - Filter FIFO assignment for filter 3"]
        pub struct FFA3_R(crate::FieldReader<bool>);
        impl FFA3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA3` writer - Filter FIFO assignment for filter 3"]
        pub struct FFA3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FFA4` reader - Filter FIFO assignment for filter 4"]
        pub struct FFA4_R(crate::FieldReader<bool>);
        impl FFA4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA4` writer - Filter FIFO assignment for filter 4"]
        pub struct FFA4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FFA5` reader - Filter FIFO assignment for filter 5"]
        pub struct FFA5_R(crate::FieldReader<bool>);
        impl FFA5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA5` writer - Filter FIFO assignment for filter 5"]
        pub struct FFA5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FFA6` reader - Filter FIFO assignment for filter 6"]
        pub struct FFA6_R(crate::FieldReader<bool>);
        impl FFA6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA6` writer - Filter FIFO assignment for filter 6"]
        pub struct FFA6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FFA7` reader - Filter FIFO assignment for filter 7"]
        pub struct FFA7_R(crate::FieldReader<bool>);
        impl FFA7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA7` writer - Filter FIFO assignment for filter 7"]
        pub struct FFA7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FFA8` reader - Filter FIFO assignment for filter 8"]
        pub struct FFA8_R(crate::FieldReader<bool>);
        impl FFA8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA8` writer - Filter FIFO assignment for filter 8"]
        pub struct FFA8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FFA9` reader - Filter FIFO assignment for filter 9"]
        pub struct FFA9_R(crate::FieldReader<bool>);
        impl FFA9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA9` writer - Filter FIFO assignment for filter 9"]
        pub struct FFA9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FFA10` reader - Filter FIFO assignment for filter 10"]
        pub struct FFA10_R(crate::FieldReader<bool>);
        impl FFA10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA10` writer - Filter FIFO assignment for filter 10"]
        pub struct FFA10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FFA11` reader - Filter FIFO assignment for filter 11"]
        pub struct FFA11_R(crate::FieldReader<bool>);
        impl FFA11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA11` writer - Filter FIFO assignment for filter 11"]
        pub struct FFA11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FFA12` reader - Filter FIFO assignment for filter 12"]
        pub struct FFA12_R(crate::FieldReader<bool>);
        impl FFA12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA12` writer - Filter FIFO assignment for filter 12"]
        pub struct FFA12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FFA13` reader - Filter FIFO assignment for filter 13"]
        pub struct FFA13_R(crate::FieldReader<bool>);
        impl FFA13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FFA13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FFA13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FFA13` writer - Filter FIFO assignment for filter 13"]
        pub struct FFA13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FFA13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter FIFO assignment for filter 0"]
            #[inline(always)]
            pub fn ffa0(&self) -> FFA0_R {
                FFA0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter FIFO assignment for filter 1"]
            #[inline(always)]
            pub fn ffa1(&self) -> FFA1_R {
                FFA1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter FIFO assignment for filter 2"]
            #[inline(always)]
            pub fn ffa2(&self) -> FFA2_R {
                FFA2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter FIFO assignment for filter 3"]
            #[inline(always)]
            pub fn ffa3(&self) -> FFA3_R {
                FFA3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter FIFO assignment for filter 4"]
            #[inline(always)]
            pub fn ffa4(&self) -> FFA4_R {
                FFA4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter FIFO assignment for filter 5"]
            #[inline(always)]
            pub fn ffa5(&self) -> FFA5_R {
                FFA5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter FIFO assignment for filter 6"]
            #[inline(always)]
            pub fn ffa6(&self) -> FFA6_R {
                FFA6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter FIFO assignment for filter 7"]
            #[inline(always)]
            pub fn ffa7(&self) -> FFA7_R {
                FFA7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter FIFO assignment for filter 8"]
            #[inline(always)]
            pub fn ffa8(&self) -> FFA8_R {
                FFA8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter FIFO assignment for filter 9"]
            #[inline(always)]
            pub fn ffa9(&self) -> FFA9_R {
                FFA9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter FIFO assignment for filter 10"]
            #[inline(always)]
            pub fn ffa10(&self) -> FFA10_R {
                FFA10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter FIFO assignment for filter 11"]
            #[inline(always)]
            pub fn ffa11(&self) -> FFA11_R {
                FFA11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter FIFO assignment for filter 12"]
            #[inline(always)]
            pub fn ffa12(&self) -> FFA12_R {
                FFA12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter FIFO assignment for filter 13"]
            #[inline(always)]
            pub fn ffa13(&self) -> FFA13_R {
                FFA13_R::new(((self.bits >> 13) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter FIFO assignment for filter 0"]
            #[inline(always)]
            pub fn ffa0(&mut self) -> FFA0_W {
                FFA0_W { w: self }
            }
            #[doc = "Bit 1 - Filter FIFO assignment for filter 1"]
            #[inline(always)]
            pub fn ffa1(&mut self) -> FFA1_W {
                FFA1_W { w: self }
            }
            #[doc = "Bit 2 - Filter FIFO assignment for filter 2"]
            #[inline(always)]
            pub fn ffa2(&mut self) -> FFA2_W {
                FFA2_W { w: self }
            }
            #[doc = "Bit 3 - Filter FIFO assignment for filter 3"]
            #[inline(always)]
            pub fn ffa3(&mut self) -> FFA3_W {
                FFA3_W { w: self }
            }
            #[doc = "Bit 4 - Filter FIFO assignment for filter 4"]
            #[inline(always)]
            pub fn ffa4(&mut self) -> FFA4_W {
                FFA4_W { w: self }
            }
            #[doc = "Bit 5 - Filter FIFO assignment for filter 5"]
            #[inline(always)]
            pub fn ffa5(&mut self) -> FFA5_W {
                FFA5_W { w: self }
            }
            #[doc = "Bit 6 - Filter FIFO assignment for filter 6"]
            #[inline(always)]
            pub fn ffa6(&mut self) -> FFA6_W {
                FFA6_W { w: self }
            }
            #[doc = "Bit 7 - Filter FIFO assignment for filter 7"]
            #[inline(always)]
            pub fn ffa7(&mut self) -> FFA7_W {
                FFA7_W { w: self }
            }
            #[doc = "Bit 8 - Filter FIFO assignment for filter 8"]
            #[inline(always)]
            pub fn ffa8(&mut self) -> FFA8_W {
                FFA8_W { w: self }
            }
            #[doc = "Bit 9 - Filter FIFO assignment for filter 9"]
            #[inline(always)]
            pub fn ffa9(&mut self) -> FFA9_W {
                FFA9_W { w: self }
            }
            #[doc = "Bit 10 - Filter FIFO assignment for filter 10"]
            #[inline(always)]
            pub fn ffa10(&mut self) -> FFA10_W {
                FFA10_W { w: self }
            }
            #[doc = "Bit 11 - Filter FIFO assignment for filter 11"]
            #[inline(always)]
            pub fn ffa11(&mut self) -> FFA11_W {
                FFA11_W { w: self }
            }
            #[doc = "Bit 12 - Filter FIFO assignment for filter 12"]
            #[inline(always)]
            pub fn ffa12(&mut self) -> FFA12_W {
                FFA12_W { w: self }
            }
            #[doc = "Bit 13 - Filter FIFO assignment for filter 13"]
            #[inline(always)]
            pub fn ffa13(&mut self) -> FFA13_W {
                FFA13_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "FAFIFOR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fafifor](index.html) module"]
        pub struct FAFIFOR_SPEC;
        impl crate::RegisterSpec for FAFIFOR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [fafifor::R](R) reader structure"]
        impl crate::Readable for FAFIFOR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [fafifor::W](W) writer structure"]
        impl crate::Writable for FAFIFOR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets FAFIFOR to value 0"]
        impl crate::Resettable for FAFIFOR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "FWR register accessor: an alias for `Reg<FWR_SPEC>`"]
    pub type FWR = crate::Reg<fwr::FWR_SPEC>;
    #[doc = "FWR"]
    pub mod fwr {
        #[doc = "Register `FWR` reader"]
        pub struct R(crate::R<FWR_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<FWR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<FWR_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<FWR_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `FWR` writer"]
        pub struct W(crate::W<FWR_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<FWR_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<FWR_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<FWR_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FACT0` reader - Filter active"]
        pub struct FACT0_R(crate::FieldReader<bool>);
        impl FACT0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT0` writer - Filter active"]
        pub struct FACT0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FACT1` reader - Filter active"]
        pub struct FACT1_R(crate::FieldReader<bool>);
        impl FACT1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT1` writer - Filter active"]
        pub struct FACT1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FACT2` reader - Filter active"]
        pub struct FACT2_R(crate::FieldReader<bool>);
        impl FACT2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT2` writer - Filter active"]
        pub struct FACT2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FACT3` reader - Filter active"]
        pub struct FACT3_R(crate::FieldReader<bool>);
        impl FACT3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT3` writer - Filter active"]
        pub struct FACT3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FACT4` reader - Filter active"]
        pub struct FACT4_R(crate::FieldReader<bool>);
        impl FACT4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT4` writer - Filter active"]
        pub struct FACT4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FACT5` reader - Filter active"]
        pub struct FACT5_R(crate::FieldReader<bool>);
        impl FACT5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT5` writer - Filter active"]
        pub struct FACT5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FACT6` reader - Filter active"]
        pub struct FACT6_R(crate::FieldReader<bool>);
        impl FACT6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT6` writer - Filter active"]
        pub struct FACT6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FACT7` reader - Filter active"]
        pub struct FACT7_R(crate::FieldReader<bool>);
        impl FACT7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT7` writer - Filter active"]
        pub struct FACT7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FACT8` reader - Filter active"]
        pub struct FACT8_R(crate::FieldReader<bool>);
        impl FACT8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT8` writer - Filter active"]
        pub struct FACT8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FACT9` reader - Filter active"]
        pub struct FACT9_R(crate::FieldReader<bool>);
        impl FACT9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT9` writer - Filter active"]
        pub struct FACT9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FACT10` reader - Filter active"]
        pub struct FACT10_R(crate::FieldReader<bool>);
        impl FACT10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT10` writer - Filter active"]
        pub struct FACT10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FACT11` reader - Filter active"]
        pub struct FACT11_R(crate::FieldReader<bool>);
        impl FACT11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT11` writer - Filter active"]
        pub struct FACT11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FACT12` reader - Filter active"]
        pub struct FACT12_R(crate::FieldReader<bool>);
        impl FACT12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT12` writer - Filter active"]
        pub struct FACT12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FACT13` reader - Filter active"]
        pub struct FACT13_R(crate::FieldReader<bool>);
        impl FACT13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FACT13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FACT13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FACT13` writer - Filter active"]
        pub struct FACT13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FACT13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter active"]
            #[inline(always)]
            pub fn fact0(&self) -> FACT0_R {
                FACT0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter active"]
            #[inline(always)]
            pub fn fact1(&self) -> FACT1_R {
                FACT1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter active"]
            #[inline(always)]
            pub fn fact2(&self) -> FACT2_R {
                FACT2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter active"]
            #[inline(always)]
            pub fn fact3(&self) -> FACT3_R {
                FACT3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter active"]
            #[inline(always)]
            pub fn fact4(&self) -> FACT4_R {
                FACT4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter active"]
            #[inline(always)]
            pub fn fact5(&self) -> FACT5_R {
                FACT5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter active"]
            #[inline(always)]
            pub fn fact6(&self) -> FACT6_R {
                FACT6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter active"]
            #[inline(always)]
            pub fn fact7(&self) -> FACT7_R {
                FACT7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter active"]
            #[inline(always)]
            pub fn fact8(&self) -> FACT8_R {
                FACT8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter active"]
            #[inline(always)]
            pub fn fact9(&self) -> FACT9_R {
                FACT9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter active"]
            #[inline(always)]
            pub fn fact10(&self) -> FACT10_R {
                FACT10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter active"]
            #[inline(always)]
            pub fn fact11(&self) -> FACT11_R {
                FACT11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter active"]
            #[inline(always)]
            pub fn fact12(&self) -> FACT12_R {
                FACT12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter active"]
            #[inline(always)]
            pub fn fact13(&self) -> FACT13_R {
                FACT13_R::new(((self.bits >> 13) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter active"]
            #[inline(always)]
            pub fn fact0(&mut self) -> FACT0_W {
                FACT0_W { w: self }
            }
            #[doc = "Bit 1 - Filter active"]
            #[inline(always)]
            pub fn fact1(&mut self) -> FACT1_W {
                FACT1_W { w: self }
            }
            #[doc = "Bit 2 - Filter active"]
            #[inline(always)]
            pub fn fact2(&mut self) -> FACT2_W {
                FACT2_W { w: self }
            }
            #[doc = "Bit 3 - Filter active"]
            #[inline(always)]
            pub fn fact3(&mut self) -> FACT3_W {
                FACT3_W { w: self }
            }
            #[doc = "Bit 4 - Filter active"]
            #[inline(always)]
            pub fn fact4(&mut self) -> FACT4_W {
                FACT4_W { w: self }
            }
            #[doc = "Bit 5 - Filter active"]
            #[inline(always)]
            pub fn fact5(&mut self) -> FACT5_W {
                FACT5_W { w: self }
            }
            #[doc = "Bit 6 - Filter active"]
            #[inline(always)]
            pub fn fact6(&mut self) -> FACT6_W {
                FACT6_W { w: self }
            }
            #[doc = "Bit 7 - Filter active"]
            #[inline(always)]
            pub fn fact7(&mut self) -> FACT7_W {
                FACT7_W { w: self }
            }
            #[doc = "Bit 8 - Filter active"]
            #[inline(always)]
            pub fn fact8(&mut self) -> FACT8_W {
                FACT8_W { w: self }
            }
            #[doc = "Bit 9 - Filter active"]
            #[inline(always)]
            pub fn fact9(&mut self) -> FACT9_W {
                FACT9_W { w: self }
            }
            #[doc = "Bit 10 - Filter active"]
            #[inline(always)]
            pub fn fact10(&mut self) -> FACT10_W {
                FACT10_W { w: self }
            }
            #[doc = "Bit 11 - Filter active"]
            #[inline(always)]
            pub fn fact11(&mut self) -> FACT11_W {
                FACT11_W { w: self }
            }
            #[doc = "Bit 12 - Filter active"]
            #[inline(always)]
            pub fn fact12(&mut self) -> FACT12_W {
                FACT12_W { w: self }
            }
            #[doc = "Bit 13 - Filter active"]
            #[inline(always)]
            pub fn fact13(&mut self) -> FACT13_W {
                FACT13_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "FWR\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fwr](index.html) module"]
        pub struct FWR_SPEC;
        impl crate::RegisterSpec for FWR_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [fwr::R](R) reader structure"]
        impl crate::Readable for FWR_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [fwr::W](W) writer structure"]
        impl crate::Writable for FWR_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets FWR to value 0"]
        impl crate::Resettable for FWR_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F0R1 register accessor: an alias for `Reg<F0R1_SPEC>`"]
    pub type F0R1 = crate::Reg<f0r1::F0R1_SPEC>;
    #[doc = "Filter bank 0 register 1"]
    pub mod f0r1 {
        #[doc = "Register `F0R1` reader"]
        pub struct R(crate::R<F0R1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F0R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F0R1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F0R1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F0R1` writer"]
        pub struct W(crate::W<F0R1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F0R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F0R1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F0R1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 0 register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f0r1](index.html) module"]
        pub struct F0R1_SPEC;
        impl crate::RegisterSpec for F0R1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f0r1::R](R) reader structure"]
        impl crate::Readable for F0R1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f0r1::W](W) writer structure"]
        impl crate::Writable for F0R1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F0R1 to value 0"]
        impl crate::Resettable for F0R1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F0R2 register accessor: an alias for `Reg<F0R2_SPEC>`"]
    pub type F0R2 = crate::Reg<f0r2::F0R2_SPEC>;
    #[doc = "Filter bank 0 register 2"]
    pub mod f0r2 {
        #[doc = "Register `F0R2` reader"]
        pub struct R(crate::R<F0R2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F0R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F0R2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F0R2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F0R2` writer"]
        pub struct W(crate::W<F0R2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F0R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F0R2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F0R2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 0 register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f0r2](index.html) module"]
        pub struct F0R2_SPEC;
        impl crate::RegisterSpec for F0R2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f0r2::R](R) reader structure"]
        impl crate::Readable for F0R2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f0r2::W](W) writer structure"]
        impl crate::Writable for F0R2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F0R2 to value 0"]
        impl crate::Resettable for F0R2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F1R1 register accessor: an alias for `Reg<F1R1_SPEC>`"]
    pub type F1R1 = crate::Reg<f1r1::F1R1_SPEC>;
    #[doc = "Filter bank 1 register 1"]
    pub mod f1r1 {
        #[doc = "Register `F1R1` reader"]
        pub struct R(crate::R<F1R1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F1R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F1R1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F1R1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F1R1` writer"]
        pub struct W(crate::W<F1R1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F1R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F1R1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F1R1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 1 register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f1r1](index.html) module"]
        pub struct F1R1_SPEC;
        impl crate::RegisterSpec for F1R1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f1r1::R](R) reader structure"]
        impl crate::Readable for F1R1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f1r1::W](W) writer structure"]
        impl crate::Writable for F1R1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F1R1 to value 0"]
        impl crate::Resettable for F1R1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F1R2 register accessor: an alias for `Reg<F1R2_SPEC>`"]
    pub type F1R2 = crate::Reg<f1r2::F1R2_SPEC>;
    #[doc = "Filter bank 1 register 2"]
    pub mod f1r2 {
        #[doc = "Register `F1R2` reader"]
        pub struct R(crate::R<F1R2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F1R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F1R2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F1R2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F1R2` writer"]
        pub struct W(crate::W<F1R2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F1R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F1R2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F1R2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 1 register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f1r2](index.html) module"]
        pub struct F1R2_SPEC;
        impl crate::RegisterSpec for F1R2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f1r2::R](R) reader structure"]
        impl crate::Readable for F1R2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f1r2::W](W) writer structure"]
        impl crate::Writable for F1R2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F1R2 to value 0"]
        impl crate::Resettable for F1R2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F2R1 register accessor: an alias for `Reg<F2R1_SPEC>`"]
    pub type F2R1 = crate::Reg<f2r1::F2R1_SPEC>;
    #[doc = "Filter bank 2 register 1"]
    pub mod f2r1 {
        #[doc = "Register `F2R1` reader"]
        pub struct R(crate::R<F2R1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F2R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F2R1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F2R1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F2R1` writer"]
        pub struct W(crate::W<F2R1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F2R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F2R1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F2R1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 2 register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f2r1](index.html) module"]
        pub struct F2R1_SPEC;
        impl crate::RegisterSpec for F2R1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f2r1::R](R) reader structure"]
        impl crate::Readable for F2R1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f2r1::W](W) writer structure"]
        impl crate::Writable for F2R1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F2R1 to value 0"]
        impl crate::Resettable for F2R1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F2R2 register accessor: an alias for `Reg<F2R2_SPEC>`"]
    pub type F2R2 = crate::Reg<f2r2::F2R2_SPEC>;
    #[doc = "Filter bank 2 register 2"]
    pub mod f2r2 {
        #[doc = "Register `F2R2` reader"]
        pub struct R(crate::R<F2R2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F2R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F2R2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F2R2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F2R2` writer"]
        pub struct W(crate::W<F2R2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F2R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F2R2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F2R2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 2 register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f2r2](index.html) module"]
        pub struct F2R2_SPEC;
        impl crate::RegisterSpec for F2R2_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f2r2::R](R) reader structure"]
        impl crate::Readable for F2R2_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f2r2::W](W) writer structure"]
        impl crate::Writable for F2R2_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F2R2 to value 0"]
        impl crate::Resettable for F2R2_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F3R1 register accessor: an alias for `Reg<F3R1_SPEC>`"]
    pub type F3R1 = crate::Reg<f3r1::F3R1_SPEC>;
    #[doc = "Filter bank 3 register 1"]
    pub mod f3r1 {
        #[doc = "Register `F3R1` reader"]
        pub struct R(crate::R<F3R1_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F3R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F3R1_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F3R1_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F3R1` writer"]
        pub struct W(crate::W<F3R1_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F3R1_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F3R1_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F3R1_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB2_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB2_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB2` writer - Filter bits"]
        pub struct FB2_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB2_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 2)) | ((value as u32 & 1) << 2);
                self.w
            }
        }
        #[doc = "Field `FB3` reader - Filter bits"]
        pub struct FB3_R(crate::FieldReader<bool>);
        impl FB3_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB3_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB3_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB3` writer - Filter bits"]
        pub struct FB3_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB3_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
                self.w
            }
        }
        #[doc = "Field `FB4` reader - Filter bits"]
        pub struct FB4_R(crate::FieldReader<bool>);
        impl FB4_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB4_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB4_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB4` writer - Filter bits"]
        pub struct FB4_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB4_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 4)) | ((value as u32 & 1) << 4);
                self.w
            }
        }
        #[doc = "Field `FB5` reader - Filter bits"]
        pub struct FB5_R(crate::FieldReader<bool>);
        impl FB5_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB5_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB5_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB5` writer - Filter bits"]
        pub struct FB5_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB5_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 5)) | ((value as u32 & 1) << 5);
                self.w
            }
        }
        #[doc = "Field `FB6` reader - Filter bits"]
        pub struct FB6_R(crate::FieldReader<bool>);
        impl FB6_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB6_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB6_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB6` writer - Filter bits"]
        pub struct FB6_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB6_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 6)) | ((value as u32 & 1) << 6);
                self.w
            }
        }
        #[doc = "Field `FB7` reader - Filter bits"]
        pub struct FB7_R(crate::FieldReader<bool>);
        impl FB7_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB7_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB7_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB7` writer - Filter bits"]
        pub struct FB7_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB7_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
                self.w
            }
        }
        #[doc = "Field `FB8` reader - Filter bits"]
        pub struct FB8_R(crate::FieldReader<bool>);
        impl FB8_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB8_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB8_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB8` writer - Filter bits"]
        pub struct FB8_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB8_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
                self.w
            }
        }
        #[doc = "Field `FB9` reader - Filter bits"]
        pub struct FB9_R(crate::FieldReader<bool>);
        impl FB9_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB9_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB9_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB9` writer - Filter bits"]
        pub struct FB9_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB9_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 9)) | ((value as u32 & 1) << 9);
                self.w
            }
        }
        #[doc = "Field `FB10` reader - Filter bits"]
        pub struct FB10_R(crate::FieldReader<bool>);
        impl FB10_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB10_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB10_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB10` writer - Filter bits"]
        pub struct FB10_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB10_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 10)) | ((value as u32 & 1) << 10);
                self.w
            }
        }
        #[doc = "Field `FB11` reader - Filter bits"]
        pub struct FB11_R(crate::FieldReader<bool>);
        impl FB11_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB11_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB11_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB11` writer - Filter bits"]
        pub struct FB11_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB11_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 11)) | ((value as u32 & 1) << 11);
                self.w
            }
        }
        #[doc = "Field `FB12` reader - Filter bits"]
        pub struct FB12_R(crate::FieldReader<bool>);
        impl FB12_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB12_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB12_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB12` writer - Filter bits"]
        pub struct FB12_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB12_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 12)) | ((value as u32 & 1) << 12);
                self.w
            }
        }
        #[doc = "Field `FB13` reader - Filter bits"]
        pub struct FB13_R(crate::FieldReader<bool>);
        impl FB13_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB13_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB13_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB13` writer - Filter bits"]
        pub struct FB13_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB13_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
                self.w
            }
        }
        #[doc = "Field `FB14` reader - Filter bits"]
        pub struct FB14_R(crate::FieldReader<bool>);
        impl FB14_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB14_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB14_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB14` writer - Filter bits"]
        pub struct FB14_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB14_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
                self.w
            }
        }
        #[doc = "Field `FB15` reader - Filter bits"]
        pub struct FB15_R(crate::FieldReader<bool>);
        impl FB15_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB15_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB15_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB15` writer - Filter bits"]
        pub struct FB15_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB15_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
                self.w
            }
        }
        #[doc = "Field `FB16` reader - Filter bits"]
        pub struct FB16_R(crate::FieldReader<bool>);
        impl FB16_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB16_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB16_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB16` writer - Filter bits"]
        pub struct FB16_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB16_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
                self.w
            }
        }
        #[doc = "Field `FB17` reader - Filter bits"]
        pub struct FB17_R(crate::FieldReader<bool>);
        impl FB17_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB17_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB17_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB17` writer - Filter bits"]
        pub struct FB17_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB17_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
                self.w
            }
        }
        #[doc = "Field `FB18` reader - Filter bits"]
        pub struct FB18_R(crate::FieldReader<bool>);
        impl FB18_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB18_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB18_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB18` writer - Filter bits"]
        pub struct FB18_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB18_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
                self.w
            }
        }
        #[doc = "Field `FB19` reader - Filter bits"]
        pub struct FB19_R(crate::FieldReader<bool>);
        impl FB19_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB19_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB19_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB19` writer - Filter bits"]
        pub struct FB19_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB19_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
                self.w
            }
        }
        #[doc = "Field `FB20` reader - Filter bits"]
        pub struct FB20_R(crate::FieldReader<bool>);
        impl FB20_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB20_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB20_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB20` writer - Filter bits"]
        pub struct FB20_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB20_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
                self.w
            }
        }
        #[doc = "Field `FB21` reader - Filter bits"]
        pub struct FB21_R(crate::FieldReader<bool>);
        impl FB21_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB21_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB21_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB21` writer - Filter bits"]
        pub struct FB21_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB21_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
                self.w
            }
        }
        #[doc = "Field `FB22` reader - Filter bits"]
        pub struct FB22_R(crate::FieldReader<bool>);
        impl FB22_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB22_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB22_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB22` writer - Filter bits"]
        pub struct FB22_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB22_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
                self.w
            }
        }
        #[doc = "Field `FB23` reader - Filter bits"]
        pub struct FB23_R(crate::FieldReader<bool>);
        impl FB23_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB23_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB23_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB23` writer - Filter bits"]
        pub struct FB23_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB23_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
                self.w
            }
        }
        #[doc = "Field `FB24` reader - Filter bits"]
        pub struct FB24_R(crate::FieldReader<bool>);
        impl FB24_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB24_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB24_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB24` writer - Filter bits"]
        pub struct FB24_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB24_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
                self.w
            }
        }
        #[doc = "Field `FB25` reader - Filter bits"]
        pub struct FB25_R(crate::FieldReader<bool>);
        impl FB25_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB25_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB25_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB25` writer - Filter bits"]
        pub struct FB25_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB25_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
                self.w
            }
        }
        #[doc = "Field `FB26` reader - Filter bits"]
        pub struct FB26_R(crate::FieldReader<bool>);
        impl FB26_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB26_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB26_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB26` writer - Filter bits"]
        pub struct FB26_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB26_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
                self.w
            }
        }
        #[doc = "Field `FB27` reader - Filter bits"]
        pub struct FB27_R(crate::FieldReader<bool>);
        impl FB27_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB27_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB27_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB27` writer - Filter bits"]
        pub struct FB27_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB27_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 27)) | ((value as u32 & 1) << 27);
                self.w
            }
        }
        #[doc = "Field `FB28` reader - Filter bits"]
        pub struct FB28_R(crate::FieldReader<bool>);
        impl FB28_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB28_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB28_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB28` writer - Filter bits"]
        pub struct FB28_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB28_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 28)) | ((value as u32 & 1) << 28);
                self.w
            }
        }
        #[doc = "Field `FB29` reader - Filter bits"]
        pub struct FB29_R(crate::FieldReader<bool>);
        impl FB29_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB29_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB29_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB29` writer - Filter bits"]
        pub struct FB29_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB29_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 29)) | ((value as u32 & 1) << 29);
                self.w
            }
        }
        #[doc = "Field `FB30` reader - Filter bits"]
        pub struct FB30_R(crate::FieldReader<bool>);
        impl FB30_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB30_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB30_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB30` writer - Filter bits"]
        pub struct FB30_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB30_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
                self.w
            }
        }
        #[doc = "Field `FB31` reader - Filter bits"]
        pub struct FB31_R(crate::FieldReader<bool>);
        impl FB31_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB31_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB31_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB31` writer - Filter bits"]
        pub struct FB31_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB31_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
                self.w
            }
        }
        impl R {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&self) -> FB0_R {
                FB0_R::new((self.bits & 1) != 0)
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&self) -> FB1_R {
                FB1_R::new(((self.bits >> 1) & 1) != 0)
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&self) -> FB2_R {
                FB2_R::new(((self.bits >> 2) & 1) != 0)
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&self) -> FB3_R {
                FB3_R::new(((self.bits >> 3) & 1) != 0)
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&self) -> FB4_R {
                FB4_R::new(((self.bits >> 4) & 1) != 0)
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&self) -> FB5_R {
                FB5_R::new(((self.bits >> 5) & 1) != 0)
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&self) -> FB6_R {
                FB6_R::new(((self.bits >> 6) & 1) != 0)
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&self) -> FB7_R {
                FB7_R::new(((self.bits >> 7) & 1) != 0)
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&self) -> FB8_R {
                FB8_R::new(((self.bits >> 8) & 1) != 0)
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&self) -> FB9_R {
                FB9_R::new(((self.bits >> 9) & 1) != 0)
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&self) -> FB10_R {
                FB10_R::new(((self.bits >> 10) & 1) != 0)
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&self) -> FB11_R {
                FB11_R::new(((self.bits >> 11) & 1) != 0)
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&self) -> FB12_R {
                FB12_R::new(((self.bits >> 12) & 1) != 0)
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&self) -> FB13_R {
                FB13_R::new(((self.bits >> 13) & 1) != 0)
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&self) -> FB14_R {
                FB14_R::new(((self.bits >> 14) & 1) != 0)
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&self) -> FB15_R {
                FB15_R::new(((self.bits >> 15) & 1) != 0)
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&self) -> FB16_R {
                FB16_R::new(((self.bits >> 16) & 1) != 0)
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&self) -> FB17_R {
                FB17_R::new(((self.bits >> 17) & 1) != 0)
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&self) -> FB18_R {
                FB18_R::new(((self.bits >> 18) & 1) != 0)
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&self) -> FB19_R {
                FB19_R::new(((self.bits >> 19) & 1) != 0)
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&self) -> FB20_R {
                FB20_R::new(((self.bits >> 20) & 1) != 0)
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&self) -> FB21_R {
                FB21_R::new(((self.bits >> 21) & 1) != 0)
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&self) -> FB22_R {
                FB22_R::new(((self.bits >> 22) & 1) != 0)
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&self) -> FB23_R {
                FB23_R::new(((self.bits >> 23) & 1) != 0)
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&self) -> FB24_R {
                FB24_R::new(((self.bits >> 24) & 1) != 0)
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&self) -> FB25_R {
                FB25_R::new(((self.bits >> 25) & 1) != 0)
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&self) -> FB26_R {
                FB26_R::new(((self.bits >> 26) & 1) != 0)
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&self) -> FB27_R {
                FB27_R::new(((self.bits >> 27) & 1) != 0)
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&self) -> FB28_R {
                FB28_R::new(((self.bits >> 28) & 1) != 0)
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&self) -> FB29_R {
                FB29_R::new(((self.bits >> 29) & 1) != 0)
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&self) -> FB30_R {
                FB30_R::new(((self.bits >> 30) & 1) != 0)
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&self) -> FB31_R {
                FB31_R::new(((self.bits >> 31) & 1) != 0)
            }
        }
        impl W {
            #[doc = "Bit 0 - Filter bits"]
            #[inline(always)]
            pub fn fb0(&mut self) -> FB0_W {
                FB0_W { w: self }
            }
            #[doc = "Bit 1 - Filter bits"]
            #[inline(always)]
            pub fn fb1(&mut self) -> FB1_W {
                FB1_W { w: self }
            }
            #[doc = "Bit 2 - Filter bits"]
            #[inline(always)]
            pub fn fb2(&mut self) -> FB2_W {
                FB2_W { w: self }
            }
            #[doc = "Bit 3 - Filter bits"]
            #[inline(always)]
            pub fn fb3(&mut self) -> FB3_W {
                FB3_W { w: self }
            }
            #[doc = "Bit 4 - Filter bits"]
            #[inline(always)]
            pub fn fb4(&mut self) -> FB4_W {
                FB4_W { w: self }
            }
            #[doc = "Bit 5 - Filter bits"]
            #[inline(always)]
            pub fn fb5(&mut self) -> FB5_W {
                FB5_W { w: self }
            }
            #[doc = "Bit 6 - Filter bits"]
            #[inline(always)]
            pub fn fb6(&mut self) -> FB6_W {
                FB6_W { w: self }
            }
            #[doc = "Bit 7 - Filter bits"]
            #[inline(always)]
            pub fn fb7(&mut self) -> FB7_W {
                FB7_W { w: self }
            }
            #[doc = "Bit 8 - Filter bits"]
            #[inline(always)]
            pub fn fb8(&mut self) -> FB8_W {
                FB8_W { w: self }
            }
            #[doc = "Bit 9 - Filter bits"]
            #[inline(always)]
            pub fn fb9(&mut self) -> FB9_W {
                FB9_W { w: self }
            }
            #[doc = "Bit 10 - Filter bits"]
            #[inline(always)]
            pub fn fb10(&mut self) -> FB10_W {
                FB10_W { w: self }
            }
            #[doc = "Bit 11 - Filter bits"]
            #[inline(always)]
            pub fn fb11(&mut self) -> FB11_W {
                FB11_W { w: self }
            }
            #[doc = "Bit 12 - Filter bits"]
            #[inline(always)]
            pub fn fb12(&mut self) -> FB12_W {
                FB12_W { w: self }
            }
            #[doc = "Bit 13 - Filter bits"]
            #[inline(always)]
            pub fn fb13(&mut self) -> FB13_W {
                FB13_W { w: self }
            }
            #[doc = "Bit 14 - Filter bits"]
            #[inline(always)]
            pub fn fb14(&mut self) -> FB14_W {
                FB14_W { w: self }
            }
            #[doc = "Bit 15 - Filter bits"]
            #[inline(always)]
            pub fn fb15(&mut self) -> FB15_W {
                FB15_W { w: self }
            }
            #[doc = "Bit 16 - Filter bits"]
            #[inline(always)]
            pub fn fb16(&mut self) -> FB16_W {
                FB16_W { w: self }
            }
            #[doc = "Bit 17 - Filter bits"]
            #[inline(always)]
            pub fn fb17(&mut self) -> FB17_W {
                FB17_W { w: self }
            }
            #[doc = "Bit 18 - Filter bits"]
            #[inline(always)]
            pub fn fb18(&mut self) -> FB18_W {
                FB18_W { w: self }
            }
            #[doc = "Bit 19 - Filter bits"]
            #[inline(always)]
            pub fn fb19(&mut self) -> FB19_W {
                FB19_W { w: self }
            }
            #[doc = "Bit 20 - Filter bits"]
            #[inline(always)]
            pub fn fb20(&mut self) -> FB20_W {
                FB20_W { w: self }
            }
            #[doc = "Bit 21 - Filter bits"]
            #[inline(always)]
            pub fn fb21(&mut self) -> FB21_W {
                FB21_W { w: self }
            }
            #[doc = "Bit 22 - Filter bits"]
            #[inline(always)]
            pub fn fb22(&mut self) -> FB22_W {
                FB22_W { w: self }
            }
            #[doc = "Bit 23 - Filter bits"]
            #[inline(always)]
            pub fn fb23(&mut self) -> FB23_W {
                FB23_W { w: self }
            }
            #[doc = "Bit 24 - Filter bits"]
            #[inline(always)]
            pub fn fb24(&mut self) -> FB24_W {
                FB24_W { w: self }
            }
            #[doc = "Bit 25 - Filter bits"]
            #[inline(always)]
            pub fn fb25(&mut self) -> FB25_W {
                FB25_W { w: self }
            }
            #[doc = "Bit 26 - Filter bits"]
            #[inline(always)]
            pub fn fb26(&mut self) -> FB26_W {
                FB26_W { w: self }
            }
            #[doc = "Bit 27 - Filter bits"]
            #[inline(always)]
            pub fn fb27(&mut self) -> FB27_W {
                FB27_W { w: self }
            }
            #[doc = "Bit 28 - Filter bits"]
            #[inline(always)]
            pub fn fb28(&mut self) -> FB28_W {
                FB28_W { w: self }
            }
            #[doc = "Bit 29 - Filter bits"]
            #[inline(always)]
            pub fn fb29(&mut self) -> FB29_W {
                FB29_W { w: self }
            }
            #[doc = "Bit 30 - Filter bits"]
            #[inline(always)]
            pub fn fb30(&mut self) -> FB30_W {
                FB30_W { w: self }
            }
            #[doc = "Bit 31 - Filter bits"]
            #[inline(always)]
            pub fn fb31(&mut self) -> FB31_W {
                FB31_W { w: self }
            }
            #[doc = "Writes raw bits to the register."]
            #[inline(always)]
            pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
                self.0.bits(bits);
                self
            }
        }
        #[doc = "Filter bank 3 register 1\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [f3r1](index.html) module"]
        pub struct F3R1_SPEC;
        impl crate::RegisterSpec for F3R1_SPEC {
            type Ux = u32;
        }
        #[doc = "`read()` method returns [f3r1::R](R) reader structure"]
        impl crate::Readable for F3R1_SPEC {
            type Reader = R;
        }
        #[doc = "`write(|w| ..)` method takes [f3r1::W](W) writer structure"]
        impl crate::Writable for F3R1_SPEC {
            type Writer = W;
        }
        #[doc = "`reset()` method sets F3R1 to value 0"]
        impl crate::Resettable for F3R1_SPEC {
            #[inline(always)]
            fn reset_value() -> Self::Ux {
                0
            }
        }
    }
    #[doc = "F3R2 register accessor: an alias for `Reg<F3R2_SPEC>`"]
    pub type F3R2 = crate::Reg<f3r2::F3R2_SPEC>;
    #[doc = "Filter bank 3 register 2"]
    pub mod f3r2 {
        #[doc = "Register `F3R2` reader"]
        pub struct R(crate::R<F3R2_SPEC>);
        impl core::ops::Deref for R {
            type Target = crate::R<F3R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl From<crate::R<F3R2_SPEC>> for R {
            #[inline(always)]
            fn from(reader: crate::R<F3R2_SPEC>) -> Self {
                R(reader)
            }
        }
        #[doc = "Register `F3R2` writer"]
        pub struct W(crate::W<F3R2_SPEC>);
        impl core::ops::Deref for W {
            type Target = crate::W<F3R2_SPEC>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        impl core::ops::DerefMut for W {
            #[inline(always)]
            fn deref_mut(&mut self) -> &mut Self::Target {
                &mut self.0
            }
        }
        impl From<crate::W<F3R2_SPEC>> for W {
            #[inline(always)]
            fn from(writer: crate::W<F3R2_SPEC>) -> Self {
                W(writer)
            }
        }
        #[doc = "Field `FB0` reader - Filter bits"]
        pub struct FB0_R(crate::FieldReader<bool>);
        impl FB0_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB0_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB0_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB0` writer - Filter bits"]
        pub struct FB0_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB0_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
                self.w
            }
        }
        #[doc = "Field `FB1` reader - Filter bits"]
        pub struct FB1_R(crate::FieldReader<bool>);
        impl FB1_R {
            #[inline(always)]
            pub(crate) fn new(bits: bool) -> Self {
                FB1_R(crate::FieldReader::new(bits))
            }
        }
        impl core::ops::Deref for FB1_R {
            type Target = crate::FieldReader<bool>;
            #[inline(always)]
            fn deref(&self) -> &Self::Target {
                &self.0
            }
        }
        #[doc = "Field `FB1` writer - Filter bits"]
        pub struct FB1_W<'a> {
            w: &'a mut W,
        }
        impl<'a> FB1_W<'a> {
            #[doc = r"Sets the field bit"]
            #[inline(always)]
            pub fn set_bit(self) -> &'a mut W {
                self.bit(true)
            }
            #[doc = r"Clears the field bit"]
            #[inline(always)]
            pub fn clear_bit(self) -> &'a mut W {
                self.bit(false)
            }
            #[doc = r"Writes raw bits to the field"]
            #[inline(always)]
            pub fn bit(self, value: bool) -> &'a mut W {
                self.w.bits = (self.w.bits & !(1 << 1)) | ((value as u32 & 1) << 1);
                self.w
            }
        }
        #[doc = "Field `FB2` reader - Filter bits"]
        pub struct FB2_R(crate::FieldReader<bool>);
        impl FB2_R {
          