//! This module contains functions that help generate random data.

use rand::{distributions::Alphanumeric, thread_rng, Rng};
use std::iter;

/// Generates `n` random chars from range `[0-9A-Za-z]` (alphanumeric)
///
/// This gives you `62^n` unique combinations
pub fn random_alphanum_string(n: u32) -> String {
    let mut rng = thread_rng();
    iter::repeat(())
        .map(|()| rng.sample(Alphanumeric))
        .map(char::from)
        .take(n as usize)
        .collect()
}

#[cfg(test)]
mod tests {
    use super::*;
    use regex::Regex;

    #[test]
    fn get_37_random_alphanumerical_string() {
        let random_chars = random_alphanum_string(37);
        println!("random chars: \"{}\"", random_chars);
        assert_eq!(37, random_chars.len());
        assert!(Regex::new(r"^[0-9A-Za-z]{37}$")
            .unwrap()
            .is_match(random_chars.as_str()));
    }
}
