use std::env;

pub fn shell(cmd: &str) -> String {
    // Fast dirty way to execute shell command
    let output = std::process::Command::new("sh")
        .arg("-c")
        .arg(cmd)
        .output()
        .expect("failed to execute process");
    let output = String::from_utf8_lossy(&output.stdout);
    output.to_string()
}

pub struct OS {}
impl OS {
    pub fn env(&self) -> Vec<String> {
        env::args().collect()
    }
}
