pub struct Base64 {}
impl Base64 {
    pub fn encode_char(c: u8) -> char {
        match c {
            0..=25 => (c + 65) as char,
            26..=51 => (c + 71) as char,
            52..=61 => (c - 4) as char,
            62 => '+',
            63 => '/',
            _ => '=',
        }
    }

    pub fn encode(input: &str) -> String {
        let mut output = String::new();
        let mut i = 0;
        while i < input.len() {
            let mut j = 0;
            let mut buf = 0;
            while j < 4 && i + j < input.len() {
                buf <<= 6;
                buf |= input.as_bytes()[i + j] as u32;
                j += 1;
            }
            i += j;
            output.push(Base64::encode_char(buf));
        }
        output
    }
}
