use chrono;
use std::fs::OpenOptions;
use std::io::Write;
use std::path::Path;

pub fn get_logger() -> SimpleLogger {
    SimpleLogger::new()
}

pub struct SimpleLogger {
    logfile: String,
}

impl SimpleLogger {
    pub fn new() -> SimpleLogger {
        SimpleLogger {
            logfile: "/tmp/rustlog.txt".to_string(),
        }
    }

    fn init(&self) {
        if !Path::new(&self.logfile).exists() {
            let mut file = OpenOptions::new()
                .write(true)
                .create(true)
                .open(&self.logfile)
                .unwrap();
            file.write_all(b"<creat Rust SimpleLogger>\n")
                .expect("write to file error");
        }
    }

    pub fn info(&self, msg: &str) {
        let s = format!(
            "[{}] [INFO]: {}",
            chrono::Local::now().format("%Y-%m-%d %H:%M:%S.%3f"),
            msg
        );
        println!("{}", s);
        self.init();

        let mut file = OpenOptions::new()
            .write(true)
            .append(true)
            .open(&self.logfile)
            .expect("open logger file error");
        if let Err(e) = writeln!(file, "{}", s) {
            eprintln!("Couldn't write to file: {}", e);
        }
    }
}
