// mod file;
mod lib;
// use file::{RFile, RIO};

use clap::{App, Arg};
use std::process::Command;

fn openssl_bas64(bits: i32) -> String {
    let op = Command::new("openssl")
        .arg("rand")
        .arg("-base64")
        .arg(bits.to_string())
        .output()
        .expect("ls command failed to start");
    String::from_utf8(op.stdout).unwrap()
}

fn main() {
    let matches = App::new("My Test Program")
        .version("0.1.0")
        .author("GrSrN5vyW689pZin <GrSrN5vyW689pZin@gmail.com>")
        .about("Rust fast command line toolkits.")
        .arg(
            Arg::with_name("account")
                .short("acc")
                .long("account")
                .takes_value(false)
                .help("Generate random username/password pair."),
        )
        .get_matches();

    let _acc = matches.value_of("account");
    match _acc {
        None => {
            let account = openssl_bas64(6);
            let password = openssl_bas64(12);
            println!("{}{}", account, password);
        }
        Some(s) => println!("{:?}", s),
    }
}
