# Contributing

Thanks for considering contributing! The group of maintainers for this project is small, and so we cannot reach our goals without you.

## How can I contribute?

### Did you find a bug?

If you've found a bug, please first search through the [existing issues](https://github.com/rusty-celery/rusty-celery/issues) to see if it has already been reported. If it was already reported and you have additional information that may be helpful, please include that information in a comment on the issue. Otherwise please submit a new issue with a descriptive title and as much context as you can.

### Did you write a solution to a bug?

If you've found a solution to a bug that you or someone else has already reported, please make sure there is not already a pull request open for the same fix. If not, please submit a PR and link to the original issue.

### Do you have a suggestion for an enhancement?

We use GitHub issues to track feature requests. Before submitting a feature request, please search to see if something similar has already been suggested. When creating a feature request, provide a clear title and description outlining why the enhancement would be useful. If the enhancement would involve changes to the API, please include code examples to demonstrate how the enhancement would be used.

### Would you like to help implement a missing feature?

If you're looking for something you can help with, search for any open issues with the label ["Status: Help Wanted"](https://github.com/rusty-celery/rusty-celery/issues?q=is%3Aopen+is%3Aissue+label%3A%22Status%3A+Help+Wanted%22). If you find one that suits you, please comment on the issue with your intent to work on it and any questions you might have.
