# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.2.0] - 2022-03-03
This is a small refactoring-only release done in preparation for `ArrayString`.

### Added
- add new top-level module `cds::mem` for code that deals with memory
- add new top-level module `cds::len` for length types

### Changed
- rename enum `InsertError` and `InsertErrorVal` variants:
  - `IndexOutOfBounds` to `InvalidIndex`
  - `CapacityError` to `InsufficientCapacity`
- move trait `SpareMemoryPolicy` and its implementors from `cds::defs` to `cds::mem`
- move trait `LengthType` and its implementors from `cds::defs` to `cds::len`

### Deleted
- remove the top-level module `cds::defs` as its contents were moved out to other modules

## [0.1.0] - 2022-02-18
### Added
- add performance tests for `ArrayVec`

## [0.0.6] - 2022-02-05
### Added
- add `ArrayVec::copy_from_slice`
- add `ArrayVec::copy_from_slice_unchecked`
- add `ArrayVec::try_copy_from_slice`
- implement `std::io::Write` on `ArrayVec`

## [0.0.5] - 2022-02-04
### Added
- add `ArrayVec::resize` implementation
- add `ArrayVec::resize_mut` implementation

## [0.0.4] - 2022-01-28
### Added
- add `ArrayVec::drain` implementation
- add `ArrayVec::retain` implementation
- add `ArrayVec::retain_mut` implementation
- implement the `Extend` trait on `ArrayVec`
- add a fuzz test

## [0.0.3] - 2021-12-18
### Added
- add `ArrayVec::try_push_val` and `ArrayVec::try_insert_val` methods, to return an element to the caller
  in case of an error.
- add `InsertErrorVal` and `CapacityErrorVal` types to be used in `try_insert_val` and `try_push_val` respectively.
- add full test coverage for existing methods.

## [0.0.2] - 2021-12-10
### Added
- `LengthType` - allows customization of the type used to track a fixed-capacity collection's
  length.
- `SpareMemoryPolicy` - allows custom behavior with spare memory in a collection.
- `ArrayVec` initial implementation. This is mostly untested and many features missing,
  but a good skeleton to start with.

## [0.0.1] - 2021-11-20
### Added
`crates.io` placeholder.
