/*-
 * cdns-rs - a simple sync/async DNS query library
 * Copyright (C) 2020  Aleksandr Morozov, RELKOM s.r.o
 * Copyright (C) 2021-2022  Aleksandr Morozov
 * 
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

pub mod network;
pub mod query;

pub mod common;
pub mod cfg_parsers;
pub mod cfg_host_parser;
pub mod cfg_resolv_parser;
pub mod caches;

pub mod poison;
pub mod mutex;
pub mod request;

mod query_polltaps;
//mod query_private;

#[macro_use] pub mod log; 

pub use crate::cfg_resolv_parser::ResolveConfig;
pub use query::{QDns};
pub use crate::query::{QuerySetup, QDnsQueriesRes};
pub use common::{QType, DnsRdata, QDnsName};
