/*-
 * cdns-rs - a simple sync/async DNS query library
 * Copyright (C) 2020  Aleksandr Morozov, RELKOM s.r.o
 * Copyright (C) 2021-2022  Aleksandr Morozov
 * 
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */


/// This file contains the config file parsers.

use std::{io::Read, sync::atomic::AtomicUsize};
use std::fs::File;

use std::path::Path;

use crate::{internal_error_map, error::*};


pub trait ConfigParser<T>
{
    fn parse_config() -> CDnsResult<T>;

    fn get_file_path() -> &'static Path;

    fn is_default(&self) -> bool;
}

pub(super)
fn read_file(path: &str) -> CDnsResult<String>
{
    let mut file = 
        File::open(path).map_err(|e| internal_error_map!(CDnsErrorType::InternalError, "{}", e))?;

    let mut file_content: String = String::new();

    file.read_to_string(&mut file_content).map_err(|e| internal_error_map!(CDnsErrorType::InternalError, "{}", e))?;

    return Ok(file_content);
}



