/*-
 * cdns-rs - a simple sync/async DNS query library
 * Copyright (C) 2020  Aleksandr Morozov, RELKOM s.r.o
 * Copyright (C) 2021-2022  Aleksandr Morozov
 * 
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

use std::hash::{Hash, Hasher};

use super::common::{QDnsName, QType};



#[derive(Debug)]
pub struct QDnsReq<'req>
{
    req_name: QDnsName<'req>,
    qtype: QType,
}


impl<'req> Eq for QDnsReq<'req> {}

impl<'req> PartialEq for QDnsReq<'req>
{
    fn eq(&self, other: &QDnsReq) -> bool 
    {
        return self.req_name == other.req_name;
    }
}

impl<'req> Hash for QDnsReq<'req>
{
    fn hash<H: Hasher>(&self, state: &mut H) 
    {
        self.req_name.hash(state);
    }
}


impl<'req> QDnsReq<'req>
{
    pub(crate)
    fn new(req_name: QDnsName<'req>, qtype: QType) -> QDnsReq<'req>
    {
        return Self { req_name: req_name, qtype: qtype };
    }

    pub(crate) 
    fn get_type(&self) -> &QType
    {
        return &self.qtype;
    }

    pub(crate) 
    fn get_req_name(&self) -> &QDnsName<'req>
    {
        return &self.req_name;
    }
}

