use std::{fmt::{self, Write}, sync::Arc};

use cdns_rs::sync::{QDns, QuerySetup, log, ResolveConfig};

struct OutputAdapter{}

unsafe impl Send for OutputAdapter {}

impl Write for OutputAdapter
{
    fn write_str(&mut self, s: &str) -> fmt::Result 
    {
        println!("OutputAdapter: {}", s );
        return Ok(());
    }
}

impl OutputAdapter
{
    fn new() -> Self
    {
        return Self{};
    }
}

// Don't forget to enable feature "example_sync_log" in cargo default!
// This example demonstrates how to get error output from the crate.
fn main()
{
    // creating instance
    let oa = OutputAdapter::new();

    // converting it to 
    log::cdns_custom_output::initialize_safe(Box::new(oa));

    //let resolvers = CACHE.clone_resolve_list().unwrap();

    let custom = Arc::new(ResolveConfig::custom_config("nameserver 127.0.0.2\n").unwrap());

    // forming request
    let dns = QDns::make_a_aaaa_request(custom, "nonexistent.com", QuerySetup::default()).unwrap();

    // sending request and receiving results
    let res = dns.query();

    println!("{}", res);

    return;
}