
use std::sync::Arc;

use cdns_rs::a_sync::{ResolveConfig, QDns, QuerySetup, QType, request};
use tokio::time::{Instant};

#[tokio::main(flavor = "multi_thread", worker_threads = 2)]
async fn main()
{
    let cfg = 
"nameserver 192.168.2.1
";

    let cust = Arc::new(ResolveConfig::custom_config(cfg).unwrap());
    let now = Instant::now();

    // a, aaaa
    let res_a = request::resolve_fqdn("protonmail.com", Some(cust.clone())).await.unwrap();
    
    // mx
    let res_mx = request::resolve_mx("protonmail.com", Some(cust.clone())).await.unwrap();

    // ptr
    let res_ptr_local = request::resolve_reverse("::1", Some(cust.clone())).await.unwrap();

    // ptr
    let res_ptr = request::resolve_reverse("8.8.8.8", Some(cust.clone())).await.unwrap();
    
    // soa
    //let resolvers = CACHE.clone_resolve_list().await.unwrap();

    let mut dns_req = 
        QDns::make_empty(cust.clone(), 1, QuerySetup::default());

    dns_req.add_request(QType::SOA, "protonmail.com");

    // sending request and receiving results
    let res = dns_req.query().await;

    let elapsed = now.elapsed();
    println!("Elapsed: {:.2?}", elapsed);

    println!("A/AAAA:");
    for a in res_a
    {
        println!("\t{}", a);
    }

    println!("MX:");
    for mx in res_mx
    {
        println!("\t{}", mx);
    }

    println!("PTR local:");
    for ptr in res_ptr_local
    {
        println!("\t{}", ptr);
    }

    println!("PTR:");
    for ptr in res_ptr
    {
        println!("\t{}", ptr);
    }

    println!("SOA:");
    if res.is_results() == true
    {
        let inner = res.into_inner().unwrap();

        for i in inner
        {
            for r in i.get_responses()
            {
                println!("\t{}", r);
            }
        }
    }
    else
    {
        println!("\tNo SOA found!")
    }


    return;
}