# resolv.conf structure

This library is truing to combine all available types of the resolv.conf format. 
It should work normally with the configuration that you already have.

> `nameserver`
>
>IPv4 address (in dot notation) or IPv6 address (in hex-and-colon notation) of a name server that the resolver should query

> `search`
>
> !!! NOT IMPLEMENTED YET !!!
>
> Search list for host-name lookup.

> `domain`
>
>!!! NOT IMPLEMENTED YET !!!
>
> Local domain name. Most queries for names within this domain can use short names relative to the local domain. If no domain entry is present, the domain is determined from the local host name returned, the domain part is taken to be everything after the first dot. Finally, if the host name does not contain a domain part, the root domain is assumed.
>> OpenBSD only!

> `sortlist` 
>
>!!! NOT IMPLEMENTED YET !!!
>
> This option allows addresses returned by gethostbyname(3) to be sorted.
>>
>> sortlist 130.155.160.0/255.255.240.0 130.155.0.0

> `options` 
>
> Options allows certain lib's resolver variables to be modified.
>>
>> `debug` - Print debugging messages, if compiled with this option.
>>
>> `inet6` - Enables support for IPv6-only applications. Used in GNU/Linux, FreeBSD.
>>> In OpenBSD this option does nothing.
>>>
>>> If `family` is defined then this is ignored.
>>
>> `ndots:n` - Sets a threshold for the number of dots which must appear in a name given to res_query(3) before an initial absolute query will be made.
>>
>> `use-vc` `usevc` or `tcp` - Forces the use of TCP for queries. Normal behaviour is to query via UDP but fall back to TCP on failure.
>>> `use-vc` is GNU/Linux specific.
>>>
>>> `tcp` is OpenBSD specific
>>>
>>> `usevc` is FreeBSD specific
>>
>> `no-reload` - This option disables automatic reloading of a changed configuration file i.e /etc/resolv.conf /etc/hosts.
>>> GNU/Linux specific
>>
>> `rotate` - This option round-robin selection of name servers from among those listed.
>>
>> `no-check-names` - This option disables the modern BIND checking of incoming hostnames and mail names
>>
>> `attempts:n` - Sets the number of times the resolver will send a query to its name servers before giving up
>> 
>> `timeout:n` - Sets the amount of time the resolver will wait for a response from a remote name server before retrying the query via a different name server.
>>
>> `single-request` - By default, this crate performs IPv4 and IPv6 lookups in parallel. This option disables the behavior and makes crate perform the IPv6 and IPv4 requests sequentially.
>>
>> `single-request-reopen` - By default, resolver uses the same socket for the A and AAAA requests. Turning this option on will open a separate connection for each request.
>>
>> `trust-ad` - option controls the AD bit behavior of the stub resolver. (NOT IMPLEMENTED)



> `family` 
>
>> In GNU/Linux this option is not used. In FreeBSD too. OpenBSD specific!
>
> Specify which type of Internet protocol family to prefer, if a host is reachable using different address families.  
>
> family family `[family]`
>
> A maximum of two families can be specified, where family can be any of:
>
> - `inet4` IPv4 queries.
> - `inet6` IPv6 queries.
>
> If only one family is specified, only that family is tried.

> `lookup`
>
>> In GNU/Linux this option is not used. In FreeBSD too. OpenBSD specific!
>
> This keyword specifies which databases should be searched, and the order to do so.
>
> - `bind` Query a domain name server
> - `file` Search for entries in /etc/hosts.
>
> If the lookup keyword is not used in the system's resolv.conf file then the assumed order is bind file.




