/*-
* cdns-rs - a simple sync/async DNS query library
* Copyright (C) 2020  Aleksandr Morozov, RELKOM s.r.o
* Copyright (C) 2021-2022  Aleksandr Morozov
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public License
* along with this program; if not, write to the Free Software Foundation,
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
use std::hash::{Hash, Hasher};

use super::common::{QDnsName, QType};



#[derive(Debug)]
pub struct QDnsReq<'req>
{
    req_name: QDnsName<'req>,
    qtype: QType,
}


impl<'req> Eq for QDnsReq<'req> {}

impl<'req> PartialEq for QDnsReq<'req>
{
    fn eq(&self, other: &QDnsReq) -> bool 
    {
        return self.req_name == other.req_name;
    }
}

impl<'req> Hash for QDnsReq<'req>
{
    fn hash<H: Hasher>(&self, state: &mut H) 
    {
        self.req_name.hash(state);
    }
}


impl<'req> QDnsReq<'req>
{
    pub(crate)
    fn new(req_name: QDnsName<'req>, qtype: QType) -> QDnsReq<'req>
    {
        return Self { req_name: req_name, qtype: qtype };
    }

    pub(crate) 
    fn get_type(&self) -> &QType
    {
        return &self.qtype;
    }

    pub(crate) 
    fn get_req_name(&self) -> &QDnsName<'req>
    {
        return &self.req_name;
    }
}

