/*-
* cdns-rs - a simple sync/async DNS query library
* Copyright (C) 2020  Aleksandr Morozov, RELKOM s.r.o
* Copyright (C) 2021-2022  Aleksandr Morozov
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public License
* along with this program; if not, write to the Free Software Foundation,
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


use std::path::Path;

use crate::cfg_host_parser::HostConfig;
use crate::{error::*};


use super::caches::CacheOperations;
use super::cfg_parsers::{ConfigParser, read_file};
use super::common::{ HOST_CFG_PATH, HOST_CFG_PATH_P};
use super::log::sync_log_writer;

/// An /etc/hosts file parser


impl CacheOperations for HostConfig
{
    fn is_reload_allowed(&self) -> bool 
    {
        return true;
    }
}

impl ConfigParser<HostConfig> for HostConfig
{
    fn parse_config() -> CDnsResult<Self>
    {
        let mut writer = Writer::new();

        let file_content = read_file(HOST_CFG_PATH)?;
        
        let ret = Self::parse_host_file_internal(file_content, &mut writer);

        sync_log_writer(writer);

        return ret;
    }

    fn get_file_path() -> &'static Path
    {
        return &HOST_CFG_PATH_P;
    }

    fn is_default(&self) -> bool
    {
        return self.is_empty();
    }
}



