use std::time::Duration;

use cdns_rs::sync::{QDns, QDnsName, QuerySetup, QueryMode, QType};

fn main()
{
    let res = 
        QDns::query_optional(
            QDnsName::from("relkom.sk"), 
            QType::MX, 
            QuerySetup::new(true, true, QueryMode::ForceNxQueryAll, Some(Duration::from_secs(3)))
        );

    if res.is_err()
    {
        eprintln!("{}", res.err().unwrap());
        return;
    }

    let res = res.unwrap();

    println!("{}", res);

    let qs = 
        match res.into_inner()
        {
            Some(r) => r,
            None => return,
        };

    for q in qs
    {
        let res = q.collect_ok_responses_ref();

        println!("{}", res.into_iter().map(|x| x.to_string()).collect::<Vec<String>>().join(" "));
    }


    return;
}
