#![doc = "Peripheral access API for CC2538SF53 microcontrollers (generated using svd2rust v0.21.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.21.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn GPIO_A();
    fn GPIO_B();
    fn GPIO_C();
    fn GPIO_D();
    fn RESERVED_20();
    fn UART0();
    fn UART1();
    fn SSI0();
    fn I2C();
    fn RESERVED_25();
    fn RESERVED_26();
    fn RESERVED_27();
    fn RESERVED_28();
    fn RESERVED_29();
    fn ADC();
    fn GPTIMER0A();
    fn GPTIMER0B();
    fn GPTIMER1A();
    fn GPTIMER1B();
    fn GPTIMER2A();
    fn GPTIMER2B();
    fn ANALOG_COMP();
    fn RF_TXRX_ALT();
    fn RF_ERROR_ERR_ALT();
    fn SYS_CTRL();
    fn FLASH_MEM_CTRL();
    fn AES_ALT();
    fn PKA_ALT();
    fn SM_TIMER_ALT();
    fn MAC_TIMER_ALT();
    fn SSI1();
    fn GPTIMER3A();
    fn GPTIMER3B();
    fn RESERVED_53();
    fn RESERVED_55();
    fn RESERVED_59();
    fn RESERVED_60();
    fn RESERVED_61();
    fn UDMA_SW();
    fn UDMA_ERROR();
    fn RESERVED_64();
    fn RESERVED_65();
    fn RESERVED_66();
    fn RESERVED_67();
    fn RESERVED_68();
    fn RESERVED_69();
    fn RESERVED_70();
    fn RESERVED_71();
    fn RESERVED_72();
    fn RESERVED_73();
    fn RESERVED_74();
    fn RESERVED_75();
    fn RESERVED_76();
    fn RESERVED_77();
    fn RESERVED_78();
    fn RESERVED_79();
    fn RESERVED_80();
    fn RESERVED_81();
    fn RESERVED_82();
    fn RESERVED_83();
    fn RESERVED_84();
    fn RESERVED_85();
    fn RESERVED_86();
    fn RESERVED_87();
    fn RESERVED_88();
    fn RESERVED_89();
    fn RESERVED_90();
    fn RESERVED_91();
    fn RESERVED_92();
    fn RESERVED_93();
    fn RESERVED_94();
    fn RESERVED_95();
    fn RESERVED_96();
    fn RESERVED_97();
    fn RESERVED_98();
    fn RESERVED_99();
    fn RESERVED_100();
    fn RESERVED_101();
    fn RESERVED_102();
    fn RESERVED_103();
    fn RESERVED_104();
    fn RESERVED_105();
    fn RESERVED_106();
    fn RESERVED_107();
    fn RESERVED_108();
    fn RESERVED_109();
    fn RESERVED_110();
    fn RESERVED_111();
    fn RESERVED_112();
    fn RESERVED_113();
    fn RESERVED_114();
    fn RESERVED_115();
    fn RESERVED_116();
    fn RESERVED_117();
    fn RESERVED_118();
    fn RESERVED_119();
    fn RESERVED_120();
    fn RESERVED_121();
    fn RESERVED_122();
    fn RESERVED_123();
    fn RESERVED_124();
    fn RESERVED_125();
    fn RESERVED_126();
    fn RESERVED_127();
    fn RESERVED_128();
    fn RESERVED_129();
    fn RESERVED_130();
    fn RESERVED_131();
    fn RESERVED_132();
    fn RESERVED_133();
    fn RESERVED_134();
    fn RESERVED_135();
    fn RESERVED_136();
    fn RESERVED_137();
    fn RESERVED_138();
    fn RESERVED_139();
    fn RESERVED_140();
    fn RESERVED_141();
    fn RESERVED_142();
    fn RESERVED_143();
    fn RESERVED_144();
    fn RESERVED_145();
    fn RESERVED_146();
    fn RESERVED_147();
    fn RESERVED_148();
    fn RESERVED_149();
    fn RESERVED_150();
    fn RESERVED_151();
    fn RESERVED_152();
    fn RESERVED_153();
    fn RESERVED_154();
    fn RESERVED_155();
    fn USB();
    fn RF_TXRX();
    fn RF_ERROR();
    fn AES();
    fn PKA();
    fn SM_TIMER();
    fn MAC_TIMER();
    fn RESERVED_163();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 164 - 16] = [
    Vector { _handler: GPIO_A },
    Vector { _handler: GPIO_B },
    Vector { _handler: GPIO_C },
    Vector { _handler: GPIO_D },
    Vector {
        _handler: RESERVED_20,
    },
    Vector { _handler: UART0 },
    Vector { _handler: UART1 },
    Vector { _handler: SSI0 },
    Vector { _handler: I2C },
    Vector {
        _handler: RESERVED_25,
    },
    Vector {
        _handler: RESERVED_26,
    },
    Vector {
        _handler: RESERVED_27,
    },
    Vector {
        _handler: RESERVED_28,
    },
    Vector {
        _handler: RESERVED_29,
    },
    Vector { _handler: ADC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: GPTIMER0A,
    },
    Vector {
        _handler: GPTIMER0B,
    },
    Vector {
        _handler: GPTIMER1A,
    },
    Vector {
        _handler: GPTIMER1B,
    },
    Vector {
        _handler: GPTIMER2A,
    },
    Vector {
        _handler: GPTIMER2B,
    },
    Vector {
        _handler: ANALOG_COMP,
    },
    Vector {
        _handler: RF_TXRX_ALT,
    },
    Vector {
        _handler: RF_ERROR_ERR_ALT,
    },
    Vector { _handler: SYS_CTRL },
    Vector {
        _handler: FLASH_MEM_CTRL,
    },
    Vector { _handler: AES_ALT },
    Vector { _handler: PKA_ALT },
    Vector {
        _handler: SM_TIMER_ALT,
    },
    Vector {
        _handler: MAC_TIMER_ALT,
    },
    Vector { _handler: SSI1 },
    Vector {
        _handler: GPTIMER3A,
    },
    Vector {
        _handler: GPTIMER3B,
    },
    Vector {
        _handler: RESERVED_53,
    },
    Vector { _reserved: 0 },
    Vector {
        _handler: RESERVED_55,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: RESERVED_59,
    },
    Vector {
        _handler: RESERVED_60,
    },
    Vector {
        _handler: RESERVED_61,
    },
    Vector { _handler: UDMA_SW },
    Vector {
        _handler: UDMA_ERROR,
    },
    Vector {
        _handler: RESERVED_64,
    },
    Vector {
        _handler: RESERVED_65,
    },
    Vector {
        _handler: RESERVED_66,
    },
    Vector {
        _handler: RESERVED_67,
    },
    Vector {
        _handler: RESERVED_68,
    },
    Vector {
        _handler: RESERVED_69,
    },
    Vector {
        _handler: RESERVED_70,
    },
    Vector {
        _handler: RESERVED_71,
    },
    Vector {
        _handler: RESERVED_72,
    },
    Vector {
        _handler: RESERVED_73,
    },
    Vector {
        _handler: RESERVED_74,
    },
    Vector {
        _handler: RESERVED_75,
    },
    Vector {
        _handler: RESERVED_76,
    },
    Vector {
        _handler: RESERVED_77,
    },
    Vector {
        _handler: RESERVED_78,
    },
    Vector {
        _handler: RESERVED_79,
    },
    Vector {
        _handler: RESERVED_80,
    },
    Vector {
        _handler: RESERVED_81,
    },
    Vector {
        _handler: RESERVED_82,
    },
    Vector {
        _handler: RESERVED_83,
    },
    Vector {
        _handler: RESERVED_84,
    },
    Vector {
        _handler: RESERVED_85,
    },
    Vector {
        _handler: RESERVED_86,
    },
    Vector {
        _handler: RESERVED_87,
    },
    Vector {
        _handler: RESERVED_88,
    },
    Vector {
        _handler: RESERVED_89,
    },
    Vector {
        _handler: RESERVED_90,
    },
    Vector {
        _handler: RESERVED_91,
    },
    Vector {
        _handler: RESERVED_92,
    },
    Vector {
        _handler: RESERVED_93,
    },
    Vector {
        _handler: RESERVED_94,
    },
    Vector {
        _handler: RESERVED_95,
    },
    Vector {
        _handler: RESERVED_96,
    },
    Vector {
        _handler: RESERVED_97,
    },
    Vector {
        _handler: RESERVED_98,
    },
    Vector {
        _handler: RESERVED_99,
    },
    Vector {
        _handler: RESERVED_100,
    },
    Vector {
        _handler: RESERVED_101,
    },
    Vector {
        _handler: RESERVED_102,
    },
    Vector {
        _handler: RESERVED_103,
    },
    Vector {
        _handler: RESERVED_104,
    },
    Vector {
        _handler: RESERVED_105,
    },
    Vector {
        _handler: RESERVED_106,
    },
    Vector {
        _handler: RESERVED_107,
    },
    Vector {
        _handler: RESERVED_108,
    },
    Vector {
        _handler: RESERVED_109,
    },
    Vector {
        _handler: RESERVED_110,
    },
    Vector {
        _handler: RESERVED_111,
    },
    Vector {
        _handler: RESERVED_112,
    },
    Vector {
        _handler: RESERVED_113,
    },
    Vector {
        _handler: RESERVED_114,
    },
    Vector {
        _handler: RESERVED_115,
    },
    Vector {
        _handler: RESERVED_116,
    },
    Vector {
        _handler: RESERVED_117,
    },
    Vector {
        _handler: RESERVED_118,
    },
    Vector {
        _handler: RESERVED_119,
    },
    Vector {
        _handler: RESERVED_120,
    },
    Vector {
        _handler: RESERVED_121,
    },
    Vector {
        _handler: RESERVED_122,
    },
    Vector {
        _handler: RESERVED_123,
    },
    Vector {
        _handler: RESERVED_124,
    },
    Vector {
        _handler: RESERVED_125,
    },
    Vector {
        _handler: RESERVED_126,
    },
    Vector {
        _handler: RESERVED_127,
    },
    Vector {
        _handler: RESERVED_128,
    },
    Vector {
        _handler: RESERVED_129,
    },
    Vector {
        _handler: RESERVED_130,
    },
    Vector {
        _handler: RESERVED_131,
    },
    Vector {
        _handler: RESERVED_132,
    },
    Vector {
        _handler: RESERVED_133,
    },
    Vector {
        _handler: RESERVED_134,
    },
    Vector {
        _handler: RESERVED_135,
    },
    Vector {
        _handler: RESERVED_136,
    },
    Vector {
        _handler: RESERVED_137,
    },
    Vector {
        _handler: RESERVED_138,
    },
    Vector {
        _handler: RESERVED_139,
    },
    Vector {
        _handler: RESERVED_140,
    },
    Vector {
        _handler: RESERVED_141,
    },
    Vector {
        _handler: RESERVED_142,
    },
    Vector {
        _handler: RESERVED_143,
    },
    Vector {
        _handler: RESERVED_144,
    },
    Vector {
        _handler: RESERVED_145,
    },
    Vector {
        _handler: RESERVED_146,
    },
    Vector {
        _handler: RESERVED_147,
    },
    Vector {
        _handler: RESERVED_148,
    },
    Vector {
        _handler: RESERVED_149,
    },
    Vector {
        _handler: RESERVED_150,
    },
    Vector {
        _handler: RESERVED_151,
    },
    Vector {
        _handler: RESERVED_152,
    },
    Vector {
        _handler: RESERVED_153,
    },
    Vector {
        _handler: RESERVED_154,
    },
    Vector {
        _handler: RESERVED_155,
    },
    Vector { _handler: USB },
    Vector { _handler: RF_TXRX },
    Vector { _handler: RF_ERROR },
    Vector { _handler: AES },
    Vector { _handler: PKA },
    Vector { _handler: SM_TIMER },
    Vector {
        _handler: MAC_TIMER,
    },
    Vector {
        _handler: RESERVED_163,
    },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "16 - GPIO_A global interrupt"]
    GPIO_A = 16,
    #[doc = "17 - GPIO_B global interrupt"]
    GPIO_B = 17,
    #[doc = "18 - GPIO_C global interrupt"]
    GPIO_C = 18,
    #[doc = "19 - GPIO_D global interrupt"]
    GPIO_D = 19,
    #[doc = "20 - Reserved global interrupt"]
    RESERVED_20 = 20,
    #[doc = "21 - UART0 global interrupt"]
    UART0 = 21,
    #[doc = "22 - UART1 global interrupt"]
    UART1 = 22,
    #[doc = "23 - SSI0 global interrupt"]
    SSI0 = 23,
    #[doc = "24 - I2C global interrupt"]
    I2C = 24,
    #[doc = "25 - Reserved global interrupt"]
    RESERVED_25 = 25,
    #[doc = "26 - Reserved global interrupt"]
    RESERVED_26 = 26,
    #[doc = "27 - Reserved global interrupt"]
    RESERVED_27 = 27,
    #[doc = "28 - Reserved global interrupt"]
    RESERVED_28 = 28,
    #[doc = "29 - Reserved global interrupt"]
    RESERVED_29 = 29,
    #[doc = "30 - ADC interrupt"]
    ADC = 30,
    #[doc = "35 - GPTIMER0A global interrupt"]
    GPTIMER0A = 35,
    #[doc = "36 - GPTIMER0B global interrupt"]
    GPTIMER0B = 36,
    #[doc = "37 - GPTIMER1A global interrupt"]
    GPTIMER1A = 37,
    #[doc = "38 - GPTIMER1B global interrupt"]
    GPTIMER1B = 38,
    #[doc = "39 - GPTIMER2A global interrupt"]
    GPTIMER2A = 39,
    #[doc = "40 - GPTIMER2B global interrupt"]
    GPTIMER2B = 40,
    #[doc = "41 - ANALOG_COMP global interrupt"]
    ANALOG_COMP = 41,
    #[doc = "42 - RF TX/RX (Alternate) global interrupt"]
    RF_TXRX_ALT = 42,
    #[doc = "43 - RF Error (Alternate) global interrupt"]
    RF_ERROR_ERR_ALT = 43,
    #[doc = "44 - System Control global interrupt"]
    SYS_CTRL = 44,
    #[doc = "45 - Flash Memory Control global interrupt"]
    FLASH_MEM_CTRL = 45,
    #[doc = "46 - AES (Alternate) global interrupt"]
    AES_ALT = 46,
    #[doc = "47 - PKA (Alternate) global interrupt"]
    PKA_ALT = 47,
    #[doc = "48 - SM Timer (Alternate) global interrupt"]
    SM_TIMER_ALT = 48,
    #[doc = "49 - MAC Timer (Alternate) global interrupt"]
    MAC_TIMER_ALT = 49,
    #[doc = "50 - SSI1 global interrupt"]
    SSI1 = 50,
    #[doc = "51 - GPTIMER3A global interrupt"]
    GPTIMER3A = 51,
    #[doc = "52 - GPTIMER3B global interrupt"]
    GPTIMER3B = 52,
    #[doc = "53 - Reserved global interrupt"]
    RESERVED_53 = 53,
    #[doc = "55 - Reserved global interrupt"]
    RESERVED_55 = 55,
    #[doc = "59 - Reserved global interrupt"]
    RESERVED_59 = 59,
    #[doc = "60 - Reserved global interrupt"]
    RESERVED_60 = 60,
    #[doc = "61 - Reserved global interrupt"]
    RESERVED_61 = 61,
    #[doc = "62 - UDMA software interrupt"]
    UDMA_SW = 62,
    #[doc = "63 - UDMA error interrupt"]
    UDMA_ERROR = 63,
    #[doc = "64 - Reserved global interrupt"]
    RESERVED_64 = 64,
    #[doc = "65 - Reserved global interrupt"]
    RESERVED_65 = 65,
    #[doc = "66 - Reserved global interrupt"]
    RESERVED_66 = 66,
    #[doc = "67 - Reserved global interrupt"]
    RESERVED_67 = 67,
    #[doc = "68 - Reserved global interrupt"]
    RESERVED_68 = 68,
    #[doc = "69 - Reserved global interrupt"]
    RESERVED_69 = 69,
    #[doc = "70 - Reserved global interrupt"]
    RESERVED_70 = 70,
    #[doc = "71 - Reserved global interrupt"]
    RESERVED_71 = 71,
    #[doc = "72 - Reserved global interrupt"]
    RESERVED_72 = 72,
    #[doc = "73 - Reserved global interrupt"]
    RESERVED_73 = 73,
    #[doc = "74 - Reserved global interrupt"]
    RESERVED_74 = 74,
    #[doc = "75 - Reserved global interrupt"]
    RESERVED_75 = 75,
    #[doc = "76 - Reserved global interrupt"]
    RESERVED_76 = 76,
    #[doc = "77 - Reserved global interrupt"]
    RESERVED_77 = 77,
    #[doc = "78 - Reserved global interrupt"]
    RESERVED_78 = 78,
    #[doc = "79 - Reserved global interrupt"]
    RESERVED_79 = 79,
    #[doc = "80 - Reserved global interrupt"]
    RESERVED_80 = 80,
    #[doc = "81 - Reserved global interrupt"]
    RESERVED_81 = 81,
    #[doc = "82 - Reserved global interrupt"]
    RESERVED_82 = 82,
    #[doc = "83 - Reserved global interrupt"]
    RESERVED_83 = 83,
    #[doc = "84 - Reserved global interrupt"]
    RESERVED_84 = 84,
    #[doc = "85 - Reserved global interrupt"]
    RESERVED_85 = 85,
    #[doc = "86 - Reserved global interrupt"]
    RESERVED_86 = 86,
    #[doc = "87 - Reserved global interrupt"]
    RESERVED_87 = 87,
    #[doc = "88 - Reserved global interrupt"]
    RESERVED_88 = 88,
    #[doc = "89 - Reserved global interrupt"]
    RESERVED_89 = 89,
    #[doc = "90 - Reserved global interrupt"]
    RESERVED_90 = 90,
    #[doc = "91 - Reserved global interrupt"]
    RESERVED_91 = 91,
    #[doc = "92 - Reserved global interrupt"]
    RESERVED_92 = 92,
    #[doc = "93 - Reserved global interrupt"]
    RESERVED_93 = 93,
    #[doc = "94 - Reserved global interrupt"]
    RESERVED_94 = 94,
    #[doc = "95 - Reserved global interrupt"]
    RESERVED_95 = 95,
    #[doc = "96 - Reserved global interrupt"]
    RESERVED_96 = 96,
    #[doc = "97 - Reserved global interrupt"]
    RESERVED_97 = 97,
    #[doc = "98 - Reserved global interrupt"]
    RESERVED_98 = 98,
    #[doc = "99 - Reserved global interrupt"]
    RESERVED_99 = 99,
    #[doc = "100 - Reserved global interrupt"]
    RESERVED_100 = 100,
    #[doc = "101 - Reserved global interrupt"]
    RESERVED_101 = 101,
    #[doc = "102 - Reserved global interrupt"]
    RESERVED_102 = 102,
    #[doc = "103 - Reserved global interrupt"]
    RESERVED_103 = 103,
    #[doc = "104 - Reserved global interrupt"]
    RESERVED_104 = 104,
    #[doc = "105 - Reserved global interrupt"]
    RESERVED_105 = 105,
    #[doc = "106 - Reserved global interrupt"]
    RESERVED_106 = 106,
    #[doc = "107 - Reserved global interrupt"]
    RESERVED_107 = 107,
    #[doc = "108 - Reserved global interrupt"]
    RESERVED_108 = 108,
    #[doc = "109 - Reserved global interrupt"]
    RESERVED_109 = 109,
    #[doc = "110 - Reserved global interrupt"]
    RESERVED_110 = 110,
    #[doc = "111 - Reserved global interrupt"]
    RESERVED_111 = 111,
    #[doc = "112 - Reserved global interrupt"]
    RESERVED_112 = 112,
    #[doc = "113 - Reserved global interrupt"]
    RESERVED_113 = 113,
    #[doc = "114 - Reserved global interrupt"]
    RESERVED_114 = 114,
    #[doc = "115 - Reserved global interrupt"]
    RESERVED_115 = 115,
    #[doc = "116 - Reserved global interrupt"]
    RESERVED_116 = 116,
    #[doc = "117 - Reserved global interrupt"]
    RESERVED_117 = 117,
    #[doc = "118 - Reserved global interrupt"]
    RESERVED_118 = 118,
    #[doc = "119 - Reserved global interrupt"]
    RESERVED_119 = 119,
    #[doc = "120 - Reserved global interrupt"]
    RESERVED_120 = 120,
    #[doc = "121 - Reserved global interrupt"]
    RESERVED_121 = 121,
    #[doc = "122 - Reserved global interrupt"]
    RESERVED_122 = 122,
    #[doc = "123 - Reserved global interrupt"]
    RESERVED_123 = 123,
    #[doc = "124 - Reserved global interrupt"]
    RESERVED_124 = 124,
    #[doc = "125 - Reserved global interrupt"]
    RESERVED_125 = 125,
    #[doc = "126 - Reserved global interrupt"]
    RESERVED_126 = 126,
    #[doc = "127 - Reserved global interrupt"]
    RESERVED_127 = 127,
    #[doc = "128 - Reserved global interrupt"]
    RESERVED_128 = 128,
    #[doc = "129 - Reserved global interrupt"]
    RESERVED_129 = 129,
    #[doc = "130 - Reserved global interrupt"]
    RESERVED_130 = 130,
    #[doc = "131 - Reserved global interrupt"]
    RESERVED_131 = 131,
    #[doc = "132 - Reserved global interrupt"]
    RESERVED_132 = 132,
    #[doc = "133 - Reserved global interrupt"]
    RESERVED_133 = 133,
    #[doc = "134 - Reserved global interrupt"]
    RESERVED_134 = 134,
    #[doc = "135 - Reserved global interrupt"]
    RESERVED_135 = 135,
    #[doc = "136 - Reserved global interrupt"]
    RESERVED_136 = 136,
    #[doc = "137 - Reserved global interrupt"]
    RESERVED_137 = 137,
    #[doc = "138 - Reserved global interrupt"]
    RESERVED_138 = 138,
    #[doc = "139 - Reserved global interrupt"]
    RESERVED_139 = 139,
    #[doc = "140 - Reserved global interrupt"]
    RESERVED_140 = 140,
    #[doc = "141 - Reserved global interrupt"]
    RESERVED_141 = 141,
    #[doc = "142 - Reserved global interrupt"]
    RESERVED_142 = 142,
    #[doc = "143 - Reserved global interrupt"]
    RESERVED_143 = 143,
    #[doc = "144 - Reserved global interrupt"]
    RESERVED_144 = 144,
    #[doc = "145 - Reserved global interrupt"]
    RESERVED_145 = 145,
    #[doc = "146 - Reserved global interrupt"]
    RESERVED_146 = 146,
    #[doc = "147 - Reserved global interrupt"]
    RESERVED_147 = 147,
    #[doc = "148 - Reserved global interrupt"]
    RESERVED_148 = 148,
    #[doc = "149 - Reserved global interrupt"]
    RESERVED_149 = 149,
    #[doc = "150 - Reserved global interrupt"]
    RESERVED_150 = 150,
    #[doc = "151 - Reserved global interrupt"]
    RESERVED_151 = 151,
    #[doc = "152 - Reserved global interrupt"]
    RESERVED_152 = 152,
    #[doc = "153 - Reserved global interrupt"]
    RESERVED_153 = 153,
    #[doc = "154 - Reserved global interrupt"]
    RESERVED_154 = 154,
    #[doc = "155 - Reserved global interrupt"]
    RESERVED_155 = 155,
    #[doc = "156 - USB global interrupt"]
    USB = 156,
    #[doc = "157 - RF TX/RX global interrupt"]
    RF_TXRX = 157,
    #[doc = "158 - RF ERROR global interrupt"]
    RF_ERROR = 158,
    #[doc = "159 - AES global interrupt"]
    AES = 159,
    #[doc = "160 - PKA global interrupt"]
    PKA = 160,
    #[doc = "161 - Sleep Timer global interrupt"]
    SM_TIMER = 161,
    #[doc = "162 - MAC_TIMER global interrupt"]
    MAC_TIMER = 162,
    #[doc = "163 - Reserved global interrupt"]
    RESERVED_163 = 163,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16 - 16
    }
}
#[doc = "no description available"]
pub struct SSI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SSI0 {}
impl SSI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ssi0::RegisterBlock = 0x4000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ssi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SSI0 {
    type Target = ssi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SSI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SSI0").finish()
    }
}
#[doc = "no description available"]
pub mod ssi0;
#[doc = "no description available"]
pub struct SSI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SSI1 {}
impl SSI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ssi1::RegisterBlock = 0x4000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ssi1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SSI1 {
    type Target = ssi1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SSI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SSI1").finish()
    }
}
#[doc = "no description available"]
pub mod ssi1;
#[doc = "no description available"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "no description available"]
pub mod uart0;
#[doc = "no description available"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart1::RegisterBlock = 0x4000_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "no description available"]
pub mod uart1;
#[doc = "no description available"]
pub struct I2CM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CM {}
impl I2CM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2cm::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2cm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CM {
    type Target = i2cm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CM").finish()
    }
}
#[doc = "no description available"]
pub mod i2cm;
#[doc = "no description available"]
pub struct I2CS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CS {}
impl I2CS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2cs::RegisterBlock = 0x4002_0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2cs::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CS {
    type Target = i2cs::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CS").finish()
    }
}
#[doc = "no description available"]
pub mod i2cs;
#[doc = "no description available"]
pub struct GPTIMER0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPTIMER0 {}
impl GPTIMER0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gptimer0::RegisterBlock = 0x4003_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gptimer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPTIMER0 {
    type Target = gptimer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPTIMER0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPTIMER0").finish()
    }
}
#[doc = "no description available"]
pub mod gptimer0;
#[doc = "no description available"]
pub struct GPTIMER1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPTIMER1 {}
impl GPTIMER1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gptimer1::RegisterBlock = 0x4003_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gptimer1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPTIMER1 {
    type Target = gptimer1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPTIMER1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPTIMER1").finish()
    }
}
#[doc = "no description available"]
pub mod gptimer1;
#[doc = "no description available"]
pub struct GPTIMER2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPTIMER2 {}
impl GPTIMER2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gptimer2::RegisterBlock = 0x4003_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gptimer2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPTIMER2 {
    type Target = gptimer2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPTIMER2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPTIMER2").finish()
    }
}
#[doc = "no description available"]
pub mod gptimer2;
#[doc = "no description available"]
pub struct GPTIMER3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPTIMER3 {}
impl GPTIMER3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gptimer3::RegisterBlock = 0x4003_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gptimer3::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPTIMER3 {
    type Target = gptimer3::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPTIMER3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPTIMER3").finish()
    }
}
#[doc = "no description available"]
pub mod gptimer3;
#[doc = "no description available"]
pub struct RFCORE_FFSM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RFCORE_FFSM {}
impl RFCORE_FFSM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rfcore_ffsm::RegisterBlock = 0x4008_8500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rfcore_ffsm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RFCORE_FFSM {
    type Target = rfcore_ffsm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RFCORE_FFSM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RFCORE_FFSM").finish()
    }
}
#[doc = "no description available"]
pub mod rfcore_ffsm;
#[doc = "no description available"]
pub struct RFCORE_XREG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RFCORE_XREG {}
impl RFCORE_XREG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rfcore_xreg::RegisterBlock = 0x4008_8600 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rfcore_xreg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RFCORE_XREG {
    type Target = rfcore_xreg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RFCORE_XREG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RFCORE_XREG").finish()
    }
}
#[doc = "no description available"]
pub mod rfcore_xreg;
#[doc = "no description available"]
pub struct RFCORE_SFR {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RFCORE_SFR {}
impl RFCORE_SFR {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rfcore_sfr::RegisterBlock = 0x4008_8800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rfcore_sfr::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RFCORE_SFR {
    type Target = rfcore_sfr::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RFCORE_SFR {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RFCORE_SFR").finish()
    }
}
#[doc = "no description available"]
pub mod rfcore_sfr;
#[doc = "no description available"]
pub struct USB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB {}
impl USB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb::RegisterBlock = 0x4008_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB {
    type Target = usb::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB").finish()
    }
}
#[doc = "no description available"]
pub mod usb;
#[doc = "no description available"]
pub struct AES {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AES {}
impl AES {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const aes::RegisterBlock = 0x4008_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const aes::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AES {
    type Target = aes::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AES {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AES").finish()
    }
}
#[doc = "no description available"]
pub mod aes;
#[doc = "no description available"]
pub struct SYS_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYS_CTRL {}
impl SYS_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys_ctrl::RegisterBlock = 0x400d_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYS_CTRL {
    type Target = sys_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYS_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYS_CTRL").finish()
    }
}
#[doc = "no description available"]
pub mod sys_ctrl;
#[doc = "no description available"]
pub struct FLASH_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for FLASH_CTRL {}
impl FLASH_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const flash_ctrl::RegisterBlock = 0x400d_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const flash_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for FLASH_CTRL {
    type Target = flash_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for FLASH_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("FLASH_CTRL").finish()
    }
}
#[doc = "no description available"]
pub mod flash_ctrl;
#[doc = "no description available"]
pub struct IOC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOC {}
impl IOC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ioc::RegisterBlock = 0x400d_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ioc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOC {
    type Target = ioc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOC").finish()
    }
}
#[doc = "no description available"]
pub mod ioc;
#[doc = "no description available"]
pub struct SMWDTHROSC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SMWDTHROSC {}
impl SMWDTHROSC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const smwdthrosc::RegisterBlock = 0x400d_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const smwdthrosc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SMWDTHROSC {
    type Target = smwdthrosc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SMWDTHROSC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SMWDTHROSC").finish()
    }
}
#[doc = "no description available"]
pub mod smwdthrosc;
#[doc = "no description available"]
pub struct ANA_REGS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ANA_REGS {}
impl ANA_REGS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ana_regs::RegisterBlock = 0x400d_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ana_regs::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ANA_REGS {
    type Target = ana_regs::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ANA_REGS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ANA_REGS").finish()
    }
}
#[doc = "no description available"]
pub mod ana_regs;
#[doc = "no description available"]
pub struct SOC_ADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SOC_ADC {}
impl SOC_ADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const soc_adc::RegisterBlock = 0x400d_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const soc_adc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SOC_ADC {
    type Target = soc_adc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SOC_ADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SOC_ADC").finish()
    }
}
#[doc = "no description available"]
pub mod soc_adc;
#[doc = "no description available"]
pub struct GPIO_A {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO_A {}
impl GPIO_A {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio_a::RegisterBlock = 0x400d_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio_a::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO_A {
    type Target = gpio_a::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO_A {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO_A").finish()
    }
}
#[doc = "no description available"]
pub mod gpio_a;
#[doc = "no description available"]
pub struct GPIO_B {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO_B {}
impl GPIO_B {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio_b::RegisterBlock = 0x400d_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio_b::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO_B {
    type Target = gpio_b::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO_B {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO_B").finish()
    }
}
#[doc = "no description available"]
pub mod gpio_b;
#[doc = "no description available"]
pub struct GPIO_C {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO_C {}
impl GPIO_C {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio_c::RegisterBlock = 0x400d_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio_c::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO_C {
    type Target = gpio_c::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO_C {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO_C").finish()
    }
}
#[doc = "no description available"]
pub mod gpio_c;
#[doc = "no description available"]
pub struct GPIO_D {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO_D {}
impl GPIO_D {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio_d::RegisterBlock = 0x400d_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio_d::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO_D {
    type Target = gpio_d::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO_D {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO_D").finish()
    }
}
#[doc = "no description available"]
pub mod gpio_d;
#[doc = "no description available"]
pub struct UDMA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UDMA {}
impl UDMA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const udma::RegisterBlock = 0x400f_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const udma::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UDMA {
    type Target = udma::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UDMA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UDMA").finish()
    }
}
#[doc = "no description available"]
pub mod udma;
#[doc = "no description available"]
pub struct STTEST {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for STTEST {}
impl STTEST {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sttest::RegisterBlock = 0x4011_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sttest::RegisterBlock {
        Self::PTR
    }
}
impl Deref for STTEST {
    type Target = sttest::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for STTEST {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("STTEST").finish()
    }
}
#[doc = "no description available"]
pub mod sttest;
#[doc = "no description available"]
pub struct PKA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PKA {}
impl PKA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pka::RegisterBlock = 0x4400_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pka::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PKA {
    type Target = pka::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PKA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PKA").finish()
    }
}
#[doc = "no description available"]
pub mod pka;
#[doc = "no description available"]
pub struct CCTEST {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CCTEST {}
impl CCTEST {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cctest::RegisterBlock = 0x4401_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cctest::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CCTEST {
    type Target = cctest::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CCTEST {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CCTEST").finish()
    }
}
#[doc = "no description available"]
pub mod cctest;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "SSI0"]
    pub SSI0: SSI0,
    #[doc = "SSI1"]
    pub SSI1: SSI1,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "I2CM"]
    pub I2CM: I2CM,
    #[doc = "I2CS"]
    pub I2CS: I2CS,
    #[doc = "GPTIMER0"]
    pub GPTIMER0: GPTIMER0,
    #[doc = "GPTIMER1"]
    pub GPTIMER1: GPTIMER1,
    #[doc = "GPTIMER2"]
    pub GPTIMER2: GPTIMER2,
    #[doc = "GPTIMER3"]
    pub GPTIMER3: GPTIMER3,
    #[doc = "RFCORE_FFSM"]
    pub RFCORE_FFSM: RFCORE_FFSM,
    #[doc = "RFCORE_XREG"]
    pub RFCORE_XREG: RFCORE_XREG,
    #[doc = "RFCORE_SFR"]
    pub RFCORE_SFR: RFCORE_SFR,
    #[doc = "USB"]
    pub USB: USB,
    #[doc = "AES"]
    pub AES: AES,
    #[doc = "SYS_CTRL"]
    pub SYS_CTRL: SYS_CTRL,
    #[doc = "FLASH_CTRL"]
    pub FLASH_CTRL: FLASH_CTRL,
    #[doc = "IOC"]
    pub IOC: IOC,
    #[doc = "SMWDTHROSC"]
    pub SMWDTHROSC: SMWDTHROSC,
    #[doc = "ANA_REGS"]
    pub ANA_REGS: ANA_REGS,
    #[doc = "SOC_ADC"]
    pub SOC_ADC: SOC_ADC,
    #[doc = "GPIO_A"]
    pub GPIO_A: GPIO_A,
    #[doc = "GPIO_B"]
    pub GPIO_B: GPIO_B,
    #[doc = "GPIO_C"]
    pub GPIO_C: GPIO_C,
    #[doc = "GPIO_D"]
    pub GPIO_D: GPIO_D,
    #[doc = "UDMA"]
    pub UDMA: UDMA,
    #[doc = "STTEST"]
    pub STTEST: STTEST,
    #[doc = "PKA"]
    pub PKA: PKA,
    #[doc = "CCTEST"]
    pub CCTEST: CCTEST,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            SSI0: SSI0 {
                _marker: PhantomData,
            },
            SSI1: SSI1 {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            I2CM: I2CM {
                _marker: PhantomData,
            },
            I2CS: I2CS {
                _marker: PhantomData,
            },
            GPTIMER0: GPTIMER0 {
                _marker: PhantomData,
            },
            GPTIMER1: GPTIMER1 {
                _marker: PhantomData,
            },
            GPTIMER2: GPTIMER2 {
                _marker: PhantomData,
            },
            GPTIMER3: GPTIMER3 {
                _marker: PhantomData,
            },
            RFCORE_FFSM: RFCORE_FFSM {
                _marker: PhantomData,
            },
            RFCORE_XREG: RFCORE_XREG {
                _marker: PhantomData,
            },
            RFCORE_SFR: RFCORE_SFR {
                _marker: PhantomData,
            },
            USB: USB {
                _marker: PhantomData,
            },
            AES: AES {
                _marker: PhantomData,
            },
            SYS_CTRL: SYS_CTRL {
                _marker: PhantomData,
            },
            FLASH_CTRL: FLASH_CTRL {
                _marker: PhantomData,
            },
            IOC: IOC {
                _marker: PhantomData,
            },
            SMWDTHROSC: SMWDTHROSC {
                _marker: PhantomData,
            },
            ANA_REGS: ANA_REGS {
                _marker: PhantomData,
            },
            SOC_ADC: SOC_ADC {
                _marker: PhantomData,
            },
            GPIO_A: GPIO_A {
                _marker: PhantomData,
            },
            GPIO_B: GPIO_B {
                _marker: PhantomData,
            },
            GPIO_C: GPIO_C {
                _marker: PhantomData,
            },
            GPIO_D: GPIO_D {
                _marker: PhantomData,
            },
            UDMA: UDMA {
                _marker: PhantomData,
            },
            STTEST: STTEST {
                _marker: PhantomData,
            },
            PKA: PKA {
                _marker: PhantomData,
            },
            CCTEST: CCTEST {
                _marker: PhantomData,
            },
        }
    }
}
