#[doc = "Register `AES_IV_2` reader"]
pub struct R(crate::R<AES_IV_2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AES_IV_2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<AES_IV_2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<AES_IV_2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AES_IV_2` writer"]
pub struct W(crate::W<AES_IV_2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AES_IV_2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<AES_IV_2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<AES_IV_2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `AES_IV` reader - AES_IV\\[95:64\\]
Initialization vector Used for regular non-ECB modes (CBC/CTR): -\\[127:0\\]
- AES_IV - For regular AES operations (CBC and CTR) these registers must be written with a new 128-bit IV. After an operation, these registers contain the latest 128-bit result IV, generated by the EIP-120t. If CTR mode is selected, this value is incremented with 0x1: After first use - When a new data block is submitted to the engine For GCM: -\\[127:0\\]
- AES_IV - For GCM operations, these registers must be written with a new 128-bit IV. After an operation, these registers contain the updated 128-bit result IV, generated by the EIP-120t. Note that bits \\[127:96\\]
of the IV represent the initial counter value (which is 1 for GCM) and must therefore be initialized to 0x01000000. This value is incremented with 0x1: After first use - When a new data block is submitted to the engine. For CCM: -\\[127:0\\]
- A0: For CCM this field must be written with value A0, this value is the concatenation of: A0-flags (5-bits of 0 and 3-bits 'L'), Nonce and counter value. 'L' must be a copy from the 'L' value of the AES_CTRL register. This 'L' indicates the width of the Nonce and counter. The loaded counter must be initialized to 0. The total width of A0 is 128-bit. For CBC-MAC: -\\[127:0\\]
- Zeroes - For CBC-MAC this register must be written with 0s at the start of each operation. After an operation, these registers contain the 128-bit TAG output, generated by the EIP-120t."]
pub struct AES_IV_R(crate::FieldReader<u32, u32>);
impl AES_IV_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        AES_IV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AES_IV_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AES_IV` writer - AES_IV\\[95:64\\]
Initialization vector Used for regular non-ECB modes (CBC/CTR): -\\[127:0\\]
- AES_IV - For regular AES operations (CBC and CTR) these registers must be written with a new 128-bit IV. After an operation, these registers contain the latest 128-bit result IV, generated by the EIP-120t. If CTR mode is selected, this value is incremented with 0x1: After first use - When a new data block is submitted to the engine For GCM: -\\[127:0\\]
- AES_IV - For GCM operations, these registers must be written with a new 128-bit IV. After an operation, these registers contain the updated 128-bit result IV, generated by the EIP-120t. Note that bits \\[127:96\\]
of the IV represent the initial counter value (which is 1 for GCM) and must therefore be initialized to 0x01000000. This value is incremented with 0x1: After first use - When a new data block is submitted to the engine. For CCM: -\\[127:0\\]
- A0: For CCM this field must be written with value A0, this value is the concatenation of: A0-flags (5-bits of 0 and 3-bits 'L'), Nonce and counter value. 'L' must be a copy from the 'L' value of the AES_CTRL register. This 'L' indicates the width of the Nonce and counter. The loaded counter must be initialized to 0. The total width of A0 is 128-bit. For CBC-MAC: -\\[127:0\\]
- Zeroes - For CBC-MAC this register must be written with 0s at the start of each operation. After an operation, these registers contain the 128-bit TAG output, generated by the EIP-120t."]
pub struct AES_IV_W<'a> {
    w: &'a mut W,
}
impl<'a> AES_IV_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = value;
        self.w
    }
}
impl R {
    #[doc = "Bits 0:31 - AES_IV\\[95:64\\]
Initialization vector Used for regular non-ECB modes (CBC/CTR): -\\[127:0\\]
- AES_IV - For regular AES operations (CBC and CTR) these registers must be written with a new 128-bit IV. After an operation, these registers contain the latest 128-bit result IV, generated by the EIP-120t. If CTR mode is selected, this value is incremented with 0x1: After first use - When a new data block is submitted to the engine For GCM: -\\[127:0\\]
- AES_IV - For GCM operations, these registers must be written with a new 128-bit IV. After an operation, these registers contain the updated 128-bit result IV, generated by the EIP-120t. Note that bits \\[127:96\\]
of the IV represent the initial counter value (which is 1 for GCM) and must therefore be initialized to 0x01000000. This value is incremented with 0x1: After first use - When a new data block is submitted to the engine. For CCM: -\\[127:0\\]
- A0: For CCM this field must be written with value A0, this value is the concatenation of: A0-flags (5-bits of 0 and 3-bits 'L'), Nonce and counter value. 'L' must be a copy from the 'L' value of the AES_CTRL register. This 'L' indicates the width of the Nonce and counter. The loaded counter must be initialized to 0. The total width of A0 is 128-bit. For CBC-MAC: -\\[127:0\\]
- Zeroes - For CBC-MAC this register must be written with 0s at the start of each operation. After an operation, these registers contain the 128-bit TAG output, generated by the EIP-120t."]
    #[inline(always)]
    pub fn aes_iv(&self) -> AES_IV_R {
        AES_IV_R::new(self.bits)
    }
}
impl W {
    #[doc = "Bits 0:31 - AES_IV\\[95:64\\]
Initialization vector Used for regular non-ECB modes (CBC/CTR): -\\[127:0\\]
- AES_IV - For regular AES operations (CBC and CTR) these registers must be written with a new 128-bit IV. After an operation, these registers contain the latest 128-bit result IV, generated by the EIP-120t. If CTR mode is selected, this value is incremented with 0x1: After first use - When a new data block is submitted to the engine For GCM: -\\[127:0\\]
- AES_IV - For GCM operations, these registers must be written with a new 128-bit IV. After an operation, these registers contain the updated 128-bit result IV, generated by the EIP-120t. Note that bits \\[127:96\\]
of the IV represent the initial counter value (which is 1 for GCM) and must therefore be initialized to 0x01000000. This value is incremented with 0x1: After first use - When a new data block is submitted to the engine. For CCM: -\\[127:0\\]
- A0: For CCM this field must be written with value A0, this value is the concatenation of: A0-flags (5-bits of 0 and 3-bits 'L'), Nonce and counter value. 'L' must be a copy from the 'L' value of the AES_CTRL register. This 'L' indicates the width of the Nonce and counter. The loaded counter must be initialized to 0. The total width of A0 is 128-bit. For CBC-MAC: -\\[127:0\\]
- Zeroes - For CBC-MAC this register must be written with 0s at the start of each operation. After an operation, these registers contain the 128-bit TAG output, generated by the EIP-120t."]
    #[inline(always)]
    pub fn aes_iv(&mut self) -> AES_IV_W {
        AES_IV_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "AES initialization vector registers These registers are used to provide and read the IV from the AES engine.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [aes_iv_2](index.html) module"]
pub struct AES_IV_2_SPEC;
impl crate::RegisterSpec for AES_IV_2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [aes_iv_2::R](R) reader structure"]
impl crate::Readable for AES_IV_2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [aes_iv_2::W](W) writer structure"]
impl crate::Writable for AES_IV_2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AES_IV_2 to value 0"]
impl crate::Resettable for AES_IV_2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
