// use std::fs;

/// th2 files are used in Therion for scrap (drawing) related information.
/// Tey contain the actual lines, curves and room names.
///
/// There are 3 definitions of the th2 format in Therion:
///
/// 1. The Therion Book
/// 2. The TCL parser in xtherion
/// 3. The C++ parser in therion
///
/// The book makes little destination between th-files (centerline, shots, survey)
/// and th2 files (drawings).
///
/// As of this Writing (May 22022) there are following definitions:
///
/// ## scrap
///
/// Options:
///
/// ### -projection <specification>
///
/// Specification can be
///
/// 1. none
/// 2. plan
/// 3. elevation ([elevation 10] or [elevation 10 deg])
/// 4. extended
///
/// ### -scale <specification>
///
/// Specification can be
///
/// 1. <number>
/// 2. [<number> <length units>]
/// 3. [<num1> <num2> <length units>]
/// 4. [<num1> ... <num8> [<length units>]]
///
/// ### -cs <coordinate system>
///
/// ### -stations <list of station names>
/// ### -sketch <filename> <x> <y>
/// ### -walls <on/off/auto>
/// ### -flip (none)/horizontal/vertical
/// ### -station-names <prefix> <suffix>
/// ### -author <date> <person>
/// ### -copyright <date> <string>
/// ### -title <string>

/// proc xth_me_cmds_create_all {lns} {

// encoding  utf-8

// ^\s*encoding\s+(\S+)\s*$
// ^\s*\#\#XTHERION\#\#\s+(\S.*)\s*$
// ^\s*\#\#BEGIN\#\#\s*$
// ^\s*\#\#END\#\#\s*$
// {(.*)\\\s*$

// scrap <id> [OPTIONS]
// ... point, line and area commands ...
// endscrap [<id>]

// ^\s*scrap\s+(\S+)\s*(.*)$
// ^\s*endscrap\s*(\S*)\s*$
// ^\s*point\s+(\S+)\s+(\S+)\s+(\S+)\s*(.*)$
// ^\s*line\s+(\S+)\s*(.*)$    set rxl [list [list "\\s*\\-$opt\\s+\\\[(\[^\\\]\]*)\\\]" "\["]\    [list "\\s*\\-$opt\\s+\\\"((\\\"\\\"|\[^\\\"])+)\\\"" "\""]\    [list "\\s*\\-$opt\\s+(\\S+)" {}]]
//   if {[regexp {^\s*\!?\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s*(\#.*)?$} \
// 	  $ln dum x1 y1 x2 y2 x y cmt] && (![catch {expr $x * $y * $x1 * $y1 * $x2 * $y2}])} {
//       set what 2
//     } elseif {[regexp {^\s*\!?\s*(\S+)\s+(\S+)\s*(\#.*)?$} $ln dum x y cmt] && (![catch {expr $x * $y}])} {
//       # skusi jednotlive options rotation size r-size l-size smooth
//       # skusi jednotlive options rotation size r-size l-size smooth
//       set cmt $ln
//       set optl [xth_me_cmds_get_option $ln orientation]
// 	set optl [xth_me_cmds_get_option $ln orient]
// 	  set optl [xth_me_cmds_get_option $ln smooth]
// 	    set smth [xth_me_cmds_get_onoffauto [lindex $optl 0]]
// 	    set optl [xth_me_cmds_get_option $ln size]
// 	      set optl [xth_me_cmds_get_option $ln r-size]
// 		set optl [xth_me_cmds_get_option $ln l-size]

// ^\s*area\s+(\S+)\s*(.*)$
// ^\s*endarea(\s|$)

pub mod th2 {

    #[derive(Parser)]
    #[grammar = "th2.pest"]
    pub struct TH2Parser;

    // #[cfg(test)]
    // mod test_encoding {
    //     #[test]
    //     fn successful_parse() {
    //         assert!( TH2Parser::parse(Rule::encoding, "encoding utf-8"));
    //         assert!( TH2Parser::parse(Rule::encoding, "encoding  utf-8"));
    //         assert!( TH2Parser::parse(Rule::encoding, "encoding  utf-8\n"));
    //         assert!( TH2Parser::parse(Rule::encoding, "encoding  utf-8 \n"));
    //         assert!( TH2Parser::parse(Rule::encoding, "encoding  utf-8\r\n"));
    //     }
    //     fn unsuccessful_parse() {
    //         assert!( TH2Parser::parse(Rule::encoding, "-128.0"));
    //     }
    // }
    //    let unparsed_file = fs::read_to_string(
    //         "/Users/md/Documents/AKKH-Vermessungen/windloch/scraps/windloch2021_g27_g122_g203_g204.th2",
    //     )
    //     .expect("cannot read file");

    //     let file = TH2Parser::parse(Rule::file, &unparsed_file)
    //     .expect("unsuccessful parse") // unwrap the parse result
    //     .next().unwrap(); // get and unwrap the `file` rule; never fails
}
