use crate::structs::cash::Cash;

impl Cash {
	// pub fn create(currency: &str, amount: i64) -> Self {
	// 	Self {
	// 		currency: String::from(currency),
	// 		amount: amount,
	// 	}
	// }
	// pub fn create(currency: Option<&str>, amount: i64) -> Option<Cash> {
	// 	match currency {
	// 		None => None,
	// 		Some(curr) => Some(Cash {
	// 			currency: String::from(curr),
	// 			amount: amount,
	// 		}),
	// 	}
	// }
	pub fn create(currency: &str, amount: i64) -> Cash {
		match currency {
			"USD" => Cash {
				currency: String::from(currency),
				amount: amount,
			},
			"EUR" => Cash {
				currency: String::from(currency),
				amount: amount,
			},
			_ => Cash {
				currency: String::from(""),
				amount: amount,
			},
		}
	}
}

pub trait Create {
	fn currency(&self) -> String;
	fn amount(&self) -> i64;
}

impl Create for Cash {
	fn currency(&self) -> String {
		String::from(&self.currency)
	}

	fn amount(&self) -> i64 {
		self.amount
	}
}