use crate::structs::cash::Cash;

pub trait Create {
    fn currency(&self) -> String;
    fn amount(&self) -> i64;
}

impl Create for Cash {
    fn currency(&self) -> String {
        String::from(&self.currency)
    }

    fn amount(&self) -> i64 {
        self.amount
    }
}