pub struct Cash {
    pub currency: String,
    pub amount: i64,
}

#[path = "../traits/create.rs"]
pub mod create;
use create::Procedures;

impl Procedures for Cash {
    fn create(currency: String, amount: i64) -> Self {
        Self {
            currency: String::from(currency),
            amount: amount,
        }
    }

    fn currency(&self) -> String {
        String::from(&self.currency)
    }

    fn amount(&self) -> i64 {
        self.amount
    }
}

#[path = "../traits/calculate.rs"]
pub mod calculate;
use calculate::Operations;

impl Operations for Cash {
    fn add(&self, amount: i64) -> Self {
        let new_amount: i64 = &self.amount + amount;
        Self {
            currency: String::from(&self.currency),
            amount: new_amount,
        }
    }

    fn subtract(&self, amount: i64) -> Self {
        let new_amount: i64 = &self.amount - amount;
        Self {
            currency: String::from(&self.currency),
            amount: if new_amount < 0 { 0 } else { new_amount },
        }
    }

    fn multiply(&self, amount: i64) -> Self {
        let new_amount: i64 = &self.amount * amount;
        Self {
            currency: String::from(&self.currency),
            amount: new_amount,
        }
    }

    fn divide(&self, amount: i64) -> Self {
        let new_amount: i64 = &self.amount / amount;
        Self {
            currency: String::from(&self.currency),
            amount: if new_amount < 0 { 0 } else { new_amount },
        }
    }
}