// #[path = "../cash.rs"]
// mod cash;
// use cash::Cash;

use super::Cash;

pub trait Procedures {
    fn create(currency: String, amount: i64) -> Self;
    fn currency(&self) -> String;
    fn amount(&self) -> i64;
}

impl Procedures for Cash {
    fn create(currency: String, amount: i64) -> Self {
        Self {
            currency: String::from(currency),
            amount: amount,
        }
    }

    fn currency(&self) -> String {
        String::from(&self.currency)
    }

    fn amount(&self) -> i64 {
        self.amount
    }
}