fn main() {
    release_profile();
    crate_io_doc();
    pub_use();
    crate_io_release();
}

fn release_profile() {
    // release profile
        // 是可预定义的
        // 可自定义：可使用不同的配置，对代码编译拥有更多的控制
    // 每个profile的配置都独立于其它的profile
    // Cargo 主要的两个profile:
        // dev profile: 适用于开发， cargo build
        // release profile: 适用于发布，cargo build --release
    println!("release profile ====================");

    // 针对每个profile, Cargo都提供了默认的配置
    // 如果想自定义某profile的配置：比如自定义release profile配置
        // 可以在Cargo.toml里添加[profile.release]区域，在里面覆盖默认配置的子集，具体见Cargo.toml
}

fn crate_io_doc() {
    // 可以通过发布包来共享你的代码
    // crate的注册表在：https://crates.io/
        // 它会分发已注册的包的源代码（开发者上传的代码）
        // 主要托管开源的代码

    println!("\ncrate io ====================");
    // 文档注释：用于生成文档
        // 生成HTML文档
        // 显示公共API的文档注释：如何使用API
        // 使用"///"来注释生成文档
        // 可以使用markdown语法
        // 放置在被说明条目之前
        // 例子： 见src/lib.rs
    // 生成文档的命令： cargo doc
        // 它会运行rustdoc工具（Rust安装包自带）
        // 把生成的HTML文档放在target/doc/cargo_crateio目录下
    // 生成文档并同时在浏览器中打开文档：cargo doc --open
    // 常用章节，或者说区域
        // Examples: 示例代码区域。使用方法：具体见src/lib.rs
        // Panics: 函数可能发生panic的场景
        // Errors: 如果函数返回Result, 描述可能的错误类型，以及可导致错误的条件
        // Safety: 如果函数处于unsafe调用，就应该解释函数unsafe的原因，以及调用者确保的使用前提
    // 文档注释作为测试
        // Examples示例代码块的附加值
            // 运行cargo test: 将把文档注释中的示例代码作为测试来运行
    // 为包含注释的crate或mod等super条目，添加文档注释, 具体见src/lib.rs
        // 符号： “//!“
        // 这类注释通常用于描述crate和mod
            // crate root(按惯例src/lib.rs)
            // 一个模块内，将crate或mod作为一个整体进行描述
}

fn pub_use() {
    println!("\npub use ====================");
    // 使用pub use导出方便使用的公共API
    // 问题：crate的程序结构在开发时对于开发者很合理，但对于它的使用者不够方便
        // 开发者会把程序结构分为很多层，使用者想找到这种深层结构中的某个类型很费劲
        // 例如：
        // 麻烦：my_crate::some_module::another_module::UsefulType;
        // 方便：my_crate::UsefulType;
    // 解决办法：见src/lib.rs line20, 使
    // 用pub use将需要的深层结构的类型导出,这样生成的文档首页即可看到指定的类型
        // 不需要重新组织内部代码结构
        // 使用pub use: 可以重新导出，创建一个与内部私有结构不同的对外公共结构
    use cargo_crateio::PrimaryColor;
    use cargo_crateio::SecondaryColor;
    use cargo_crateio::mix;

    let c1 = PrimaryColor::Red;
    let c2 = PrimaryColor::Blue;
    let c_mix: SecondaryColor = mix(c1, c2);
    println!("mix color: {:?}", c_mix);
}

fn crate_io_release() {
    println!("\ncrates release ====================");
    println!("    \
    first step: Log in with github account.
    second step: Account settings => API Access (New Token) => generate your API token by input the crate's name `cargo_crateio`.
    third step: run CMD => cargo login YOUR_API_TOKEN.")
    // 运行cargo login [你的API token]
        // 将通知cargo, 把你的API token存储在本地 ~/.cargo/credentials
        // 不要把你的API token泄露给其他人，如果不小心泄露，就去crates.io上进行撤销并重新生成一个新的API token
    // ensure your crate's name `cargo_crateio` is available (not exist in crates.io) by searching it in crates.io
    // 为新的crate添加元数据，在发布crate前，需要在Cargo.toml的[package]区域为crate添加一些元数据：
        // crate需要唯一的名字： name, 和上上行一个意思
        // description: 一两句话即可，会出现在crate搜索的结果里
        // license: 需提供诃可证标识值(可到http://spdx.org/licenses/查找)
            // 可指定多个license, 用OR隔开
        // version
        // author
    // 发布cargo: cargo publish命令
        // 设置好所有字段后，发布时，可能会提示有文件未提交，可提交文件或都加上--allow-dirty选项
        // 仍然报错，因为没有设置并验证邮箱（需要在crates.io上，Account settings中设置并验证邮箱）
}