// 为当前crate添加文档注释
//! # cargo_crateio
//! 
//! `cargo_crateio` is a test to make me to understand the documents generating.
/// Adds one to the number given.
/// 
/// # Examples
/// 
/// ```
/// let arg = 5;
/// let answer = cargo_crateio::add_one(arg);
/// 
/// assert_eq!(6, answer);
/// ```
pub fn add_one(x: i32) -> i32 {
	x + 1
}

// pub use
// 使用pub use导出后，导入时，只需要use crate::PrimaryColor即可, 见main.rs line68
pub use self::kinds::PrimaryColor;
pub use self::kinds::SecondaryColor;
pub use self::utils::mix;

pub mod kinds {
	/// The primary colors
	#[derive(Debug)]
	pub enum PrimaryColor {
		Red,
		Yellow,
		Blue,
	}

	#[derive(Debug)]
	/// The secondary colors
	pub enum SecondaryColor {
		Orange,
		Green,
		Purple,
	}
}

pub mod utils {
	use crate::kinds::*;

	/// Combines two primary colors together to create a new color.
	pub fn mix(c1: PrimaryColor, c2: PrimaryColor) -> SecondaryColor {
		println!("{:?}, {:?}", c1, c2);
		SecondaryColor::Green
	}
}