# cargo-xdk - Build Rust code for Android

This cargo extension handles all the environment configuration needed for successfully building libraries
for Android from a Rust codebase, with support for generating the correct `jniLibs` directory structure.

## Installing

```
cargo install cargo-xdk
```

You'll also need to install all the toolchains you intend to use. Simplest way is with the following:

```
rustup target add \
    aarch64-linux-android \
    armv7-linux-androideabi \
    x86_64-linux-android \
    i686-linux-android
```

Modify as necessary for your use case.

## Usage

If you have installed the NDK with Android Studio to its default location, `cargo ndk` will automatically detect
the most recent NDK version and use it. This can be overriden by specifying the path to the NDK root directory in
the `ANDROID_NDK_HOME` environment variable.

### Example: building a library for 32-bit and 64-bit ARM systems

```
cargo ndk -t armeabi-v7a -t arm64-v8a -o ./jniLibs build --release 
```

This specifies the Android targets to be built, the output directory to use for placing the `.so` files in the layout
expected by Android, and then the ordinary flags to be passed to `cargo`.

![Example](./example/example.svg)

### Supported hosts

- Linux
- macOS (x86_64 and arm64)
- Windows

### Why not using cargo-ndk?

This project is just a fork of [cargo-ndk](https://github.com/bbqsrc/cargo-ndk); But the author refused to add features, such as [#43](https://github.com/bbqsrc/cargo-ndk/pull/43), so I republish it.

## Similar projects

* [cargo-lipo](https://github.com/TimNN/cargo-lipo) - for building iOS universal Rust libraries

## License

This project is licensed under either of

 * Apache License, Version 2.0 ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)