use std::{env::Args, process::Command};

// Copyright (c) 2021-present, Cruise LLC
//
// This source code is licensed under the Apache License, Version 2.0,
// found in the LICENSE-APACHE file in the root directory of this source tree.
// You may not use this file except in compliance with the License.

fn main() {
    let args = &mut std::env::args();
    if args.len() < 2 {
        println!("Usage cargo wrflib [command] [options]");
        return;
    }

    let cmd = args.nth(1).unwrap();
    match cmd.as_str() {
        "install_deps" => install_deps(),
        "build" => build(args),
        _ => {
            println!("Unknown command {}", cmd);
        }
    }
}

fn install_deps() {
    println!("Installing deps");
}

fn build(args: &mut Args) {
    println!("    Running cargo build {:?}", &args);

    let out = Command::new("cargo")
        .env(
            "RUSTFLAGS",
            "-C target-feature=+atomics,+bulk-memory,+mutable-globals,+simd128 -C link-arg=--max-memory=4294967296 -C \
             link-arg=--export=__stack_pointer",
        )
        .arg("+nightly-2021-08-03")
        .arg("build")
        .arg("--target=wasm32-unknown-unknown")
        .arg("-Zbuild-std=std,panic_abort")
        .arg("--release")
        .output()
        .expect("Failed to execute command");
    println!("{}", std::str::from_utf8(&out.stdout).ok().unwrap());
    println!("{}", std::str::from_utf8(&out.stderr).ok().unwrap());
}
