use crate::prelude::*;
use crate::Project;
use std::convert::TryFrom;
use std::ffi::OsStr;

pub struct UAT {

}

impl UAT {
    fn find_project() -> Result<Project> {
        let current_dir = std::env::current_dir()?;
        let project = current_dir
            .read_dir()?
            .filter_map(|entry| entry.ok())
            .find(|entry| entry.path().extension() == Some(&OsStr::new("uproject")))
            .ok_or_else(|| Error::Message("Failed to find *.uproject".into()))?;
        Project::try_from(project.path())
    }

    fn ue4editor_cmd(project: &Project) -> String {
        format!("C:/Program Files/Epic Games/UE_{}/Engine/Binaries/Win64/UE4Editor-Cmd.exe", project.engine_association)
    }

    fn uat(project: &Project) -> String {
        format!("C:/Program Files/Epic Games/UE_{}/Engine/Build/BatchFiles/RunUAT.bat", project.engine_association)
    }

    pub fn editor() -> Result<()> {
        let project = Self::find_project()?;
        std::process::Command::new(Self::ue4editor_cmd(&project))
            .arg(project.path)
            .status()?;
        Ok(())
    }

    // TODO: https://unrealcommunity.wiki/how-to-package-your-game-with-commands-uq8b4tix
    pub fn build() -> Result<()> {
        let project = Self::find_project()?;
        std::process::Command::new(Self::uat(&project))
            .arg("BuildCookRun")
            .arg(format!("-project=\"{}\"", project.path.display()))
            .arg("-noP4")
            .arg("-platform=Win64")
            .arg("-clientconfig=Development")
            .arg("-serverconfig=Development")
            .arg("-cook")
            .arg("-allmaps")
            .arg("-build")
            .arg("-stage")
            .arg("-pak")
            .arg("-archive")
            .arg("-archivedirectory=\"output\"")
            .status()?;
        Ok(())
    }

    pub fn cook() -> Result<()> {
        Ok(())
    }

    pub fn run() -> Result<()> {
        Ok(())
    }
}