
mod module;
mod plugin;

pub use module::*;
pub use plugin::*;

use crate::prelude::*;
use std::convert::TryFrom;
use std::path::PathBuf;
use serde::{Serialize, Deserialize};

#[derive(Debug, Clone, Serialize, Deserialize, PartialEq)]
#[serde(rename_all = "PascalCase")]
pub struct Project {
    #[serde(skip)]
    pub path: PathBuf,
    pub file_version: usize,
    pub engine_association: String,
    pub category: String,
    pub description: String,
    pub modules: Vec<Module>,
    pub plugins: Vec<Plugin>,
    pub epic_sample_name_hash: Option<String>
}

impl TryFrom<PathBuf> for Project {
    type Error = Error;
    fn try_from(path: PathBuf) -> Result<Self> {
        let content = std::fs::read_to_string(&path)?;
        let mut project: Self = serde_json::from_str(&content)?;
        project.path = path;
        Ok(project)
    }
}