#[derive(Debug)]
pub enum Error {
    Message(String),
    Other(Box<dyn std::error::Error>)
}

impl<T: std::error::Error + 'static> From<T> for Error {
    fn from(e: T) -> Self {
        Self::Other(Box::new(e))
    }
}

pub type Result<T> = std::result::Result<T, Error>;