use internal::{dirs::corpus_directory_from_target, examples};
use predicates::prelude::*;
use std::fs::{read_dir, remove_dir_all};

const CRASH_TIMEOUT: &str = "60";

const HANG_TIMEOUT: &str = "120";

#[test]
fn consolidate_crashes() {
    consolidate(
        "assert",
        "assert::target",
        &["--run-until-crash", "--", "-V", CRASH_TIMEOUT],
        "Args { x: true }",
    );
}

#[test]
fn consolidate_hangs() {
    consolidate(
        "parse_duration",
        "parse_duration::parse",
        &["--persistent", "--", "-V", HANG_TIMEOUT],
        "",
    );
}

fn consolidate(name: &str, target: &str, fuzz_args: &[&str], pattern: &str) {
    let corpus = corpus_directory_from_target(name, target);

    remove_dir_all(&corpus).unwrap_or_default();

    examples::test(name, &format!("{}::test", name))
        .unwrap()
        .assert()
        .success();

    assert_eq!(read_dir(&corpus).unwrap().count(), 1);

    let mut args = vec!["--no-ui"];
    args.extend_from_slice(fuzz_args);

    examples::test_fuzz(target)
        .unwrap()
        .args(args)
        .assert()
        .success();

    examples::test_fuzz(target)
        .unwrap()
        .args(&["--consolidate"])
        .assert()
        .success();

    assert!(read_dir(&corpus).unwrap().count() > 1);

    examples::test_fuzz(target)
        .unwrap()
        .args(&["--display-corpus"])
        .assert()
        .success()
        .stdout(predicate::str::contains(pattern));
}
