use clap::Parser;
use std::path::PathBuf;

#[derive(Debug, Parser)]
#[clap(version, author)]
pub struct Command {
    #[cfg(feature = "audit")]
    #[clap(short, long)]
    pub audit: bool,
    #[cfg(feature = "audit")]
    #[clap(long, default_value = "audit.json")]
    pub audit_path: PathBuf,
    #[cfg(feature = "clippy")]
    #[clap(short, long)]
    pub clippy: bool,
    #[cfg(feature = "clippy")]
    #[clap(long, default_value = "clippy.json")]
    pub clippy_path: PathBuf,
    #[clap(short, long, default_value = "sonar.json")]
    pub sonar_path: PathBuf,
}
