# cargo-sonar

`cargo-sonar` help you to use the tools of the Rust community and report the information to Sonarcloud (or Sonarqube). You can even set it up in a Continuous Integration so this report is automatically forwarded to Sonar.

# TODO

- [X] add `tracing` for logging
- [X] add a good error handling with `anyhow` (or `eyre`?)
- [X] change error handling from 'anyhow' to 'eyre' for coloration and nice report
- [X] add transformation for `cargo-audit`
- [ ] add `cargo-outdated` parsing
- [ ] add `cargo-deny` parsing
- [ ] call automatically `sonar-scanner`?
- [ ] check for presence of binaries (`cargo-clippy`, `cargo-audit`, `cargo-outdated`, `sonar-scanner`)
- [X] add CI
- [ ] open-source the project
- [ ] publish the binary on crates.io (see with `cargo-release`)
- [ ] use `cargo-chef` to speed up the Docker image's build (https://windsoilder.github.io/writing_dockerfile_in_rust_project.html)
- [ ] add a `Dockerfile` (for Github Actions, see below)
- [ ] create a Github Action (see [Docker Github Action](https://docs.github.com/en/actions/creating-actions/creating-a-docker-container-action))
