# `cargo-release` Reference

## CLI Arguments

| Argument        | Format | Description |
|-----------------|--------|-------------|
| `--dry-run`     | bool   | Do nothing; report what would happen |
| `--no-confirm`  | bool   | Release the crate without the user verifying what will happen. |
| `--isolated`    | bool   | Do not search for config files |
| `--config`      | string | Load a config file from disk |
| `<LEVEL>`       | string | Bump specified version field. |
| `--metadata`    | string | Populate the metadata field in the version. |
| `--token`       | string | Token to use when running `cargo publish` |

### Bump level

* `release` (default): Remove the pre-release extension; if any (0.1.0-dev.1 -> 0.1.0, 0.1.0 -> 0.1.0).
* `patch`:
  * If version has a pre-release, then the pre-release extension is removed (0.1.0-dev.1 -> 0.1.0).
  * Otherwise, bump the patch field (0.1.0 -> 0.1.1)
* `minor`: Bump minor version (0.1.0-pre -> 0.2.0)
* `major`: Bump major version (0.1.0-pre -> 1.0.0)
* `alpha`, `beta`, and `rc`: Add/increment pre-release to your version
  (1.0.0 -> 1.0.1-rc.1, 1.0.1-dev -> 1.0.1-rc.1, 1.0.1-rc.1 ->
  1.0.1-rc.2)
* *[version]*: bump version to given version. The version has to
  be a valid semver string and greater than current version as in
  semver spec.

## Configuration

### Sources

Configuration is read from the following (in precedence order)

- Command line arguments
- File specified via `--config PATH`
- `$CRATE/Cargo.toml` (`[package.metadata.release]` table)
- `$CRATE/release.toml`
- `$WORKSPACE/release.toml`
- `$HOME/.release.toml`

### Config Fields

| Field          | Argument        | Format | Description |
|----------------|-----------------|--------|-------------|
|                | `--prev-tag-name` | string | Last released tag; used for seeing what changed in the current release (default based on `tag-name` and current version in `Cargo.toml`) |
| `exclude-paths`| \-              | list of path globs | List of path globs (`gitignore` style) for what files should be ignored when change-tracking (sub-crates are already ignored). |
| `sign-commit`  | `--sign-commit` | bool   | Use GPG to sign git commits and tag generated by cargo-release. [Further information](https://git-scm.com/book/en/v2/Git-Tools-Signing-Your-Work). In 0.14 `sign-commit` is to control signing for commit only, use `sign-tag` for tag signing. |
| `sign-tag`     | `--sign-tag`    | bool   | Use GPG to sign git tag generated by cargo-release. |
| `push-remote`  | `--push-remote` | string | Default git remote to push |
| `registry`     | `--registry`    | string | Cargo registry name to publish to (default uses Rust's default, which goes to `crates.io`) |
| `disable-release` | `--exclude`  | bool   | Skip the entire release process (usually for internal crates in a workspace) |
| `disable-push` | `--skip-push`   | bool   | Don't do git push |
| `disable-tag`  | `--skip-tag`    | bool   | Don't do git tag |
| `disable-publish` | `--skip-publish` |  bool | Don't do cargo publish right now, see [manifest `publish` field](https://doc.rust-lang.org/cargo/reference/manifest.html#the-publish--field-optional) to permanently disable publish. |
| `consolidate-commits` | \- | bool | When releasing a workspace, use a single commit for the pre-release version bump and a single commit for the post-release version bump. |
| `pre-release-commit-message` | \- | string | A commit message template for release. For example: `"release {{version}}"`, where `{{version}}` will be replaced by actual version. |
| `post-release-commit-message` | \- | string | A commit message template for bumping version after release. For example: `Released {{version}}, starting {{next_version}}`. The placeholder `{{next_version}}` (the version in git after release) is supported in addition to the global placeholders mentioned below. |
| `tag-message`  | \-              | string | A message template for tag. The placeholder `{{tag_name}}` and `{{prefix}}` (the tag prefix) is supported in addition to the global placeholders mentioned below. |
| `tag-prefix`   | `--tag-prefix`  | string | Prefix of git tag, note that this will override default prefix based on crate name. |
| `tag-name`     | `--tag-name`    | string | The name of the git tag.  The placeholder `{{prefix}}` (the tag prefix) is supported in addition to the global placeholders mentioned below. |
| `dev-version-ext` | `--dev-version-ext` | string | Pre-release extension to use on the next development version. |
| `no-dev-version` | `--no-dev-version` |  bool | Disable version bump after release. |
| `pre-release-replacements` | \-   | array of tables (see below) | Specify files that cargo-release will search and replace with new version for the release commit |
| `post-release-replacements` | \-   | array of tables (see below) | Specify files that cargo-release will search and replace with new version for the post-release commit (the one starting development) |
| `pre-release-hook` | \-          | list of arguments | Provide a command to run before `cargo-release` commits version change. If the return code of hook command is greater than 0, the release process will be aborted. |
| `enable-features` | `--features` | list of names | Provide a set of feature flags that should be passed to `cargo publish` (requires rust 1.33+) |
| `all-features` | `--all-features` | bool  | Signal to `cargo publish`, that all features should be used (requires rust 1.33+) |

### Supported Environment Variables

* `PUBLISH_GRACE_SLEEP`: sleep timeout between crates publish when releasing from workspace. This is a workaround to make previous crate discoveriable on crates.io.  

### {Pre,Post}-release Replacements

This field is an array of tables with the following

* `file`: the file to search and replace
* `search`: regex that matches string you want to replace
* `replace`: the replacement string; you can use the any of the placeholders mentioned below.
* `min` (default is `1`): Minimum occurrences of `search`.
* `max` (optional): Maximum occurrences of `search`.
* `exactly` (optional): Number of occurrences of `search`.
* `prerelease` (default is `false`): Run the replacement when bumping to a pre-release level.

See [release.toml](https://github.com/sunng87/cargo-release/blob/master/release.toml) for example.

### Placeholders

The following placeholders in configuration values will be be replaced with the desired value:

* `{{prev_version}}`: The version before `cargo-release` was executed (before any version bump).
* `{{version}}`: The current (bumped) crate version.
* `{{next_version}}` (only valid for `post-release-{commit-message,replacements}`): The crate version for starting development.
* `{{crate_name}}`: The name of the current crate in `Cargo.toml`.
* `{{date}}`: The current date in `%Y-%m-%d` format.
* `{{prefix}}` (only valid for `tag-name` / `tag-message`): The value prepended to the tag name.
* `{{tag_name}}` (only valid for `tag-message`): The name of the git tag.

### Hook Environment Variables.

The following environment variables are made available to `pre-release-hook`:

* `PREV_VERSION`: The version before `cargo-release` was executed (before any version bump).
* `NEW_VERSION`: The current (bumped) crate version.
* `DRY_RUN`: Whether the release is actually happening (`true` / `false`)
* `CRATE_NAME`: The current (bumped) crate version.
* `WORKSPACE_ROOT`: The path to the workspace.
* `CRATE_ROOT`: The path to the crate.
