# cargo-profile

Profiling rust program made easy.

# Installation

```sh
cargo install cargo-profile
```

# Features

## instrument

Supported os: `mac os`.

Fork of https://github.com/cmyr/cargo-instruments, but uses `cargo` cli for compilation to avoid removing cache.

### Usage

```
cargo profile instruments -t time bench --bench parser
```

## flamegraph

Supported os: `linux`, `mac os`.

### Usage

```sh
# Just use cargo's syntax
cargo profile flamegraph bench --lib
# If you have a my_bench in benches directory, you can do
cargo profile flamegraph bench --bench my_bench
```

## bin-path

Binaries built by cargo have some random strings as a suffix, and it makes invoking files generated by cargo harder.
Here comes `cargo profile bin-path` to aid it.

### Usage

```sh
perf record `cargo profile bin-path bench --bench fixture`
```

## cpu time profiling

You can get cpu time usage per function on mac os using the command below.

(For linux, you can use perf directly, although I'll add linux aupport soon.)

### Usage

```sh
cargo profile cpu per-fn bench --bench fixture
```

## trace

Note: It **does not** support `dtrace` and `perf` yet. Same as above, I'll implement it if there's a need.

### xctrace

`xctrace` is a tool to profile applications on

#### Usage

```sh
cargo profile trace xctrace bench --lib

cargo profile trace xctrace bench --bench my_bench
```

## License

Licensed under either of

- Apache License, Version 2.0
  ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
- MIT license
  ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.
