
* [Overview](#overview)
* [Installation](#installation)
    * [Binary Release](#installation-binary-release)
* [Usage](#usage)
    * [Simple Example](#usage-simple)
    * [Tasks, Dependencies and Aliases](#usage-task-dependencies-alias)
    * [Commands, Scripts and Sub Tasks](#usage-task-command-script-task)
        * [Sub Task](#usage-task-command-script-task-examplesubtask)
        * [Command](#usage-task-command-script-task-examplecommand)
        * [Script](#usage-task-command-script-task-examplescript)
        * [Duckscript](#usage-task-command-script-task-exampleduckscript)
        * [Rust Code](#usage-task-command-script-task-examplerust)
        * [Cross Platform Shell](#usage-task-command-script-task-exampleshell2batch)
        * [Other Programming Languages](#usage-task-command-script-task-examplegeneric)
        * [Shebang Support](#usage-task-command-script-task-exampleshebang)
    * [Default Tasks and Extending](#usage-default-tasks)
        * [Extending External Makefiles](#usage-workspace-extending-external-makefile)
        * [Automatically Extend Workspace Makefile](#usage-workspace-extend)
        * [Load Scripts](#usage-load-scripts)
        * [Predefined Makefiles](#usage-predefined-makefiles)
    * [Extending Tasks](#usage-extending-tasks)
        * [Task Override](#usage-task-override)
        * [Platform Override](#usage-platform-override)
        * [Extend Attribute](#usage-task-extend-attribute)
    * [Environment Variables](#usage-env)
        * [Global Configuration](#usage-env-config)
        * [Task](#usage-env-task)
        * [Command Line](#usage-env-cli)
        * [Env File](#usage-env-file)
        * [Env Setup Scripts](#usage-env-setup-scripts)
        * [Loading Order](#usage-env-vars-loading-order)
        * [Global](#usage-env-global)
    * [Ignoring Errors](#usage-ignoring-errors)
    * [Conditions](#usage-conditions)
        * [Criteria](#usage-conditions-structure)
        * [Scripts](#usage-conditions-script)
        * [Combining Conditions and Sub Tasks](#usage-conditions-and-subtasks)
    * [Installing Dependencies](#usage-installing-dependencies)
        * [Cargo Plugins](#usage-installing-cargo-plugins)
        * [Crates](#usage-installing-crates)
        * [Rustup Components](#usage-installing-rustup-components)
        * [Native Dependencies](#usage-installing-native-dependencies)
        * [Defining Version](#usage-installing-version)
        * [Global Lock Of Versions](#usage-installing-locked)
        * [Alternate Cargo Install Commands](#usage-installing-alternate-cargo-install-commands)
        * [Installation Priorities](#usage-installing-dependencies-priorities)
        * [Multiple Installations](#usage-installing-dependencies-multiple)
    * [Workspace Support](#usage-workspace-support)
        * [Disabling Workspace Support](#usage-workspace-disabling-workspace-support)
        * [Composite Flow](#usage-workspace-composite-flow)
        * [Profiles](#usage-workspace-profiles)
        * [Skipping/Including Specific Members](#usage-workspace-support-skip-include-members)
        * [Workspace Emulation](#usage-workspace-emulation)
    * [Toolchain](#usage-toolchain)
    * [Init and End tasks](#usage-init-end-tasks)
    * [Catching Errors](#usage-catching-errors)
    * [Cargo Alias Tasks](#usage-cargo-alias-tasks)
    * [Profiles](#usage-profiles)
        * [Environment Variables](#usage-profiles-env)
        * [Conditions](#usage-profiles-conditions)
        * [Built In Profiles](#usage-profiles-built-in)
    * [Private Tasks](#usage-private-tasks)
    * [Deprecated Tasks](#usage-deprecated-tasks)
    * [Watch](#usage-watch)
    * [Functions](#usage-functions)
        * [Split](#usage-functions-split)
        * [GetAt](#usage-functions-getat)
        * [Remove Empty](#usage-functions-remove-empty)
        * [Trim](#usage-functions-trim)
        * [Decode](#usage-functions-decode)
    * [Continuous Integration](#usage-ci)
        * [Github Actions](#usage-ci-github-actions)
        * [Travis](#usage-ci-travis)
        * [AppVeyor](#usage-ci-appveyor)
        * [GitLab](#usage-ci-gitlab)
        * [CircleCI](#usage-ci-circleci)
        * [Azure Pipelines](#usage-ci-azure-pipelines)
        * [drone.io](#usage-ci-drone-io)
        * [Cirrus CI](#usage-ci-cirrus)
    * [Predefined Flows](#usage-predefined-flows)
        * [Coverage](#usage-predefined-flows-coverage)
        * [Full List](https://github.com/sagiegurari/cargo-make/blob/master/docs/cargo_make_task_list.md)
        * [Disabling Predefined Tasks/Flows](#usage-predefined-flows-disable)
        * [Modifying Predefined Tasks/Flows](#usage-predefined-flows-modify)
    * [Minimal Version](#usage-min-version)
    * [Performance Tuning](#usage-performance-tuning)
    * [Command Groups](#usage-command-groups)
    * [Diff Changes](#usage-diff-changes)
    * [Cli Options](#usage-cli)
    * [Plugins](#usage-plugins)
        * [Defining Plugins](#usage-plugins-defining-plugins)
        * [Plugin SDK](#usage-plugins-plugin-sdk)
        * [Plugin Example (Docker Integration)](#usage-plugins-plugin-example-dockerize)
        * [Plugin Example (load env from rust script)](#usage-plugins-plugin-example-rustenv)
    * [Shell Completion](#usage-shell-completion)
        * [Bash](#usage-shell-completion-bash)
        * [zsh](#usage-shell-completion-zsh)
    * [Global Configuration](#cargo-make-global-config)
* [Makefile Definition](#descriptor-definition)
* [Task Naming Conventions](#task-name-conventions)
* [Articles](#articles)
    * [Introduction and Basics](https://medium.com/@sagiegurari/automating-your-rust-workflows-with-cargo-make-part-1-of-5-introduction-and-basics-b19ced7e7057)
    * [Extending Tasks, Platform Overrides and Aliases](https://medium.com/@sagiegurari/automating-your-rust-workflows-with-cargo-make-part-2-of-5-extending-tasks-platform-overrides-1527386dcf87)
    * [Environment Variables, Conditions, Sub Tasks and Mixing](https://medium.com/@sagiegurari/automating-your-rust-workflows-with-cargo-make-part-3-of-5-environment-variables-conditions-3c740a837a01)
    * [Workspace Support, Init/End Tasks and Makefiles](https://medium.com/@sagiegurari/automating-your-rust-workflows-with-cargo-make-part-4-of-5-workspace-support-init-end-tasks-c3e738699421)
    * [Predefined Tasks, CI Support and Conventions](https://medium.com/@sagiegurari/automating-your-rust-workflows-with-cargo-make-part-5-final-predefined-tasks-ci-support-and-4594812e57da)
* [Badge](#badge)
* [Roadmap](#roadmap)
* [Editor Support](#editor-support)
    * [vim](#editor-support-vim)
    * [vs-code](#editor-support-vs-code)
* [Contributing](https://github.com/sagiegurari/cargo-make/blob/master/.github/CONTRIBUTING.md)
* [Release History](https://github.com/sagiegurari/cargo-make/blob/master/CHANGELOG.md)
* [License](#license)
