use crate::{
    io::Buffers,
    models::{EditorData, SourceFile},
    options::Options,
    process, Messages,
};
use anyhow::{Context, Result};
use cargo_metadata::{
    diagnostic::{DiagnosticLevel, DiagnosticSpan},
    CompilerMessage, Message,
};
use getset::CopyGetters;
use itertools::{Either, Itertools};
use process::{failed_to_execute_error_text, CargoProcess};
use std::{
    collections::HashSet,
    io::Write,
    path::Path,
    process::{Command, Stdio},
    time::Duration,
};

pub struct FilteredMessages {
    errors: Vec<CompilerMessage>,
    warnings: Vec<CompilerMessage>,
}

impl FilteredMessages {
    pub fn filter(parsed_messages: Messages, options: &Options, workspace_root: &Path) -> Self {
        let parsed_messages = parsed_messages.dumb();
        let warnings = if options.show_dependencies_warnings() {
            parsed_messages.non_errors
        } else {
            parsed_messages
                .non_errors
                .into_iter()
                .filter(|i| i.target.src_path.starts_with(workspace_root))
                .collect()
        };

        let errors = parsed_messages
            .internal_compiler_errors
            .into_iter()
            .chain(parsed_messages.errors.into_iter())
            .collect();

        Self { errors, warnings }
    }
}
