# Using in organizations and businesses

`cargo-crev` is being developed with an explicit goal of supporting teams,
groups, businesses and even very large organizations. It is our belief that
companies developing software using Open Source code, have an important need to
ensure integrity and trustworthiness of Open Source code they include.

Because of that belief, we encourage groups interested in using `crev` to voice
their opinions and needs, so we can address them as fast as possible. We're
hopping that by making `cargo-crev` useful for them, we can quickly bootstrap a
vibrant ecosystem of code review.

This document describes the general vision of how to utilize `cargo-crev` in a
software organization. A general knowledge of `cargo-crev` might be helpful, so
make sure to read [Getting Started Guide](../getting_started/index.html) first.

## Overview

Tho utilize `cargo-crev` in your organization follow the following steps:

First, a Web of Trust for the organization has to be built. A WoT starts and is
defined by a root identity, so this step means securely creating a root
identity, and deciding on how to build and maintain over time its WoT.

Then, a method of storing and circulating *proofs* generated by the members of
the organization has to be established. This typically means preparing one or
more git repositories.

At this point members can start reviewing dependencies and creating review
proofs.

The final step is to enforce code review policies automatically - for example in
the CI pipeline.

## Root identity

It's important to take security into consideration when creating the root
identity. Because of that it's recommended that it is created on a trusted
computer, by a trusted member(s) of the organization (eg. a security officer).
Care must be taken to properly store and secure the private key of this
identity.

The purpose of this ID would is to serve , and it is typically going to be used
only passively.

Root identity is usually used passively as a root of trust for the whole
organization. It will only be actively used to sign new *trust proofs*: adding
(or removing) other identities used inside the organization.

The identities used by the individual contributors can be self-created, and
managed by their respective owners. After creation they can be submitted for
inclusion into the WoT of the organization.

In case of a very large organization, a hierarchy of identities can be
established with intermediate identities managed by particular groups and teams.
This can help distribute the process of signing identities, and help keep the
root identity offline and secure.

## Proof management

A shared git repository can be used for all identities within the organization.
Alternatively each individual can use their own git repository to publish their
reviews.

Depending on the code review policy, proofs created by individual contributors
can be internal, or publicly available. Sharing code reviews with wider
community can be a proof of a concious approach to security, and a form of
giving back to the community.

## Enforcing code review policy

`cargo-crev` implements dependency trust verification from the perspective of an
arbitrary identity.

``` text
cargo crev crate verify --for-id <rootID>
```

is the basic way to verify review status of all the packages from the
perspective of the `rootID`. This can used locally be every developer. It can
also be set up as a part of a CI pipeline - the returned exit code will signal
the verification status.

Other configuration options can define the exact details required for passing
the verification: number of reviews required, minimum thoroughness, etc.

## Help us help you

We're very interested in improving `crev` project to be more suitable for
organizations. Please create a github issue, or contact us on the gitter channel
to discuss your needs.
