use crate::Variable;

/// Basic inbuilt types for Cardinal's IR.
/// `ValueType` is used for type definitions.
#[derive(Copy, Clone)]
pub enum Value {
	/// Integer with a maximum value of 255 and a minimum value of -255
	I8(i8),

	/// Integer with a maximum value of 65,536 and a minimum value of -65,536
	I16(i16),

	/// Integer with a maximum value of 65536^2 and a minimum value of -65,536^2
	I32(i32),

	/// Integer with a maximum value of 65536^4 and a minimum value of -65,536^4
	I64(i64),

	/// Unsigned integer with a maximum value of 255 and a minimum value of 0
	U8(u8),

	/// Unsigned integer with a maximum value of 65,536 and a minimum value of 0
	U16(u16),

	/// Unsigned integer with a maximum value of 65536^2 and a minimum value of 0
	U32(u32),

	/// Unsigned integer with a maximum value of 65536^4 and a minimum value of 0
	U64(u64),

	/// Boolean-style integer with a maximum value of 1 and a minimum value of 0
	B1(bool),

	/// A variable reference.
	Variable(Variable),
}

/// Type definitions for `Value`s.
pub enum ValueType {
	I8,
	I16,
	I32,
	I64,
	U8,
	U16,
	U32,
	U64,
	B1,
	Void
}