use crate::{ Value, ValueType };
use std::cell::RefCell;

pub fn resolve_type(value: Value, vars: &RefCell<Vec<ValueType>>) -> ValueType {
	match value {
		Value::B1(_) => ValueType::B1,
		Value::U8(_) => ValueType::U8,
		Value::U16(_) => ValueType::U16,
		Value::U32(_) => ValueType::U32,
		Value::U64(_) => ValueType::U64,
		Value::I8(_) => ValueType::I8,
		Value::I16(_) => ValueType::I16,
		Value::I32(_) => ValueType::I32,
		Value::I64(_) => ValueType::I64,
		Value::Variable(var) => {
			if let Some(v) = vars.borrow().get(var.0 as usize) {
				match v {
					&ValueType::B1 => ValueType::B1,
					&ValueType::U8 => ValueType::U8,
					&ValueType::U16 => ValueType::U16,
					&ValueType::U32 => ValueType::U32,
					&ValueType::U64 => ValueType::U64,
					&ValueType::I8 => ValueType::I8,
					&ValueType::I16 => ValueType::I16,
					&ValueType::I32 => ValueType::I32,
					&ValueType::I64 => ValueType::I64,
					&ValueType::Void => ValueType::Void
				}
			} else {
				ValueType::Void
			}
		}
	}
}