//! Exposes an enum of instruction Opcodes.
//! 
//! Used for generating Function instructions.

use crate::Value;

/// An enumeration of instruction Opcodes
/// for Cardinal's IR.
/// 
/// Hex names are provided in documentation.
pub enum Opcode {
	/// Adds two numbers together, overwriting the
	/// provided output variable reference.
	/// 
	/// - `x`: Output variable reference
	/// - `y`: Integer value
	/// - `z`: Integer value
	/// 
	/// ```
	/// x = y + z
	/// ```
	IntegerAdd(Value, Value, Value),

	/// Negates a number, overwriting the provided
	/// output variable reference with the result.
	/// 
	/// - `x`: Output variable reference.
	/// - `y`: Signed integer value.
	/// 
	/// ```
	/// x = -y
	/// ```
	IntegerNegate(Value, Value),
}