//! Cardinal's backend for generating IR code.
//! 
//! This module supplies a way to create IR code
//! that can later be compiled into machine code
//! for Cardinal's VM.

pub mod block;
pub mod builder;
pub mod function_builder;
pub mod function;
pub mod opcode;
pub mod resolve_type;
pub mod value;
pub mod variable;

pub use block::Block;
pub use builder::{ TraitFunctionBuilder };
pub use function_builder::{ FunctionBuilder };
pub use function::{ Function };
pub use opcode::Opcode;
pub use resolve_type::resolve_type;
pub use value::{ Value, ValueType };
pub use variable::Variable;