//! Assorted traits for instruction and
//! function building.

use crate::{ Block, Value };

/// An instruction builder trait intended for the `FunctionBuilder` struct.
/// It allows building instructions and creating blocks.
pub trait TraitFunctionBuilder {
	/// Creates a new block reference.
	/// 
	/// The first (default) block of a function has
	/// an index of 0, meaning that any blocks created
	/// will have an index of 1 or higher.
	fn create_block(self: &mut Self) -> Block;

	/// Changes which block is currently in use.
	fn use_block(self: &mut Self, bl: Block);
}

pub trait TraitInstBuilder {
	/// Adds two integers, returning a pointer to the result.
	/// 
	/// - `x`: An integer value.
	/// - `y`: An integer value.
	fn integer_add(self: &mut Self, x: Value, y: Value) -> Value;

	/// Negates a signed integer, returning a pointer to the
	/// result.
	/// 
	/// - `x`: A signed integer value.
	fn integer_negate(self: &mut Self, x: Value) -> Value;
}