pub mod instructions;
pub mod state;
pub mod errors;

use {anchor_lang::prelude::*, instructions::*};

declare_id!("crt4Ymiqtk3M5w6JuKDT7GuZfUDiPLnhwRVqymSSBBn");

#[program]
pub mod cardinal_certificate {
    use super::*;

    pub fn create_mint_manager(ctx: Context<CreateMintManagerCtx>, bump: u8) -> ProgramResult {
        create_mint_manager::handler(ctx, bump)
    }

    pub fn delete_mint_manager(ctx: Context<DeleteMintManagerCtx>) -> ProgramResult {
        delete_mint_manager::handler(ctx)
    }

    pub fn issue_certificate(ctx: Context<IssueCertificateCtx>, ix: IssueCertificateIx) -> ProgramResult {
        issue_certificate::handler(ctx, ix)
    }

    pub fn unissue_certificate(ctx: Context<UnissueCertificateCtx>) -> ProgramResult {
        unissue_certificate::handler(ctx)
    }

    pub fn set_original_mint(ctx: Context<SetOriginalMintCtx>) -> ProgramResult {
        set_original_mint::handler(ctx)
    }

    pub fn claim_certificate(ctx: Context<ClaimCertificateCtx>) -> ProgramResult {
        claim_certificate::handler(ctx)
    }

    pub fn use_certificate(ctx: Context<UseCertificateCtx>) -> ProgramResult {
        use_certificate::handler(ctx)
    }

    pub fn extend_certificate(ctx: Context<ExtendCertificateCtx>, amount: u64) -> ProgramResult {
        extend_certificate::handler(ctx, amount)
    }

    pub fn invalidate_certificate(ctx: Context<InvalidateCertificateCtx>) -> ProgramResult {
        invalidate_certificate::handler(ctx)
    }

    pub fn revoke_certificate(ctx: Context<RevokeCertificateCtx>) -> ProgramResult {
        revoke_certificate::handler(ctx)
    }

    pub fn revoke_certificate_v2(ctx: Context<RevokeCertificateV2Ctx>) -> ProgramResult {
        revoke_certificate_v2::handler(ctx)
    }
}