use {
    crate::{state::*, errors::*},
    anchor_lang::{prelude::*}
};
use anchor_spl::{
    token::{TokenAccount},
};

#[derive(Accounts)]
pub struct SetOriginalMintCtx<'info> {
    #[account(mut, constraint = certificate.state == CertificateState::Issued as u8)]
    pub certificate: Box<Account<'info, Certificate>>,
    pub original_mint_holder: Signer<'info>,
    #[account(constraint = original_mint_token_account.owner == original_mint_holder.key() && original_mint_token_account.amount > 0 @ ErrorCode::InvalidOriginalMintAccount)]
    pub original_mint_token_account: Box<Account<'info, TokenAccount>>,
}

pub fn handler(ctx: Context<SetOriginalMintCtx>) -> ProgramResult {
    let certificate = &mut ctx.accounts.certificate;
    certificate.original_mint = Some(ctx.accounts.original_mint_token_account.mint);
    return Ok(())
}