use anchor_lang::prelude::*;

#[error]
pub enum ErrorCode {
    #[msg("Issuer does not own token account")]
    IssuerMustOwnTokenAccount,
    #[msg("User is not the current owner of this certificate so cannot use it")]
    InvalidOwnership,
    #[msg("Cannot use this certificate")]
    CannotUse,
    #[msg("User cannot clawback this certificate")]
    CannotRevoke,
    #[msg("Certificate is not invalid")]
    CannotInvalidate,
    #[msg("Certificate needs to own its expiry account")]
    CertificateMustOwnTokenAccount,
    #[msg("Invalid issuer specified")]
    InvalidIssuer,
    #[msg("Recipient is not authorized to claim this certificate")]
    UnauthorizedRecipient,
    #[msg("Certificate token account is incorrect")]
    InvalidCertificateTokenAccount,
    #[msg("Certificate payment token account is incorrect")]
    InvalidCertificatePaymentTokenAccount,
    #[msg("Certificate mint is incorrect")]
    InvalidCertificateMint,
    #[msg("Freeze authority must have freeze authority of the mint")]
    InvalidFreezeAuthority,
    #[msg("Mint manager still has outstanding certificates")]
    OutstandingCertificates,
    #[msg("Invalid recipient token account")]
    InvalidRecipientTokenAccount,
    #[msg("Invalid recipient payment token account")]
    InvalidRecipientPaymentTokenAccount,
    #[msg("Invalid issuer payment token account")]
    InvalidIssuerPaymentTokenAccount,
    #[msg("Invalid original mint account")]
    InvalidOriginalMintAccount,
    #[msg("Certificate cannot be extended")]
    CannotExtend,
    #[msg("Certificate kind is invalid")]
    InvalidCertificateKind,
    #[msg("Certificate has not been issued")]
    CertificateNotIssued
}